/***************************************************************************************
	Copyright 2000-2001 ATMEL Corporation.
	
	This file is part of atmel wireless lan drivers.

    Atmel wireless lan drivers is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Atmel wireless lan drivers is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Atmel wireless lan drivers; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**************************************************************************************/
#include "xvnet.h"

int open_socket(void)
{
	int inet_sock=-1;
	int ipx_sock=-1;
	int ax25_sock=-1;
	int ddp_sock=-1;
	
	inet_sock=socket(AF_INET, SOCK_STREAM, 0);
	ipx_sock=socket(AF_IPX, SOCK_STREAM, 0);
	ax25_sock=socket(AF_AX25, SOCK_STREAM, 0);
	ddp_sock=socket(AF_APPLETALK, SOCK_STREAM, 0);
	
	if(inet_sock!=-1)
		return inet_sock;

	if(ipx_sock!=-1)
		return ipx_sock;

	if(ax25_sock!=-1)
		return ax25_sock;
	return ddp_sock;
}

void open_cards(POPEN_CARDS pOpenCards)
{
	struct iwreq wrq;
	UCHAR	Type;
	int i, temp_socket,j, res;
	int starting_eth=0;
	char ethname[8];
	
	for (i=0;i++;i<5) pOpenCards->Error[i]= -1;

	for (i=0; i<MAX_VNET_CARDS; i++)
	{
		temp_socket = open_socket();
		for (j=starting_eth; j<8; j++)
		{
			sprintf(ethname, "eth%d", j);
			strcpy(wrq.ifr_name, ethname);
			pOpenCards->Error[0]=ioctl(temp_socket, SIOCGIWNAME, &wrq);

			if( pOpenCards->Error[0]<0 ) continue;
		
			if(!memcmp(wrq.u.name,"ATMEL INTERSIL", 14))
				Type = CARD_TYPE_PCMCIA;
			else if(!memcmp(wrq.u.name,"ATMEL USB503A", 13))
				Type = CARD_TYPE_USB;
			else if(!memcmp(wrq.u.name,"ATMEL RFMD503", 13))
				Type = CARD_TYPE_USB_RFMD;
			else if(!memcmp(wrq.u.name,"ATMEL RFMD505", 13))
				Type = CARD_TYPE_USB_505;
			else if(!memcmp(wrq.u.name,"ATMEL RFMD", 10))
				Type = CARD_TYPE_PCMCIA_RFMD;
			else if(!memcmp(wrq.u.name,"ATMEL REVD", 10))
				Type = CARD_TYPE_PCMCIA_REVD;
			else if(!memcmp(wrq.u.name,"ATMEL REVE", 10))
				Type = CARD_TYPE_PCMCIA_REVE;
			else if(!memcmp(wrq.u.name,"ATMEL 504", 9))
				Type = CARD_TYPE_PCMCIA_504;
			else if(!memcmp(wrq.u.name,"ATMEL PCI", 9))
				Type = CARD_TYPE_PCMCIA_PCI;
			else
				continue;			
			pOpenCards->Error[1] = Type;
			pOpenCards->Error[2] = pOpenCards->NumOfCards;
			pOpenCards->pCardInfo[pOpenCards->NumOfCards] = (PCARD_INFO)malloc(sizeof(CARD_INFO));
			pOpenCards->fd[pOpenCards->NumOfCards] = temp_socket;
			pOpenCards->pCardInfo[pOpenCards->NumOfCards]->CardType = Type;
			starting_eth = j+1;
			strcpy(pOpenCards->pCardInfo[pOpenCards->NumOfCards]->name, wrq.ifr_name);
			pOpenCards->NumOfCards++;
			break;
		}
	}
//	printf(__FILE__" "__FUNCTION__" ctl %d type %d Num %d\n", pOpenCards->Error[0],
	//	pOpenCards->Error[1], pOpenCards->Error[2]);
}

void InitStructs(POPEN_CARDS pOpenCards)
{
	UCHAR i;
	pOpenCards->Active = 0;
	pOpenCards->NumOfCards = 0;
	memset(pOpenCards->fd, 0, 8);
	for(i=0;i<8;i++)
		pOpenCards->pCardInfo[i]=NULL;
	pOpenCards->fd_mainform			= (FD_mainform 		 *)fl_calloc(1, sizeof(FD_mainform));
	pOpenCards->fd_encryptionform	= (FD_encryptionform *)fl_calloc(1, sizeof(FD_encryptionform));
	pOpenCards->fd_monitorform 		= (FD_monitorform 	 *)fl_calloc(1, sizeof(FD_monitorform));
	pOpenCards->fd_statisticsform	= (FD_statisticsform *)fl_calloc(1, sizeof(FD_statisticsform));
	pOpenCards->fd_sitesurveyform 	= (FD_sitesurveyform *)fl_calloc(1, sizeof(FD_sitesurveyform));
	pOpenCards->fd_advancedform		= (FD_advancedform 	 *)fl_calloc(1, sizeof(FD_advancedform));
	pOpenCards->fd_versionform		= (FD_versionform 	 *)fl_calloc(1, sizeof(FD_versionform));		
}

int main(int argc, char *argv[])
{
	struct iwreq wrq;
	POPEN_CARDS  pOpenCards = (POPEN_CARDS)malloc(sizeof(OPEN_CARDS));
	
	fl_initialize(&argc, argv, 0, 0, 0);
	InitStructs(pOpenCards);	
	fl_set_border_width(-2);
//	printf("%s\n", getenv("HOME"));
	open_cards(pOpenCards);

	if (pOpenCards->NumOfCards == 0)
	{
#if defined(SMARTBRIDGES)||defined(SMARTBRIDGES_T)	
		show_error("No SmartBridges Wireless LAN Card found!", pOpenCards);
#elif defined(ATMEL)
		show_error("No ATMEL Wireless LAN Card found!", pOpenCards);
#endif
		return -ENODEV;
	}
	
	Get_Vnet_Stats(pOpenCards);
	ConvertInfo(pOpenCards);

	create_mainform(pOpenCards);
	
	make_tab(pOpenCards);
	
	pOpenCards->fd_alertform = create_alertform(pOpenCards);	
	pOpenCards->fd_warningform = create_warningform(pOpenCards);
//	pOpenCards->fd_msgform = create_msgform(pOpenCards);
	
	fl_setpup_default_fontsize(FL_SMALL_SIZE);
	fl_setpup_default_fontstyle(FL_NORMAL_STYLE);
	fl_set_form_size(pOpenCards->fd_mainform->mainform, 380, 460);
	fl_set_form_minsize(pOpenCards->fd_mainform->mainform, 380, 460);
	fl_set_form_maxsize(pOpenCards->fd_mainform->mainform, 380, 460);
/*	fl_set_form_minsize(pOpenCards->fd_msgform->msgform, 200, 60);
	fl_set_form_maxsize(pOpenCards->fd_msgform->msgform, 200, 60);*/
#if defined(SMARTBRIDGES)||defined(SMARTBRIDGES_T)
	fl_show_form(pOpenCards->fd_mainform->mainform,FL_PLACE_CENTERFREE,FL_FULLBORDER,"SmartBridges Wireless LAN Monitor Utility");
#elif defined(ATMEL)
	fl_show_form(pOpenCards->fd_mainform->mainform,FL_PLACE_CENTERFREE,FL_FULLBORDER,"ATMEL Wireless LAN Monitor Utility");
#endif
/*	fl_show_form(pOpenCards->fd_msgform->msgform,FL_PLACE_CENTERFREE,FL_NOBORDER,NULL);	
	fl_hide_form(pOpenCards->fd_msgform->msgform);*/
//	fl_set_form_atdeactivate(pOpenCards->fd_mainform->mainform ,show_wait, pOpenCards);
//	fl_set_form_atactivate(pOpenCards->fd_mainform->mainform ,hide_wait, pOpenCards);	
	while (fl_do_forms()){
		;			
	}
	return 0;
}

void make_tab(POPEN_CARDS pOpenCards)
{
	create_monitorform(pOpenCards);
	create_statisticsform(pOpenCards);
	create_sitesurveyform(pOpenCards);
	create_encryptionform(pOpenCards);
	create_advancedform(pOpenCards);
	create_versionform(pOpenCards);
	
	
	fl_addto_tabfolder(pOpenCards->fd_mainform->folder, "Monitor", 	pOpenCards->fd_monitorform->monitorform);
	fl_addto_tabfolder(pOpenCards->fd_mainform->folder, "Statistics", pOpenCards->fd_statisticsform->statisticsform);
	fl_addto_tabfolder(pOpenCards->fd_mainform->folder, "Site Survey", pOpenCards->fd_sitesurveyform->sitesurveyform);
	fl_addto_tabfolder(pOpenCards->fd_mainform->folder, "Encryption", pOpenCards->fd_encryptionform->encryptionform);
	fl_addto_tabfolder(pOpenCards->fd_mainform->folder, "Advanced", pOpenCards->fd_advancedform->advancedform);
	fl_addto_tabfolder(pOpenCards->fd_mainform->folder, "Version", pOpenCards->fd_versionform->versionform);
}

