// This file may be redistributed and modified only under the terms of
// the GNU Lesser General Public License (See COPYING for details).
// Copyright (C) 2000-2001 Stefanus Du Toit and Alistair Riddoch

#include <Atlas/Message/Encoder.h>
#include <Atlas/Objects/Root.h>

using Atlas::Message::Element;

namespace Atlas { namespace Objects {

Root::Root() : attr_parents(1, std::string("root")), attr_objtype("instance")
{
    // SetParents(Element::ListType(1,std::string("root")));
    // SetId(id);
    // SetObjtype("instance");
}

Root::Root(const char * id) : attr_id(id), attr_objtype("meta")
{
    // SetId("root");
    // SetObjtype("meta");
}

Root::Root(const char * id, const char * parent) : attr_parents(1,parent),
                                                   attr_id(id)
{
    // SetId(id);
    // SetParents(Element::ListType(1,parent));
}

Root::~Root()
{
}

Root Root::Class()
{
    Root root("root");
    return root;
}

bool Root::hasAttr(const std::string& name) const
{
    if (name == "parents") return true;
    if (name == "id") return true;
    if (name == "objtype") return true;
    if (name == "name") return true;
    return (attributes.find(name) != attributes.end());
}

Element Root::getAttr(const std::string& name) const
    throw (NoSuchAttrException) 
{
    if (name == "parents") return attr_parents;
    if (name == "id") return attr_id;
    if (name == "objtype") return attr_objtype;
    if (name == "name") return attr_name;
    Element::MapType::const_iterator I = attributes.find(name);
    if (I == attributes.end())
        throw NoSuchAttrException(name);
    return ((*I).second);
}

void Root::setAttr(const std::string& name, const Element& attr)
{
    if (name == "parents") { setParents(attr.asList()); return; }
    if (name == "id") { setId(attr.asString()); return; }
    if (name == "objtype") { setObjtype(attr.asString()); return; }
    if (name == "name") { setName(attr.asString()); return; }
    attributes[name] = attr;
}

void Root::removeAttr(const std::string& name)
{
    if (name == "parents") return;
    if (name == "id") return;
    if (name == "objtype") return;
    if (name == "name") return;
    attributes.erase(name);
}

Element Root::asObject() const
{
    Element::MapType allattrs = attributes;
    allattrs["parents"] = attr_parents;
    allattrs["id"] = attr_id;
    allattrs["objtype"] = attr_objtype;
    allattrs["name"] = attr_name;
    return Element(allattrs);
}

Element::MapType Root::asMap() const
{
    Element::MapType allattrs = attributes;
    allattrs["parents"] = attr_parents;
    allattrs["id"] = attr_id;
    allattrs["objtype"] = attr_objtype;
    allattrs["name"] = attr_name;
    return allattrs;
}

void Root::sendParents(Atlas::Bridge* b) const
{
    Atlas::Message::Encoder e(b);
    e.mapItem("parents", attr_parents);
}

void Root::sendId(Atlas::Bridge* b) const
{
    b->mapItem("id", attr_id);
}

void Root::sendObjtype(Atlas::Bridge* b) const
{
    b->mapItem("objtype", attr_objtype);
}

void Root::sendName(Atlas::Bridge* b) const
{
    b->mapItem("name", attr_name);
}

void Root::sendContents(Bridge* b) const
{
    sendParents(b);
    sendId(b);
    sendObjtype(b);
    sendName(b);

    Message::Encoder e(b);
    typedef std::map<std::string, Element>::const_iterator Iter;
    for (Iter I = attributes.begin(); I != attributes.end(); I++)
        e.mapItem((*I).first, (*I).second);
}

} } // namespace Atlas::Objects
