# -*- coding: utf-8 -*-

import os
import sys
import re
import platform
from distutils import sysconfig
from subprocess import Popen, PIPE

_unique_tmpdir = True


def _get_version():
    """get default Code_Aster version used for testcases"""
    fconfig = os.path.join(confdir, 'aster')
    txt = open(fconfig, 'r').read()
    mat = re.search('default_vers *: *(.+)', txt)
    assert mat != None, 'default_vers not found in %s' % fconfig
    vers = mat.group(1)
    return vers


def _get_tmpdir():
    """use current temporary directory"""
    fconfig = os.path.join(confdir, 'asrun')
    txt = open(fconfig, 'r').read()
    mat = re.search('rep_trav *: *(.+)', txt)
    assert mat != None, 'rep_trav not found in %s' % fconfig
    num = os.getpid()
    if _unique_tmpdir:
        num = "resu"
    tmpdir = os.path.join(mat.group(1), "unittest.as_run.%s" % num)
    return tmpdir


def execcmd(cmd, trace_name, return_output=False):
    """execute a command and write output and error to trace_name.xxx"""
    ferr = open(os.path.join(tmpdir, trace_name + ".err"), "w")
    ferr.write("Command: %s\n" % (' '.join(cmd)))
    p = Popen(cmd, stdout=PIPE, stderr=PIPE)
    out, err = p.communicate()
    open(os.path.join(tmpdir, trace_name + ".out"), "w").write(out)
    ferr.write(err)
    ferr.close()
    result = p.returncode
    if return_output:
        result = (p.returncode, out)
    return result


def init():
    try:
        os.makedirs(tmpdir)
    except OSError:
        pass


def on_dev_machine():
    return platform.uname()[1] == "cli70cx"


# to find asrun package
if os.environ.get('ASTER_ROOT'):
    sys.path.append(sysconfig.get_python_lib(prefix=os.environ['ASTER_ROOT']))

from asrun.installation import aster_root, confdir
from asrun.run import AsRunFactory

as_run_cmd = AsRunFactory().get_as_run_cmd()
del AsRunFactory


aster_version = _get_version()
tmpdir = _get_tmpdir()

dict_conf = {
    'ASTER_ROOT' : aster_root,
    'ASTER_VERSION' : aster_version,
    'PYTHONEXECUTABLE' : sys.executable,
    'CONFIG_FILE_LINE' : os.environ.get('CONFIG', ""),
    'DATA' : os.path.abspath(os.path.join(__file__, os.pardir, "data")),
    'TMPDIR' : tmpdir,
    'as_run' : as_run_cmd,
}

