# -*- coding: utf-8 -*-

# ==============================================================================
# COPYRIGHT (C) 1991 - 2003  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ==============================================================================

"""
Get cpu and memory informations of a list of machines.
"""

import os
import sys
from optparse import OptionParser

from asrun.i18n      import _
from asrun.mystring  import print3


def GetInfos(run, *args):
   run.PrintExitCode = False
   if len(args) < 1:
      run.parser.error(
            _(u"'--%s' requires one or more arguments") % run.current_action)
   
   content = ""
   for mach in args:
      iret, out = run.Shell('ping -c 1 %s' % mach)
      if iret == 0:
         cpu = run.GetCpuInfo('numcpu', mach=mach) or 0
         mem = run.GetMemInfo('memtotal', mach=mach) or 0
         if cpu > 0 or mem > 0:
            content += "\n[%s]\n" % mach
            if cpu > 0:
               content += "cpu=%d\n" % cpu
            if mem > 0:
               content += "mem=%d\n" % mem
      else:
         content += "\n# %s not responding\n" % mach
   
   print3(content)


