# -*- coding: utf-8 -*-

# ==============================================================================
# COPYRIGHT (C) 1991 - 2003  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ==============================================================================

"""
Manage backward compatibility for astk < 1.6.0

- change_argv :
   Example :
      astk  1.6.0  :  as_run --info
      astk <1.6.0  :  as_serv as_info
"""

import re
from asrun.i18n import _


dict_serv = {
   'as_info'         : '--info',
   'as_edit'         : '--edit',
   'as_actu'         : '--actu',
   'as_tail'         : '--tail',
   'as_del'          : '--del',
   'as_rex_creer'    : '--create_issue',
   'insert_in_db'    : '--insert_in_db',
   'as_exec'         : '--serv',
   'as_exec_special' : '--serv',
   'as_mail'         : '--sendmail',
}


def chg_as_mail(oldargv):
   """
   Changes for 'as_serv as_mail email_address file'.
   """
   argv = oldargv[:]
   if len(argv) > 2:
      argv[2] = '--report_to=%s' % argv[2]
   return argv


def change_argv(run, oldargv):
   """
   Replace first argument (service) by corresponding option.
   """
   argv = oldargv[:]
   arg1 = ''
   if len(argv[1:]) > 0:
      arg1 = argv[1]
   if dict_serv.get(arg1) is not None:
      argv[1] = dict_serv[arg1]
   elif arg1 in ('as_exec', 'as_exec_special'):
      pass
   elif arg1 in ('tool_stanley', 'as_rex_consult', 'as_rex_modfic', 'as_rex_suppr'):
      run.Mess(_(u"The service (%s) is not available any more. Update your ASTK client.") % arg1,
               '<F>_ERROR')

   if arg1 == 'as_mail':
      argv = chg_as_mail(argv)

   # change old style options (-KILL/-USR1)
   dict_change = {
      '-KILL' : '--signal=KILL',
      '-USR1' : '--signal=USR1',
   }
   ind = range(len(argv))
   d = dict(zip(argv, ind))
   for old, new in dict_change.items():
      if d.get(old) is not None:
         argv[d[old]] = new

   # warn
   if argv != oldargv:
      s_old = ' '.join(oldargv)
      argv2 = argv[:]
      if argv2[0].endswith('as_serv'):
         argv2[0] = re.sub('as_serv$', 'as_run', argv2[0])
      s_new = ' '.join(argv2)
   
      from warnings import warn
      msg = _(u"""%s has been renamed to %s, please update your client.""") % (s_old, s_new)
      warn(msg, DeprecationWarning, stacklevel=2)
   return argv


def remove_node_parameter(prof):
   """
   Remove node parameter in profile object if origine < 1.7.4 and batch mode.
   """
   #TODO

