
#include <pthread.h>
#include <asterisk/channel.h>
#include <asterisk/channel_pvt.h>
#include <asterisk/lock.h>
#include <asterisk/file.h>
#include <asterisk/musiconhold.h>

#include <isdn_msg.h>

//#define pthread_create ast_pthread_create

#include "crypt.h"
#include "te_lib.h"
#include "chan_misdn_if.h"


int misdn_crypt_debug=1;

void chan_misdn_log(char *tmpl, ...);


static void start_crypt_timer(chan_list_t *cl);

     
static pthread_t crypt_thread;
static sem_t crypt_sem;

msg_queue_t crypt_job_queue;

static char crypt_user_request_prefix[]="**";
static char crypt_request_prefix[]="**"; 

#define MAX_JOBS 100
#define MAX_REQUEST 10

#define TYPE_TIMER 1
#define TYPE_REQUEST 2

typedef struct job_s job_t ;

struct job_s {
  chan_list_t *ch;
  int type;

  int position;
  char request[MAX_REQUEST];
  
  int timeout;
  
  job_t *next;
};



void *crypt_thread_handler(void *arg)
{
  job_t *joblist[MAX_JOBS+1];
  
  memset(joblist, 0, sizeof(joblist));
  
  while(1) {
    int processing=1;

    sem_wait(&crypt_sem) ;

    if (misdn_crypt_debug>2)chan_misdn_log("Got somtehin to do\n" );
    
    while (processing) {
      msg_t *msg;
      int i;

      usleep(250000);
      
      // add new jobs to list
      for (msg=msg_dequeue(&crypt_job_queue);
	   msg;
	   msg=msg_dequeue(&crypt_job_queue) ) {
	job_t *j=malloc(sizeof(job_t));

	if (misdn_crypt_debug>2) chan_misdn_log("Got msg\n");
	memcpy(j,msg->data,sizeof(job_t));
	if (misdn_crypt_debug>2) chan_misdn_log("Getting job from msg\n");
	
	free_msg(msg);

	if (misdn_crypt_debug>2) chan_misdn_log("Looping the joblist\n");
	
	for (i=0; i<=MAX_JOBS; i++) if ( !joblist[i]) break;
	
	if ( i == MAX_JOBS) {
	  chan_misdn_log("Sorry Can't create Crypt Job, we have already %d jobs.\n", MAX_JOBS);
	break;
	}

	if (misdn_crypt_debug>2) chan_misdn_log("Assigning New Job to idx:%d \n",i);
	joblist[i]=j;
      }
      
      //process jobs in "nearly" round robin
      processing=0;
      for (i=0; i<= MAX_JOBS; i++) {
	job_t *job=joblist[i];
	
	if (job) {
	  chan_list_t *ch=job->ch;
	  bchannel_te_t *bc=ch->bc_te; 

	  processing=1;
	  if (misdn_crypt_debug>1) chan_misdn_log("Processing Job with idx:%d\n",i);
	  
	  
	  
	  switch (job->type) {
	    
	  case TYPE_TIMER:
	    chan_misdn_log("Processing TYPE_TIMER job pos:%d char:%c\n",job->position, job->request[job->position]);
	    
	    if (job->timeout-- <0 ) {
	      
	      switch(bc->crypt_state) {
	      case CRYPT_STATE_SECURE:
		manager_ph_control(bc,  BF_DISABLE, 0);
		break;
	      }

	      free(joblist[i]);
	      joblist[i]=NULL;
	      bc->crypt_state=CRYPT_STATE_IDLE;
	      
	    }
	    
	    break;
	    
	    
	  case TYPE_REQUEST:
	    
	    if (misdn_crypt_debug>1)chan_misdn_log("Processing TYPE_REQUEST job pos:%d \n",job->position);  
	    if (job->position >= 0) {
	      int k=strlen(job->request)-job->position-1;
	      
	      if (misdn_crypt_debug>1) chan_misdn_log("Sending Digit:%c to job:%d\n",job->request[k], i);
	      
	      //manager_send_frame(bc, get_dtmf(job->request[k]),get_dtmf_size(job->request[k]));
	      send_digit_to_chan(job->ch, job->request[k]);
	      
	      job->position--;
	    } else {
	      if (misdn_crypt_debug >0)chan_misdn_log("Finished Job sending %s, cleaning the job:%d\n",job->request, i);

	      switch (job->request[strlen(job->request)-1] ) {
	      case CRYPT_CONFIRM:
		//finished sending crypt confirm, now we can crypt ;)
		chan_misdn_log("Activating Encryption after sending confirm\n");
		manager_ph_control_block(bc,  BF_ENABLE_KEY, "homey", 5);
		break;
	      }
	      
	      free(joblist[i]);
	      joblist[i]=NULL;
	      
	      
	      switch (bc->crypt_state) {
	      case CRYPT_STATE_IDLE:
		break;
	      case CRYPT_STATE_IN_CRYPT_REQUEST:
		chan_misdn_log("Starting Timer After Sending REQUEST in STATE_IN_REQUEST\n");
		start_crypt_timer(job->ch);
		break;

	      }

	    }
	    
	    break;
	    
	  default:
	    
	    free(joblist[i]);
	    joblist[i]=NULL;
	  }
	}
      }

      if (i==MAX_JOBS) ; 
    }
    
  }
}

static void start_crypt_timer(chan_list_t *cl)
{
}


static void send_request(chan_list_t *ch, char req)
{
  msg_t *msg=alloc_msg(MAX_MSG_SIZE);
  job_t *job=((job_t*)msg->data);

  if (misdn_crypt_debug>2) chan_misdn_log("Were in send_req\n");
  
  job->ch=ch;
  job->type=TYPE_REQUEST;
  job->position=0;
  
  switch(req) {
  case CRYPT_REQUEST:
    if (misdn_crypt_debug>0)chan_misdn_log("Sending CRYPT_REQUEST\n");
    strncpy(job->request,crypt_request_prefix, MAX_REQUEST -1);
    {
      int i=strlen(job->request);
      job->request[i]=CRYPT_REQUEST;
      job->request[i+1]=0;
      job->position=i;
    }
    break;
  case CRYPT_CONFIRM:
    if (misdn_crypt_debug>0)chan_misdn_log("Sending CRYPT_CONFIRM\n");
    strncpy(job->request,crypt_request_prefix, MAX_REQUEST -1);
    {
      int i=strlen(job->request);
      job->request[i]=CRYPT_CONFIRM;
      job->request[i+1]=0;
      job->position=i;
    }
    break;

  case CRYPT_STATUS_REQUEST:
    if (misdn_crypt_debug>0)chan_misdn_log("Sending CRYPT_STATUS_REQUEST\n");
    strncpy(job->request,crypt_request_prefix, MAX_REQUEST -1);
    {
      int i=strlen(job->request);
      job->request[i]=CRYPT_STATUS_REQUEST;
      job->request[i+1]=0;
      job->position=i;
    }
    break;
    
  case CRYPT_STATUS_CONFIRM:
    if (misdn_crypt_debug>0)chan_misdn_log("Sending CRYPT_STATUS_CONFIRM\n");
    strncpy(job->request,crypt_request_prefix, MAX_REQUEST -1);
    {
      int i=strlen(job->request);
      job->request[i]=CRYPT_STATUS_CONFIRM;
      job->request[i+1]=0;
      job->position=i;
    }
    break;
    
  default:
    chan_misdn_log("Unknown Request: %c\n",req);
    return;
  }

  if (misdn_crypt_debug>1)chan_misdn_log("Queing and posting jobs\n");
  msg_queue_tail(&crypt_job_queue, msg);
  sem_post(&crypt_sem);
  
}



/**
   Event Processing State Machine
**/

void misdn_crypt_event(chan_list_t *cl, enum crypt_event_e event, void *data)
{
  bchannel_te_t *bc=cl->bc_te;
    
  if (bc->stack->mode != TE_MODE ) return ;
  
  switch(event) {
  case CRYPT_EVENT_AST_DIGIT:
    {
      char digit = *((char*)data); 
      if (misdn_crypt_debug>1)chan_misdn_log("CRYPT_EVENT_AST_DIGIT: %c\n",digit);
      
      if ( bc->curptx < strlen(crypt_user_request_prefix)) { 
	if (digit == crypt_user_request_prefix[bc->curptx]) {
	  bc->curptx++;
	  return ;
	}
	
      } else if( bc->curptx>= strlen(crypt_user_request_prefix)) {
	
	 if (misdn_crypt_debug>1)chan_misdn_log("CRYPT: Checking StateChange cause we have enough digs\n");
	switch (bc->crypt_state ) {
	  
	case CRYPT_STATE_IDLE:
	  if (misdn_crypt_debug>0)chan_misdn_log("CRYPT: State IDLE\n");
	  switch ( digit ) {
	  case USER_CRYPT_REQUEST:
	    if (misdn_crypt_debug>0)chan_misdn_log(" --> State changed to CRYPT_REQUEST\n");
	    bc->crypt_state = CRYPT_STATE_IN_CRYPT_REQUEST;
	    
	    chan_misdn_log("Deactivating RXTONES after CRYPT_USER_REQUEST\n");
	    chan_misdn_log("Play Something to user\n");

	    
	    //chan_misdn_log("Bridged: %p\n",cl->ast->_bridge);
	    //chan_misdn_log("Bridged (pvt): %p\n",cl->ast->pvt->bridged_channel);
	    if (AST_BRIDGED_P(cl->ast)) {
	      chan_misdn_log("Stopping RX/TX Tones\n");
	      cl->norxtone=0;
	      cl->notxtone=0;

	      //ast_indicate(cl->ast, AST_CONTROL_HOLD);
	      
	      ast_autoservice_start(cl->ast);
	      ast_moh_start(cl->ast, NULL); 
	      
	      
	      ast_streamfile(AST_BRIDGED_P( cl->ast) ,"myin", "en");
	      {
		int i=ast_waitstream(AST_BRIDGED_P(cl->ast), 0);
		chan_misdn_log("Waited for Stream: %d\n",i);
	      }
	      ast_stopstream(AST_BRIDGED_P(cl->ast) );
	      ast_moh_stop(cl->ast); 
	    }
	    else {
	      chan_misdn_log("We have no bridged channel at the moment, please check the dialstring\n");
	      //ast_streamfile( cl->ast ,"tt-monkeys","en");
	      //ast_moh_start( cl->ast , "default");
	    }
	      
	    
	    //cl->norxtone=1;
	    
	    //chan_misdn_log("CL->ast:%p CL->ast->bridged:%p\n ",cl->ast,AST_BRIDGED_P(cl->ast));
	    
	    //send_request(cl,CRYPT_REQUEST);
	    break;
	  default:
	    chan_misdn_log(" --> Expected USER_CRYPT_REQUEST\n");
	    chan_misdn_log("--> Got %c\n",digit);
	    chan_misdn_log("--> Going back to IDLE\n",digit);
	    bc->crypt_state = CRYPT_STATE_IDLE ;
	  }
	  break;
	  
	  //NOTHIN TO DO HERE, User requests something in wrong state i think..
	}
      } 
      bc->curptx=0;
    }
    break;
    

    /***********************************/
    /** More Important State Machine: **/
    /***********************************/
  case CRYPT_EVENT_MISDN_DIGIT:
    {
      char digit = *((char*)data); 
      if (misdn_crypt_debug>1)chan_misdn_log("CRYPT_EVENT_MISDN_DIGIT: %c\n",digit);

      
      if ( bc->curprx < strlen(crypt_request_prefix)) { 
	if (digit == crypt_user_request_prefix[bc->curprx]) {
	  bc->curprx++;
	  return ;
	}
	
      } else if( bc->curprx>= strlen(crypt_request_prefix)) {
	
	if (misdn_crypt_debug>1)chan_misdn_log("CRYPT: Checking StateChange cause we have enough digs\n");
	switch (bc->crypt_state ) {
	  
	case CRYPT_STATE_IDLE:
	  if (misdn_crypt_debug>0)chan_misdn_log("CRYPT: State IDLE\n");
	  switch ( digit ) {
	  case CRYPT_REQUEST:
	    if (misdn_crypt_debug>0)chan_misdn_log(" --> Got CRYPT_REQUST sending CRYPT_CONFIRM\n");
	    if (misdn_crypt_debug>0)chan_misdn_log(" --> State changed to CRYPT_CONFIRM\n");
	    bc->crypt_state = CRYPT_STATE_IN_CRYPT_CONFIRM;
	    
	    chan_misdn_log("Deactivating RXTONES after CRYPT_REQUEST\n");
	    //cl->norxtone=1;
	    
	    send_request(cl,CRYPT_CONFIRM);
	    
	    
	    break;

	  default:
	    chan_misdn_log(" --> Expected CRYPT_REQUEST\n");
	    chan_misdn_log(" --> Got %c\n",digit);
	    chan_misdn_log(" --> Going back to idle\n",digit);
	    bc->crypt_state = CRYPT_STATE_IDLE;
	  }
	  break;

	case CRYPT_STATE_IN_CRYPT_REQUEST:
	  if (misdn_crypt_debug>0)chan_misdn_log("CRYPT: State IN_CRYPT_REQUEST\n");
	  switch ( digit ) {
	  case CRYPT_CONFIRM:
	    if (misdn_crypt_debug>0)chan_misdn_log(" --> Got CRYPT_CONFIRM\n");
	    if (misdn_crypt_debug>1)chan_misdn_log(" --> Activating Encryption\n");
	    if (misdn_crypt_debug>1)chan_misdn_log(" --> State changed to CRYPT_STATE_IN_STATUS_REQUEST\n");
	    bc->crypt_state = CRYPT_STATE_IN_STATUS_REQUEST;
	    
	    manager_ph_control_block(bc,  BF_ENABLE_KEY, "homey", 5);
	    
	    send_request(cl,CRYPT_STATUS_REQUEST);
	    
	    break;
	  default:
	    chan_misdn_log(" --> Expected CRYPT_CONFIRM\n");
	    chan_misdn_log(" --> Got %c\n",digit);
	    chan_misdn_log(" --> Going back to idle\n",digit);
	    bc->crypt_state = CRYPT_STATE_IDLE;
	  }
	  break;

	case CRYPT_STATE_IN_STATUS_REQUEST:
	  if (misdn_crypt_debug>0)chan_misdn_log("CRYPT: State IN_STATUS_REQUEST\n");
	  
	  switch ( digit ) {
	  case CRYPT_STATUS_CONFIRM:
	    if (misdn_crypt_debug>0)chan_misdn_log(" --> Got CRYPT_STATE_CONFIRM\n");
	    if (misdn_crypt_debug>0)chan_misdn_log(" --> YOU HAVE A SECURE CONNECTION NOW\n");
	    bc->crypt_state = CRYPT_STATE_SECURE;
	    
	    chan_misdn_log("Activating RXTONES after STATUS_CONFIRM\n");
	    
	    
	    cl->norxtone=0;
	    
	    break;

	  default:
	    chan_misdn_log(" --> expected CRYPT_STATUS_CONFIRM\n");
	    chan_misdn_log(" --> Got: %c\n", digit);
	    chan_misdn_log(" --> Deactivating Crypting Session, Going to IDLE\n");
	    bc->crypt_state = CRYPT_STATE_IDLE;
	    
	  }
	  break;

	case CRYPT_STATE_IN_CRYPT_CONFIRM:
	  if (misdn_crypt_debug>0)chan_misdn_log("CRYPT: State IN_CRYPT_CONFIRM\n");
	  switch ( digit ) {
	  case CRYPT_STATUS_REQUEST:
	    if (misdn_crypt_debug>0)chan_misdn_log(" --> Got CRYPT_STATE_REQUEST\n");
	    if (misdn_crypt_debug>0)chan_misdn_log(" --> SESSION MUST BE SECURE NOW\n");

	    bc->crypt_state = CRYPT_STATE_SECURE;
	    send_request(cl,CRYPT_STATUS_CONFIRM);

	    chan_misdn_log("Activating RXTONES after STATUS_CONFIRM\n");
	    cl->norxtone=0;
	    
	    break;

	  default:
	    chan_misdn_log(" --> expected CRYPT_STATUS_REQUEST\n");
	    chan_misdn_log(" --> Got: %c\n", digit);
	    chan_misdn_log(" --> Deactivating Crypting Session, Going to IDLE\n");
	    bc->crypt_state = CRYPT_STATE_IDLE;
	    
	  }
	  break;
	  
	default:
	  chan_misdn_log("CRYPT: Unknown Crypt_state: %d",bc->crypt_state);
	  chan_misdn_log("Going to IDLE\n");
	  bc->crypt_state=CRYPT_STATE_IDLE;
	}



      }
      bc->curprx=0;
    }
    break;
  default:
    break;
  }
  
}


void crypt_init() {
  ast_pthread_create(&crypt_thread, NULL, crypt_thread_handler, NULL);

  if (sem_init(&crypt_sem,1,0)<0)
    sem_init(&crypt_sem,0,0);
  
  msg_queue_init(&crypt_job_queue);
  chan_misdn_log ("Crypt Thread Initialized\n"); 
  
}
