/*
 * Chan_Misdn -- Channel Driver for Asterisk
 *
 * Interface to Asterisk
 *
 * Copyright (C) 2004, Christian Richter
 *
 * Christian Richter <crich@beronet.com>
 *
 * This program is free software, distributed under the terms of
 * the GNU General Public License
 */



#ifndef MISDN_IF
#define MISDN_IF

#include <isdn_net.h>
#include <l3dss1.h>
#include <helper.h>
#include <bchannel.h>
#include "te_lib.h"



void *if_misdn_client_thread(void *myfd);
void *if_misdn_main(void *arg);




enum errs {
  NO_CHAN_AVAILABLE
}; 



enum misdn_chan_state {
  MISDN_NOTHING, //at beginning
  MISDN_WAITING4DIGS, // when waiting for infos
  MISDN_EXTCANTMATCH, // when asterisk couldnt match our ext
  MISDN_DIALING, // when pbx_start
  MISDN_CALLING, // when misdn_call is called
  MISDN_CALLING_ACKNOWLEDGE, // when we get SETUP_ACK
  MISDN_ALERTING, // when Alerting
  MISDN_BUSY, // when BUSY
  MISDN_CONNECTED, // when connected
  MISDN_BRIDGED, // when bridged
  MISDN_CLEANING, //when hangup from * but we were connected before
  MISDN_HUNGUP_FROM_MISDN, //when DISCONNECT/RELEASE/REL_COMP  cam from misdn
  MISDN_HUNGUP_FROM_AST, //when DISCONNECT/RELEASE/REL_COMP came out of
			//misdn_hangup
  MISDN_HOLDED, //if this chan is holded
  MISDN_HOLD_DISCONNECT //if this chan is holded
  
}; 


#define ORG_AST 1
#define ORG_MISDN 2


typedef struct chan_list chan_list_t;

struct chan_list {
  
  sem_t sem;
  pthread_mutex_t lock;
  pthread_t *audio_thread;
  
  enum misdn_chan_state state;
  int holded; 
  int orginator;

  int norxtone;
  int notxtone; 

  struct ast_dsp *dsp;
  struct ast_trans_pvt *trans;
  
  struct ast_channel * ast;
  //struct ast_channel * holded_ast;
  
  bchannel_te_t *bc_te;
  bchannel_te_t *holded_bc;

  unsigned int l3id;
  
  chan_list_t *peer;
  chan_list_t *next;
  chan_list_t *prev;
  chan_list_t *first;
} ;



struct ast_channel *misdn_new(chan_list_t *cl, int state, char * name, char * context, char *exten, char *callerid);


void send_digit_to_chan(chan_list_t *cl, char digit );


#ifdef ASTERISK_STABLE

#define AST_CID_P(ast) ast->callerid
#define AST_BRIDGED_P(ast) ast->bridge
#define AST_LOAD_CFG ast_load
#define AST_DESTROY_CFG ast_destroy
#else //ASTERISK_STABLE

#include <asterisk/utils.h>

#define AST_CID_P(ast) ast->cid.cid_num
#define AST_BRIDGED_P(ast) ast_bridged_channel(ast) 
#define AST_LOAD_CFG ast_config_load
#define AST_DESTROY_CFG ast_config_destroy

#endif //ASTERISK_STABLE



#endif
