#include <stdio.h>

void f () {}

namespace {
  void g1 () { f (); }
  namespace {
    void g2 () { f (); g1 (); }
  }
};

namespace {
};

aspect Test {
  advice call("% ...::%()") : before () {
    printf ("    call (\"%s\")\n", JoinPoint::signature ());
  }
// TODO: within doesn't work correctly, yet
//   advice call("% ...::%(...)") && within("% ...::g2(...)") : before () {
//     printf ("    call to unnamed (\"%s\")\n", JoinPoint::signature ());
//   }
  advice execution ("% ...::%(...)") : before () {
    printf ("  execution (\"%s\")\n", JoinPoint::signature ());
  }
  advice execution ("% ...::<unnamed>::...::%(...)") : before () {
    printf ("  in unnamed namespace\n");
  }
};

int main() {
  printf ("AnonymousStuff: tests if ac++ can deal with anonymous classes,\n");
  printf ("                namespace, etc.\n");
  printf ("=============================================================\n");
  g1 ();
  g2 ();
  printf ("=============================================================\n");
  return 0; // TODO: it should also work without this return
}
