// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __Tracing__
#define __Tracing__

#include <iostream>
using namespace std;

namespace Puma {


class Token;

class Tracing {
  int _trace;
  int _tdepth;
  ostream *_tos;

protected:
  Tracing ();
  
public:
  void trace (ostream&, bool = false);

protected:
  void trace (int); 
  void trace (const char *, int = 1); 
  void trace (Token *, const char *, const char *); 
  int trace_mode () const;
  ostream &tos () const;

private:
  const char *token_text (int) const; 
};

inline Tracing::Tracing () : 
  _trace (0), 
  _tdepth (0),
  _tos ((ostream*)0) {}

inline void Tracing::trace (int token) { trace (token_text (token)); }
inline int Tracing::trace_mode () const { return _trace; }


} // namespace Puma

#endif /* __Tracing__ */
