#include <stdio.h>

void f () {}

// TODO: Puma should detect a problem if g1 and g2 are both called g
namespace {
  void g1 () { f (); }
};

namespace {
  void g2 () { f (); g1 (); }
};

aspect Test {
  advice call("% f()") : before () {
    printf ("    call (\"%s\")\n", JoinPoint::signature ());
  }
  advice execution ("% ...::%(...)") : before () {
    // TODO: the signature of f, g1, and g2 should show the anonymous namespace
    printf ("  execution (\"%s\")\n", JoinPoint::signature ());
  }
};

int main() {
  printf ("AnonymousStuff: tests if ac++ can deal with anonymous classes,\n");
  printf ("                namespace, etc.\n");
  printf ("=============================================================\n");
  g1 ();
  g2 ();
  printf ("=============================================================\n");
  return 0; // TODO: it should also work without this return
}
