#!/bin/sh

ASN1MODULE=../tap3.asn1
ASN1PDU=DataInterChange
PROGNAME=tap3dump

../../asn1c/asn1c -S ../../skeletons ${ASN1MODULE} || exit $?

if [ ! -f Makefile.am.sample ]; then
	echo "Makefile.am.sample is missing"
	exit 1
fi

set -x
cat Makefile.am.sample						\
	| sed -e 's/^CFLAGS.*/CFLAGS += -I. -DHAVE_CONFIG_H/'	\
	| sed -e "s/^all: /all: ${ASN1PDU}.c /"			\
	| sed -e "s/progname/${PROGNAME}/"			\
	> Makefile.$$

(	echo
	echo "${ASN1MODULE}:"
	echo "	@echo The ${ASN1MODULE} file is not yet present."
	echo "	@echo Please read the README file on how to obtain this file."
	echo "	@exit 42"
	echo
	echo "${ASN1PDU}.c: ${ASN1MODULE} regenerate.Makefile"
	echo "	./regenerate.Makefile"
	echo "	@touch ${ASN1PDU}.c"
	echo "	make"
	echo
	echo 'ASN_DECODER_TEMPLATE=../../skeletons/asn-decoder-template.c'
	echo '$(TARGET).o: $(ASN_DECODER_TEMPLATE)'
	echo '	$(CC) $(CFLAGS) -Dasn_DEF=asn_DEF_'${ASN1PDU}' -o $(TARGET).o -c $(ASN_DECODER_TEMPLATE)'
	echo
	echo "distclean: clean"
	echo '	rm -f $(ASN_MODULE_SOURCES) $(ASN_MODULE_HEADERS)'
	echo "	rm -f Makefile.am.sample"
) >> Makefile.$$

rm Makefile.am.sample || exit $?

mv Makefile.$$ Makefile

set +x
echo
echo "Makefile generation finished"
