.TH asmailrc 5 "23 Jun 2003" "Version 1.6"
.UC
.SH NAME
\fBasmailrc\fP \- the asmail resource file
.SH SYNOPSIS
.B $HOME/.asmailrc
.SH DESCRIPTION
The \fBasmailrc\fP is a resource file that describes the
configuration of the \fBasmail\fP(1) program.
.SH RESOURCE FILE SYNTAX
The syntax is based on grouping relevant options with \fB{}\fP
(curly braces). The keyword before the opening brace tells
\fBasmail\fP what this section is related to. The keywords
in one section may be invalid or have different semantics
in another section.

All keywords are case-insensitive, so there is no difference
between "mailbox" and "Mailbox". However, the values you
give to the file names, user names and so on are case-sensitive
as is usual on Unix systems. Comments start with the \fB#\fP (hash sign)
and run until the end of the line. Comments and blank lines
are ignored.

There are two main sections within the resource file. Each
of them may be completely omitted, as well as other sections
and settings may be omitted. \fBasmail\fP will try to use default
values for everything you do not specify.

The later values overwrite earlier values. It is perfectly
acceptable to specify any option twice and the last value
will be used. One exception from this is the \fBanimate{}\fP
section where pixmap files are added to the list by multiple
occurences of the keywords.

Section name must be followed by \fB{\fP (opening brace) on
the same line. The end of a section is signalled by
\fB}\fP (closing brace) alone on a line.
.IP x11
.RS
The top-level section describing the GUI settings.
.RE
.IP mailbox
.RS
The top-level section describing the mailboxes to be monitored
.RE
.IP stat
.RS
The section may appear within the \fBx11{}\fP section.
This section describes what statistics should be shown
on the screen.
.RE
.IP animate
.RS
The section may appear within the \fBx11{}\fP section.
This section describes the pixmaps that will be used
instead of the default ones and the settings for the
animation.
.RE
.SH x11 section
The x11 section specifies how the application looks on the screen.
There may be multiple \fBx11{}\fP sections, the settings from all
of them are merged and later settings overwrite earlier settings.
.IP "beep [yes|no]"
.RS
When \fBbeep\fP is on, the tool will signal arrival of 
new e-mail by the system beep via the system speaker.

Default is \fByes\fP.
.RE
.IP "shape [yes|no]"
.RS
Specifies whether the \fBShape\fP extensions of X11 will be used
for drawing the pixmaps that are specified by \fIframe\fP, \fInomail\fP,
\fIold\fP and \fInew\fP keywords in the settings file.

When the Shape extensions are used, the tool will use the 
transparency settings of the pixmaps. That is, when a pixmap
contains transparent pixels, those pixels will become actually
transparent on the screen. With the Shape extensions disabled,
the transparent pixels will show up filled with the background 
color.

The \fBShape\fP extension is rather expensive on the CPU power
and may slow down things a lot on a slow machine.

Default is \fBno\fP.
.RE
.IP "on_mouse_left comand &"
.RS
The \fBcommand\fP will be executed when the application
window is clicked with the left mouse button.

Default is \fBnone\fP.
.RE
.IP "on_mouse_middle comand &"
.RS
Same as \fBon_mouse_left\fP for the middle mouse button.
.RE
.IP "on_mouse_right comand &"
.RS
Same as \fBon_mouse_left\fP for the right mouse button.
.RE
.IP "on_new_mail command &"
.RS
The \fBcommand\fP will be executed once for each mailbox when
the e-mail arrives to that mailbox.

Default is \fBnone\fP.
.RE
.SH mailbox section
The resource file should contain as many \fBmailbox{}\fP sections
as the number of mailboxes you want to monitor. Each section will
create a separate monitor for the given mailbox.
.IP "type [ mbox | maildir | mh | pop3 | imap ]"
.RS
The type of the mailbox. \fBmbox\fP is the standard UNIX mailbox
file. \fBmaildir\fP is the newer Maildir format.
\fBmh\fP is the mH mail directory format.
\fBpop3\fP is for the mailboxes on POP3 servers. 
\fBimap\fP is a mailbox on the IMAP server.

Depending on the type of the mailbox, some settings may take
effect while others will be silently ignored.

The following keywords are useful for the \fBmbox\fP:
    \fBfile\fP \fBupdate\fP \fBunread-is-new\fP

The following keywords are useful for the \fBmaildir\fP:
    \fBfile\fP \fBupdate\fP

The following keywords are useful for the \fBmh\fP:
    \fBfile\fP \fBupdate\fP \fBunread-is-new\fP \fBuse-mh-sequences\fP

The following keywords are useful for the \fBpop3\fP:
    \fBupdate\fP \fBauth\fP \fBserver\fP \fBuser\fP \fBpassword\fP \fBtimeout\fP

The following keywords are useful for the \fBimap\fP:
    \fBupdate\fP \fBserver\fP \fBuser\fP \fBpassword\fP \fBmailbox\fP \fBtimeout\fP \fBpersistent\fP

.RE
.IP "file file-name"
.RS
For \fBmbox\fP, \fBmh\fP and \fBmaildir\fP, specifies the location of the
mailbox in the filesystem.

Default: \fBnone\fP.

Note: if no \fBmailbox\fP section is present in the configuration
file or no configuration file is found, the value of the environment
variable \fB$MAIL\fP will be used as the location of the UNIX
\fBmailbox\fP format mail file.
.RE
.IP "update period"
.RS
Specifies the period between two updates of this mailbox. The
mailbox will be updated \fBperiod\fP seconds after the previous
update is finished.

Default: \fB10\fP.
.RE
.IP "unread-is-new [ yes | no ]"
.RS
For \fBmbox\fP and \fBmh\fP, specifies whether the messages which are flagged
as unread are counted as new messages.

Default: \fBno\fP.
.RE
.IP "use-mh-sequences [ yes | no ]"
.RS
For \fBmh\fP, specifies whether asmail should parse the .mh_sequences
file in this mH mail directory to count new messages. If this option
is set to "no", then asmail will parse every message in the mH directory
searching for "Status" headers.

Default: \fBno\fP.
.RE
.IP "auth plain md5"
.RS
Specifies the type of authentication allowed for the POP3 service.
\fBplain\fP stands for the cleartext password authentication, \fBmd5\fP
stands for the APOP authentication using MD5 hashes.
You can specify either of them or both.

If both are allowed and the server supports APOP, first APOP
will be tried.

Default: \fBplain md5\fP.
.RE
.IP "server server-name"
.RS
The server name to connect to.

Default: none.
.RE
.IP "user user-name"
.RS
Your user name on the server.

Default: none.
.RE
.IP "password your-password"
.RS
Your password on the server.

Default: none.
.RE
.IP "mailbox mailbox-name"
.RS
Your mailbox on the server. This is only useful with IMAP servers,
you can specify an alternative to the standard "INBOX" value.

Default: \fBINBOX\fP for IMAP, none for the rest.
.RE
.IP "timeout server-timeout"
.RS
The connection to the server will time out after \fBserver-timeout\fP
seconds waiting for the answer.

Default: \fB60\fP.
.RE
.IP "persistent [ yes | no ]"
.RS
The connection to the server can be either opened once and kept
open or the connection can be opened and closed every time we
need to check for the e-mail status, i.e. every \fBupdate period\fP
seconds. If you do not want the connection set-up and login
procedure to execute every time, set this to \fByes\fP.

Default: \fBno\fP.
.RE
.SH stat section
This section relates to the representation on the screen of
mailbox status and counters. There are the following elements
in this representation:

    \fBmailbox state\fP
    A letter \fBR\fP appears whenever the mailbox is 
    being updated.

    \fBerror state\fP
    A letter appears that shows the error state of 
    the mailbox. 
    The letters may be folowing: 
      \fBL\fP - login procedure failed
      \fBT\fP - timeout while waiting for server response
      \fBC\fP - connection problem
      \fBF\fP - general fault indication
    When an error is indicated, \fBasmail\fP prints a 
    descriptive message on the standard output.

    \fBnumber of messages\fP
    The number of messages is represented by two numbers,
    for the number of new messages and the total number
    of messages.

The statistics may be displayed for each of the mailboxes separately
as well as for the total of all mailboxes. When the total is displayed,
the indicators of the mailbox state and the error state will report
if any of mailboxes are updated or have errors.
.IP "each [ yes | no ]"
.RS
Whether the tool should display a line of statistics for each
of the mailboxes separately.

Default: \fBno\fP.
.RE
.IP "total [ yes | no ]"
.RS
Whether the tool should display the summary line for the total
number of messages in all mailboxes.

Default: \fByes\fP.
.RE
.IP "status [ yes | no ]"
.RS
Whether the status indicator should preceed every line describing
the number of messages in a mailbox and the total.

Default: \fByes\fP.
.RE
.IP "old [ yes | no ]"
.RS
Whether the status indicator should display the number of
old (read) messages in the mailbox.

Default: \fByes\fP.
.RE
.IP "new [ yes | no ]"
.RS
Whether the status indicator should display the number of
new (unread) messages in the mailbox.

Default: \fByes\fP.
.RE
.IP "delimiter characters"
.RS
The \fBcharacters\fP are used to separate the number of
new messages from the number of old messages in the display.

Default: \fB"/"\fP.
.RE
.IP "x pixels"
.RS
Start the status indicator at \fBpixels\fP offset horizontally from the
top left corner.

Default: \fB0\fP.
.RE
.IP "y pixels"
.RS
Start the status indicator at \fBpixels\fP offset vertically from the
top left corner.

Default: \fB52\fP.
.RE
.IP "font font-specification"
.RS
Use the \fBfont-specification\fP for the status indicator.

Default: \fB-*-*-medium-r-normal--10-*-*-*-*-*-*-*\fP.
.RE
.IP "color name"
.RS
Use the specified color for the status indicator. The color
may be a single word or multiple words surrounded by quotes.

Default: \fBblack\fP.
.RE
.SH animate section
The section describes the animation presented on the screen. Basically,
you can supply a number of XPM files in this section and the tool
will happily cycle through them. There are three states: \fBnomail\fP,
\fBold\fP, \fBnew\fP. For each state, you add as many XPM files
as you like. If there is only one file, \fBasmail\fP will not really
cycle through it, only display once, saving thus the system resources.
.IP "refresh refresh-rate"
.RS
The supplied XPM files are cycled through every \fBrefresh-rate\fP
number of 1/100th of a second.

Default: \fB10\fP.
.RE
.IP "nomail xpm-file"
.RS
Add this \fBxpm-file\fP to the animation of display to represent
the state of empty mailbox.
.RE
.IP "old xpm-file"
.RS
Add this \fBxpm-file\fP to the animation of display to represent
the state of mailbox with only read mail.
.RE
.IP "new xpm-file"
.RS
Add this \fBxpm-file\fP to the animation of display to represent
the state of mailbox when there is new e-mail in it.
.RE
.IP "frame xpm-file"
.RS
Use this \fBxpm-file\fP as the background image. The background
image may use transparency. You can specify more than one but
only the first one will be used.

You can specify the keyword \fBnone\fP instead of the name of
the file to be used for the frame. The result will be no frame
at all around the applet window.
.RE
.SH EXAMPLE

 x11 {
    beep no
    on_mouse_left aterm -e bash -c pine &
    on_new_mail cat /usr/local/share/asmail/sounds/drip.au > /dev/audio &
    shape yes
    stat {
      each yes
      total yes
      delimiter " "
      x 5
      y 2
      font -*-helvetica-bold-r-*-*-10-*-*-*-*-*-*-*
      color black
    }
    animate {
      refresh 10
      nomail /usr/local/share/asmail/pixmaps/e-no.xpm
      old /usr/local/share/asmail/pixmaps/e0.xpm
      new /usr/local/share/asmail/pixmaps/e1.xpm
      new /usr/local/share/asmail/pixmaps/e2.xpm
      new /usr/local/share/asmail/pixmaps/e3.xpm
      new /usr/local/share/asmail/pixmaps/e4.xpm
      new /usr/local/share/asmail/pixmaps/e5.xpm
      new /usr/local/share/asmail/pixmaps/e6.xpm
      new /usr/local/share/asmail/pixmaps/e7.xpm
      new /usr/local/share/asmail/pixmaps/e8.xpm
      new /usr/local/share/asmail/pixmaps/e9.xpm
      new /usr/local/share/asmail/pixmaps/e10.xpm
      new /usr/local/share/asmail/pixmaps/e11.xpm
      new /usr/local/share/asmail/pixmaps/e12.xpm
      new /usr/local/share/asmail/pixmaps/e13.xpm
      new /usr/local/share/asmail/pixmaps/e14.xpm
      new /usr/local/share/asmail/pixmaps/e15.xpm
      new /usr/local/share/asmail/pixmaps/e16.xpm
      new /usr/local/share/asmail/pixmaps/e17.xpm
      new /usr/local/share/asmail/pixmaps/e18.xpm
      new /usr/local/share/asmail/pixmaps/e19.xpm
      new /usr/local/share/asmail/pixmaps/e20.xpm
      new /usr/local/share/asmail/pixmaps/e21.xpm
      new /usr/local/share/asmail/pixmaps/e22.xpm
      new /usr/local/share/asmail/pixmaps/e23.xpm
      new /usr/local/share/asmail/pixmaps/e24.xpm
      new /usr/local/share/asmail/pixmaps/e25.xpm
      new /usr/local/share/asmail/pixmaps/e26.xpm
      new /usr/local/share/asmail/pixmaps/e27.xpm
      new /usr/local/share/asmail/pixmaps/e28.xpm
      new /usr/local/share/asmail/pixmaps/e29.xpm
      new /usr/local/share/asmail/pixmaps/e30.xpm
    }
 }

 mailbox {
    type mbox
    file /var/spool/mail/albert
    update 5
    unread-is-new no
 }

 mailbox {
    type maildir
    file /home/albert/MailDir
    update 5
 }

 mailbox {
    type mh
    file /home/albert/mhmail
    update 5
    unread-is-new yes
    use-mh-sequences yes
 }

 mailbox {
    type pop3
    auth plain md5
    server example.com
    user yourname
    password yourpassword
    update 120
    timeout 30
 }

 mailbox {
    type imap
    server example.org
    user yourname 
    password yourpassword
    update 60
    timeout 30
 }

.SH FILES
.I ~/.asmailrc
.SH "SEE ALSO"
.BR asmail (1)
.SH COPYRIGHTS
Copyright (c) 2002-2003  Albert Dorofeev <albert@tigr.net>

Distributed under GNU General Public License v2 ; 
see LICENSE file for more informations.
.SH AUTHORS
Albert "Tigr" Dorofeev <albert@tigr.net>

See the README file for credits.
.sp
