/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.file;

import alt.jiapi.file.Configuration;
import alt.jiapi.file.ConstantPool;
import java.util.LinkedList;
import java.util.List;

public class Field {
    public static final short ACC_PUBLIC = 1;
    public static final short ACC_PRIVATE = 2;
    public static final short ACC_PROTECTED = 4;
    public static final short ACC_STATIC = 8;
    public static final short ACC_FINAL = 16;
    public static final short ACC_VOLATILE = 64;
    public static final short ACC_TRANSIENT = 128;
    private ConstantPool cp;
    private short access_flags;
    private short name_index;
    private short descriptor_index;
    private List attributes;
    private transient Configuration config = new Configuration();

    public Field(ConstantPool cp, short access_flags, String name, String descriptor, List attributes) {
        this(cp, access_flags, cp.addUtf8Info(name).getEntryIndex(), cp.addUtf8Info(descriptor).getEntryIndex(), attributes);
    }

    Field(ConstantPool cp, short access_flags, short name_index, short descriptor_index, List attributes) {
        this.cp = cp;
        this.access_flags = access_flags;
        this.name_index = name_index;
        this.descriptor_index = descriptor_index;
        this.attributes = attributes;
    }

    public short getAccessFlags() {
        return this.access_flags;
    }

    public List getAttributes() {
        if (this.config.getBoolean("alt.jiapi.file.strip-optional-attributes", true)) {
            return new LinkedList();
        }
        return this.attributes;
    }

    public String getName() {
        return this.cp.getUtf8(this.name_index);
    }

    public String getDescriptor() {
        return this.cp.getUtf8(this.descriptor_index);
    }

    short getNameIndex() {
        return this.name_index;
    }

    short getDescriptorIndex() {
        return this.descriptor_index;
    }
}

