#define RECORDS_C
#include "records.h"

int record_write(char *hname, double value, char *owner)
{
	char *name = strdglue(VARDIR, hname);
	FILE *fd = fopen(name, "w");
	xfree(name);
	
	if (fd == NULL)
		return 0;

	value;
	
	fwrite(&value, sizeof(double), 1, fd);	
	fclose(fd);

	name = strglue(VARDIR, hname, ".owner");
	fd = fopen(name, "w");
	fprintf(fd, "%s", owner);
	xfree(name);
	fclose(fd);

	return 1;
}

double record_read(char *hname, double *value, char **owner)
{
	char *name = strglue(VARDIR, hname, "");
	FILE *fd = fopen(name, "r");
	xfree(name);

	*value = 0;
	*owner = NULL;

	if (fd) {
		fread(value, sizeof(double), 1, fd);
		fclose(fd);
		name = strglue(VARDIR, hname, ".owner");
		fd = fopen(name, "r");
		*owner = read_line(fd);
		fclose(fd);
		xfree(name);
	}

	return *value;
}
