/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 16:09:06 GMT 2018
 */

package uk.ac.sanger.artemis.plot;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.plot.GCWindowAlgorithm;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Strand;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class GCWindowAlgorithm_ESTest extends GCWindowAlgorithm_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getReverseStrand();
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand0);
      Integer integer0 = gCWindowAlgorithm0.getDefaultStepSize(89);
      assertNotNull(integer0);
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertEquals(8, (int)integer0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getForwardStrand();
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand0);
      Integer integer0 = gCWindowAlgorithm0.getDefaultStepSize(2241);
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertNotNull(integer0);
      assertEquals(224, (int)integer0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("");
      Bases bases0 = new Bases(rawStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand0);
      gCWindowAlgorithm0.getAverage();
      assertTrue(gCWindowAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("FeatureCvTermProp = ");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand0);
      emblStreamSequence0.setFromChar(bases0.letter_index);
      gCWindowAlgorithm0.getAverage();
      assertTrue(gCWindowAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("FD#K#.bpk|Qa1G", "FD#K#.bpk|Qa1G");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand0);
      // Undeclared exception!
      try { 
        gCWindowAlgorithm0.getValues(2, 2, (float[]) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.GCWindowAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("RUF*B*3y94G7E/x&g3");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand0);
      float[] floatArray0 = new float[7];
      // Undeclared exception!
      try { 
        gCWindowAlgorithm0.getValues(254, (-2123), floatArray0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 254 > end: -2123
         //
         verifyException("uk.ac.sanger.artemis.plot.GCWindowAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      float[] floatArray0 = new float[0];
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("", "O`");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand0);
      // Undeclared exception!
      try { 
        gCWindowAlgorithm0.getValues(0, 0, floatArray0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 0
         //
         verifyException("uk.ac.sanger.artemis.plot.GCWindowAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getForwardStrand();
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand0);
      // Undeclared exception!
      try { 
        gCWindowAlgorithm0.getAverage();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      GCWindowAlgorithm gCWindowAlgorithm0 = null;
      try {
        gCWindowAlgorithm0 = new GCWindowAlgorithm((Strand) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("B?");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand0);
      Integer integer0 = gCWindowAlgorithm0.getDefaultStepSize(2565);
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertNotNull(integer0);
      assertEquals(256, (int)integer0);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("B?");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand0);
      Integer integer0 = gCWindowAlgorithm0.getDefaultStepSize(1);
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertNull(integer0);
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("B?");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand0);
      Integer integer0 = gCWindowAlgorithm0.getDefaultMinWindowSize();
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertNotNull(integer0);
      assertEquals(24, (int)integer0);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getReverseStrand();
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand0);
      Integer integer0 = gCWindowAlgorithm0.getDefaultMaxWindowSize();
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertNotNull(integer0);
      assertEquals(500, (int)integer0);
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getForwardStrand();
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand0);
      Integer integer0 = gCWindowAlgorithm0.getDefaultWindowSize();
      assertNotNull(integer0);
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertEquals(120, (int)integer0);
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("FeatureCvTermProp = ");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand0);
      float[] floatArray0 = new float[7];
      emblStreamSequence0.setFromChar(bases0.letter_index);
      gCWindowAlgorithm0.getValues(0, 2, floatArray0);
      assertArrayEquals(new float[] {33.333336F, 0.0F, 0.0F, 0.0F, 0.0F, 0.0F, 0.0F}, floatArray0, 0.01F);
      assertTrue(gCWindowAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("B?");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand0);
      int int0 = gCWindowAlgorithm0.getValueCount();
      assertEquals(1, int0);
      assertTrue(gCWindowAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getForwardStrand();
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand0);
      Float float0 = gCWindowAlgorithm0.getMinimumInternal();
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertEquals(0.0F, (float)float0, 0.01F);
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("FeatureCvTermProp = ");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand0);
      gCWindowAlgorithm0.getAverage();
      assertTrue(gCWindowAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("FeatureCvTermProp = ");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand0);
      gCWindowAlgorithm0.getMaximumInternal();
  }
}
