//error.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2011
 *
 *  This file is part of aroarfw, a RoarAudio framework for
 *  embedded systems (Controlers).
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  or (at your option) any later version as published by
 *  the Free Software Foundation.
 *
 *  aroarfw is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#ifndef _AROARFW_ERROR_H_
#define _AROARFW_ERROR_H_

//! Error codes for on-wire protocol
typedef enum {
 //! Unknown (maybe no) error
 RERROR_UNKNOWN     = -1,
 //! No error. Can be used to initialize error variables.
 RERROR_NONE        =  0,
 //! Operation not permitted
 RERROR_PERM        =  1,
 //! No such file or directory
 RERROR_NOENT       =  2,
 //! Bad message
 RERROR_BADMSG      =  3,
 //! Device or resource busy
 RERROR_BUSY        =  4,
 //! Connection refused
 RERROR_CONNREFUSED =  5,
 //! Function not implemented
 RERROR_NOSYS       =  6,
 //! Operation not supported
 RERROR_NOTSUP      =  7,
 //! Broken pipe
 RERROR_PIPE        =  8,
 //! Protocol error
 RERROR_PROTO       =  9,
 //! Result too large/general out of range
 RERROR_RANGE       = 10,
 //! Message too long
 RERROR_MSGSIZE     = 11,
 //! Not enough space
 RERROR_NOMEM       = 12,
 //! Invalid argument
 RERROR_INVAL       = 13
} rerror_t;

#endif

//ll
