/*
 * Copyright (c) 2018 Arm Limited.
 *
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
#pragma once

#ifdef __ARM_FEATURE_SVE

template<>
template<typename T>
inline void TransformImpl<8, 2, false, 4, 4, false>::Transform(T *out, const T *in, int ldin, int y0, int ymax, int k0, int kmax)
{
    uint32_t *master_outptr = reinterpret_cast<uint32_t *>(out);
    const uint32_t *inptr = reinterpret_cast<const uint32_t *>(in);

    for (int y=y0; y<ymax; y+=8)
    {
        const int height = ymax-y;
        const long inwidth = (kmax - k0);
        const long outwidth = (inwidth * 8 + 1) / 2;
        long inpos = 0;
        long outpos = 0;

        uint32_t *outptr = master_outptr;
        master_outptr += (outwidth * 2);

        const uint32_t *inptr0 = inptr + y * ldin + k0;
        const uint32_t *inptr1 = inptr0 + ldin;
        const uint32_t *inptr2 = inptr1 + ldin;
        const uint32_t *inptr3 = inptr2 + ldin;
        const uint32_t *inptr4 = inptr3 + ldin;
        const uint32_t *inptr5 = inptr4 + ldin;
        const uint32_t *inptr6 = inptr5 + ldin;
        const uint32_t *inptr7 = inptr6 + ldin;

        switch(height)
        {
            case 1:
                __asm __volatile(
                    "1:\n"
                    "whilelt p0.s, %[inpos], %[inwidth]\n"
                    "b.none 2f\n"
                    "mov z4.s, #0\n"
                    "ld1w z0.s, p0/z, [%[inptr0]]\n"
                    "zip1 z8.d, z0.d, z4.d\n"
                    "incw %[inpos], all, mul #1\n"
                    "zip2 z9.d, z0.d, z4.d\n"
                    "addvl %[inptr0], %[inptr0], #1\n"
                    "zip1 z0.d, z8.d, z4.d\n"
                    "whilelt p0.d, %[outpos], %[outwidth]\n"
                    "zip2 z1.d, z8.d, z4.d\n"
                    "incd %[outpos], all, mul #1\n"
                    "zip1 z2.d, z9.d, z4.d\n"
                    "whilelt p1.d, %[outpos], %[outwidth]\n"
                    "zip2 z3.d, z9.d, z4.d\n"
                    "incd %[outpos], all, mul #1\n"
                    "zip1 z8.d, z0.d, z4.d\n"
                    "st1d z8.d, p0, [%[outptr]]\n"
                    "zip2 z9.d, z0.d, z4.d\n"
                    "st1d z9.d, p1, [%[outptr], #1, MUL VL]\n"
                    "zip1 z10.d, z1.d, z4.d\n"
                    "whilelt p2.d, %[outpos], %[outwidth]\n"
                    "zip2 z11.d, z1.d, z4.d\n"
                    "st1d z10.d, p2, [%[outptr], #2, MUL VL]\n"
                    "zip1 z12.d, z2.d, z4.d\n"
                    "incd %[outpos], all, mul #1\n"
                    "zip2 z13.d, z2.d, z4.d\n"
                    "whilelt p3.d, %[outpos], %[outwidth]\n"
                    "zip1 z14.d, z3.d, z4.d\n"
                    "st1d z11.d, p3, [%[outptr], #3, MUL VL]\n"
                    "zip2 z15.d, z3.d, z4.d\n"
                    "incd %[outpos], all, mul #1\n"
                    "whilelt p0.d, %[outpos], %[outwidth]\n"
                    "st1d z12.d, p0, [%[outptr], #4, MUL VL]\n"
                    "incd %[outpos], all, mul #1\n"
                    "whilelt p1.d, %[outpos], %[outwidth]\n"
                    "st1d z13.d, p1, [%[outptr], #5, MUL VL]\n"
                    "incd %[outpos], all, mul #1\n"
                    "whilelt p2.d, %[outpos], %[outwidth]\n"
                    "st1d z14.d, p2, [%[outptr], #6, MUL VL]\n"
                    "incd %[outpos], all, mul #1\n"
                    "whilelt p3.d, %[outpos], %[outwidth]\n"
                    "st1d z15.d, p3, [%[outptr], #7, MUL VL]\n"
                    "incd %[outpos], all, mul #1\n"
                    "addvl %[outptr], %[outptr], #8\n"
                    "b 1b\n"
                    "2:\n"
                : [inpos] "+r" (inpos), [outpos] "+r" (outpos), [outptr] "+r" (outptr), [inptr0] "+r" (inptr0)
                : [outwidth] "r" (outwidth), [inwidth] "r" (inwidth)
                : "p0", "p1", "p2", "p3", "z0", "z1", "z2", "z3", "z4", "z5", "z6", "z7", "z8", "z9", "z10", "z11", "z12", "z13", "z14", "z15", "cc", "memory"
                );
                break;
            
            case 2:
                __asm __volatile(
                    "1:\n"
                    "whilelt p0.s, %[inpos], %[inwidth]\n"
                    "b.none 2f\n"
                    "mov z4.s, #0\n"
                    "ld1w z0.s, p0/z, [%[inptr0]]\n"
                    "zip1 z8.d, z0.d, z4.d\n"
                    "ld1w z1.s, p0/z, [%[inptr1]]\n"
                    "zip2 z9.d, z0.d, z4.d\n"
                    "incw %[inpos], all, mul #1\n"
                    "zip1 z10.d, z1.d, z4.d\n"
                    "addvl %[inptr0], %[inptr0], #1\n"
                    "zip2 z11.d, z1.d, z4.d\n"
                    "addvl %[inptr1], %[inptr1], #1\n"
                    "zip1 z0.d, z8.d, z4.d\n"
                    "whilelt p0.d, %[outpos], %[outwidth]\n"
                    "zip2 z1.d, z8.d, z4.d\n"
                    "incd %[outpos], all, mul #1\n"
                    "zip1 z2.d, z9.d, z4.d\n"
                    "whilelt p1.d, %[outpos], %[outwidth]\n"
                    "zip2 z3.d, z9.d, z4.d\n"
                    "incd %[outpos], all, mul #1\n"
                    "mov z14.s, #0\n"
                    "whilelt p2.d, %[outpos], %[outwidth]\n"
                    "zip1 z4.d, z10.d, z14.d\n"
                    "incd %[outpos], all, mul #1\n"
                    "zip2 z5.d, z10.d, z14.d\n"
                    "whilelt p3.d, %[outpos], %[outwidth]\n"
                    "zip1 z6.d, z11.d, z14.d\n"
                    "incd %[outpos], all, mul #1\n"
                    "zip2 z7.d, z11.d, z14.d\n"
                    "zip1 z8.d, z0.d, z4.d\n"
                    "st1d z8.d, p0, [%[outptr]]\n"
                    "zip2 z9.d, z0.d, z4.d\n"
                    "st1d z9.d, p1, [%[outptr], #1, MUL VL]\n"
                    "zip1 z10.d, z1.d, z5.d\n"
                    "st1d z10.d, p2, [%[outptr], #2, MUL VL]\n"
                    "zip2 z11.d, z1.d, z5.d\n"
                    "st1d z11.d, p3, [%[outptr], #3, MUL VL]\n"
                    "zip1 z12.d, z2.d, z6.d\n"
                    "whilelt p0.d, %[outpos], %[outwidth]\n"
                    "zip2 z13.d, z2.d, z6.d\n"
                    "st1d z12.d, p0, [%[outptr], #4, MUL VL]\n"
                    "zip1 z14.d, z3.d, z7.d\n"
                    "incd %[outpos], all, mul #1\n"
                    "zip2 z15.d, z3.d, z7.d\n"
                    "whilelt p1.d, %[outpos], %[outwidth]\n"
                    "st1d z13.d, p1, [%[outptr], #5, MUL VL]\n"
                    "incd %[outpos], all, mul #1\n"
                    "whilelt p2.d, %[outpos], %[outwidth]\n"
                    "st1d z14.d, p2, [%[outptr], #6, MUL VL]\n"
                    "incd %[outpos], all, mul #1\n"
                    "whilelt p3.d, %[outpos], %[outwidth]\n"
                    "st1d z15.d, p3, [%[outptr], #7, MUL VL]\n"
                    "incd %[outpos], all, mul #1\n"
                    "addvl %[outptr], %[outptr], #8\n"
                    "b 1b\n"
                    "2:\n"
                : [inpos] "+r" (inpos), [outpos] "+r" (outpos), [outptr] "+r" (outptr), [inptr0] "+r" (inptr0), [inptr1] "+r" (inptr1)
                : [outwidth] "r" (outwidth), [inwidth] "r" (inwidth)
                : "p0", "p1", "p2", "p3", "z0", "z1", "z2", "z3", "z4", "z5", "z6", "z7", "z8", "z9", "z10", "z11", "z12", "z13", "z14", "z15", "cc", "memory"
                );
                break;
            
            case 3:
                __asm __volatile(
                    "1:\n"
                    "whilelt p0.s, %[inpos], %[inwidth]\n"
                    "b.none 2f\n"
                    "mov z4.s, #0\n"
                    "ld1w z0.s, p0/z, [%[inptr0]]\n"
                    "zip1 z8.d, z0.d, z4.d\n"
                    "ld1w z1.s, p0/z, [%[inptr1]]\n"
                    "zip2 z9.d, z0.d, z4.d\n"
                    "ld1w z2.s, p0/z, [%[inptr2]]\n"
                    "zip1 z10.d, z1.d, z4.d\n"
                    "incw %[inpos], all, mul #1\n"
                    "zip2 z11.d, z1.d, z4.d\n"
                    "addvl %[inptr0], %[inptr0], #1\n"
                    "zip1 z12.d, z2.d, z4.d\n"
                    "addvl %[inptr1], %[inptr1], #1\n"
                    "zip2 z13.d, z2.d, z4.d\n"
                    "addvl %[inptr2], %[inptr2], #1\n"
                    "zip1 z0.d, z8.d, z12.d\n"
                    "whilelt p0.d, %[outpos], %[outwidth]\n"
                    "zip2 z1.d, z8.d, z12.d\n"
                    "incd %[outpos], all, mul #1\n"
                    "zip1 z2.d, z9.d, z13.d\n"
                    "whilelt p1.d, %[outpos], %[outwidth]\n"
                    "zip2 z3.d, z9.d, z13.d\n"
                    "incd %[outpos], all, mul #1\n"
                    "mov z14.s, #0\n"
                    "whilelt p2.d, %[outpos], %[outwidth]\n"
                    "zip1 z4.d, z10.d, z14.d\n"
                    "incd %[outpos], all, mul #1\n"
                    "zip2 z5.d, z10.d, z14.d\n"
                    "whilelt p3.d, %[outpos], %[outwidth]\n"
                    "zip1 z6.d, z11.d, z14.d\n"
                    "incd %[outpos], all, mul #1\n"
                    "zip2 z7.d, z11.d, z14.d\n"
                    "zip1 z8.d, z0.d, z4.d\n"
                    "st1d z8.d, p0, [%[outptr]]\n"
                    "zip2 z9.d, z0.d, z4.d\n"
                    "st1d z9.d, p1, [%[outptr], #1, MUL VL]\n"
                    "zip1 z10.d, z1.d, z5.d\n"
                    "st1d z10.d, p2, [%[outptr], #2, MUL VL]\n"
                    "zip2 z11.d, z1.d, z5.d\n"
                    "st1d z11.d, p3, [%[outptr], #3, MUL VL]\n"
                    "zip1 z12.d, z2.d, z6.d\n"
                    "whilelt p0.d, %[outpos], %[outwidth]\n"
                    "zip2 z13.d, z2.d, z6.d\n"
                    "st1d z12.d, p0, [%[outptr], #4, MUL VL]\n"
                    "zip1 z14.d, z3.d, z7.d\n"
                    "incd %[outpos], all, mul #1\n"
                    "zip2 z15.d, z3.d, z7.d\n"
                    "whilelt p1.d, %[outpos], %[outwidth]\n"
                    "st1d z13.d, p1, [%[outptr], #5, MUL VL]\n"
                    "incd %[outpos], all, mul #1\n"
                    "whilelt p2.d, %[outpos], %[outwidth]\n"
                    "st1d z14.d, p2, [%[outptr], #6, MUL VL]\n"
                    "incd %[outpos], all, mul #1\n"
                    "whilelt p3.d, %[outpos], %[outwidth]\n"
                    "st1d z15.d, p3, [%[outptr], #7, MUL VL]\n"
                    "incd %[outpos], all, mul #1\n"
                    "addvl %[outptr], %[outptr], #8\n"
                    "b 1b\n"
                    "2:\n"
                : [inpos] "+r" (inpos), [outpos] "+r" (outpos), [outptr] "+r" (outptr), [inptr0] "+r" (inptr0), [inptr1] "+r" (inptr1), [inptr2] "+r" (inptr2)
                : [outwidth] "r" (outwidth), [inwidth] "r" (inwidth)
                : "p0", "p1", "p2", "p3", "z0", "z1", "z2", "z3", "z4", "z5", "z6", "z7", "z8", "z9", "z10", "z11", "z12", "z13", "z14", "z15", "cc", "memory"
                );
                break;
            
            case 4:
                __asm __volatile(
                    "1:\n"
                    "whilelt p0.s, %[inpos], %[inwidth]\n"
                    "b.none 2f\n"
                    "mov z4.s, #0\n"
                    "ld1w z0.s, p0/z, [%[inptr0]]\n"
                    "zip1 z8.d, z0.d, z4.d\n"
                    "ld1w z1.s, p0/z, [%[inptr1]]\n"
                    "zip2 z9.d, z0.d, z4.d\n"
                    "ld1w z2.s, p0/z, [%[inptr2]]\n"
                    "zip1 z10.d, z1.d, z4.d\n"
                    "ld1w z3.s, p0/z, [%[inptr3]]\n"
                    "zip2 z11.d, z1.d, z4.d\n"
                    "incw %[inpos], all, mul #1\n"
                    "zip1 z12.d, z2.d, z4.d\n"
                    "addvl %[inptr0], %[inptr0], #1\n"
                    "zip2 z13.d, z2.d, z4.d\n"
                    "addvl %[inptr1], %[inptr1], #1\n"
                    "zip1 z14.d, z3.d, z4.d\n"
                    "addvl %[inptr2], %[inptr2], #1\n"
                    "zip2 z15.d, z3.d, z4.d\n"
                    "addvl %[inptr3], %[inptr3], #1\n"
                    "zip1 z0.d, z8.d, z12.d\n"
                    "whilelt p0.d, %[outpos], %[outwidth]\n"
                    "zip2 z1.d, z8.d, z12.d\n"
                    "incd %[outpos], all, mul #1\n"
                    "zip1 z2.d, z9.d, z13.d\n"
                    "whilelt p1.d, %[outpos], %[outwidth]\n"
                    "zip2 z3.d, z9.d, z13.d\n"
                    "incd %[outpos], all, mul #1\n"
                    "zip1 z4.d, z10.d, z14.d\n"
                    "whilelt p2.d, %[outpos], %[outwidth]\n"
                    "zip2 z5.d, z10.d, z14.d\n"
                    "incd %[outpos], all, mul #1\n"
                    "zip1 z6.d, z11.d, z15.d\n"
                    "whilelt p3.d, %[outpos], %[outwidth]\n"
                    "zip2 z7.d, z11.d, z15.d\n"
                    "incd %[outpos], all, mul #1\n"
                    "zip1 z8.d, z0.d, z4.d\n"
                    "st1d z8.d, p0, [%[outptr]]\n"
                    "zip2 z9.d, z0.d, z4.d\n"
                    "st1d z9.d, p1, [%[outptr], #1, MUL VL]\n"
                    "zip1 z10.d, z1.d, z5.d\n"
                    "st1d z10.d, p2, [%[outptr], #2, MUL VL]\n"
                    "zip2 z11.d, z1.d, z5.d\n"
                    "st1d z11.d, p3, [%[outptr], #3, MUL VL]\n"
                    "zip1 z12.d, z2.d, z6.d\n"
                    "whilelt p0.d, %[outpos], %[outwidth]\n"
                    "zip2 z13.d, z2.d, z6.d\n"
                    "st1d z12.d, p0, [%[outptr], #4, MUL VL]\n"
                    "zip1 z14.d, z3.d, z7.d\n"
                    "incd %[outpos], all, mul #1\n"
                    "zip2 z15.d, z3.d, z7.d\n"
                    "whilelt p1.d, %[outpos], %[outwidth]\n"
                    "st1d z13.d, p1, [%[outptr], #5, MUL VL]\n"
                    "incd %[outpos], all, mul #1\n"
                    "whilelt p2.d, %[outpos], %[outwidth]\n"
                    "st1d z14.d, p2, [%[outptr], #6, MUL VL]\n"
                    "incd %[outpos], all, mul #1\n"
                    "whilelt p3.d, %[outpos], %[outwidth]\n"
                    "st1d z15.d, p3, [%[outptr], #7, MUL VL]\n"
                    "incd %[outpos], all, mul #1\n"
                    "addvl %[outptr], %[outptr], #8\n"
                    "b 1b\n"
                    "2:\n"
                : [inpos] "+r" (inpos), [outpos] "+r" (outpos), [outptr] "+r" (outptr), [inptr0] "+r" (inptr0), [inptr1] "+r" (inptr1), [inptr2] "+r" (inptr2), [inptr3] "+r" (inptr3)
                : [outwidth] "r" (outwidth), [inwidth] "r" (inwidth)
                : "p0", "p1", "p2", "p3", "z0", "z1", "z2", "z3", "z4", "z5", "z6", "z7", "z8", "z9", "z10", "z11", "z12", "z13", "z14", "z15", "cc", "memory"
                );
                break;
            
            case 5:
                __asm __volatile(
                    "1:\n"
                    "whilelt p0.s, %[inpos], %[inwidth]\n"
                    "b.none 2f\n"
                    "mov z5.s, #0\n"
                    "ld1w z0.s, p0/z, [%[inptr0]]\n"
                    "ld1w z1.s, p0/z, [%[inptr1]]\n"
                    "incw %[inpos], all, mul #1\n"
                    "zip1 z10.d, z1.d, z5.d\n"
                    "ld1w z2.s, p0/z, [%[inptr2]]\n"
                    "zip2 z11.d, z1.d, z5.d\n"
                    "ld1w z3.s, p0/z, [%[inptr3]]\n"
                    "zip1 z12.d, z2.d, z5.d\n"
                    "ld1w z4.s, p0/z, [%[inptr4]]\n"
                    "zip1 z8.d, z0.d, z4.d\n"
                    "addvl %[inptr0], %[inptr0], #1\n"
                    "zip2 z9.d, z0.d, z4.d\n"
                    "addvl %[inptr1], %[inptr1], #1\n"
                    "zip2 z13.d, z2.d, z5.d\n"
                    "addvl %[inptr2], %[inptr2], #1\n"
                    "zip1 z14.d, z3.d, z5.d\n"
                    "addvl %[inptr3], %[inptr3], #1\n"
                    "zip2 z15.d, z3.d, z5.d\n"
                    "addvl %[inptr4], %[inptr4], #1\n"
                    "zip1 z0.d, z8.d, z12.d\n"
                    "whilelt p0.d, %[outpos], %[outwidth]\n"
                    "zip2 z1.d, z8.d, z12.d\n"
                    "incd %[outpos], all, mul #1\n"
                    "zip1 z2.d, z9.d, z13.d\n"
                    "whilelt p1.d, %[outpos], %[outwidth]\n"
                    "zip2 z3.d, z9.d, z13.d\n"
                    "incd %[outpos], all, mul #1\n"
                    "zip1 z4.d, z10.d, z14.d\n"
                    "whilelt p2.d, %[outpos], %[outwidth]\n"
                    "zip2 z5.d, z10.d, z14.d\n"
                    "incd %[outpos], all, mul #1\n"
                    "zip1 z6.d, z11.d, z15.d\n"
                    "whilelt p3.d, %[outpos], %[outwidth]\n"
                    "zip2 z7.d, z11.d, z15.d\n"
                    "incd %[outpos], all, mul #1\n"
                    "zip1 z8.d, z0.d, z4.d\n"
                    "st1d z8.d, p0, [%[outptr]]\n"
                    "zip2 z9.d, z0.d, z4.d\n"
                    "st1d z9.d, p1, [%[outptr], #1, MUL VL]\n"
                    "zip1 z10.d, z1.d, z5.d\n"
                    "st1d z10.d, p2, [%[outptr], #2, MUL VL]\n"
                    "zip2 z11.d, z1.d, z5.d\n"
                    "st1d z11.d, p3, [%[outptr], #3, MUL VL]\n"
                    "zip1 z12.d, z2.d, z6.d\n"
                    "whilelt p0.d, %[outpos], %[outwidth]\n"
                    "zip2 z13.d, z2.d, z6.d\n"
                    "st1d z12.d, p0, [%[outptr], #4, MUL VL]\n"
                    "zip1 z14.d, z3.d, z7.d\n"
                    "incd %[outpos], all, mul #1\n"
                    "zip2 z15.d, z3.d, z7.d\n"
                    "whilelt p1.d, %[outpos], %[outwidth]\n"
                    "st1d z13.d, p1, [%[outptr], #5, MUL VL]\n"
                    "incd %[outpos], all, mul #1\n"
                    "whilelt p2.d, %[outpos], %[outwidth]\n"
                    "st1d z14.d, p2, [%[outptr], #6, MUL VL]\n"
                    "incd %[outpos], all, mul #1\n"
                    "whilelt p3.d, %[outpos], %[outwidth]\n"
                    "st1d z15.d, p3, [%[outptr], #7, MUL VL]\n"
                    "incd %[outpos], all, mul #1\n"
                    "addvl %[outptr], %[outptr], #8\n"
                    "b 1b\n"
                    "2:\n"
                : [inpos] "+r" (inpos), [outpos] "+r" (outpos), [outptr] "+r" (outptr), [inptr0] "+r" (inptr0), [inptr1] "+r" (inptr1), [inptr2] "+r" (inptr2), [inptr3] "+r" (inptr3), [inptr4] "+r" (inptr4)
                : [outwidth] "r" (outwidth), [inwidth] "r" (inwidth)
                : "p0", "p1", "p2", "p3", "z0", "z1", "z2", "z3", "z4", "z5", "z6", "z7", "z8", "z9", "z10", "z11", "z12", "z13", "z14", "z15", "cc", "memory"
                );
                break;
            
            case 6:
                __asm __volatile(
                    "1:\n"
                    "whilelt p0.s, %[inpos], %[inwidth]\n"
                    "b.none 2f\n"
                    "mov z6.s, #0\n"
                    "ld1w z0.s, p0/z, [%[inptr0]]\n"
                    "ld1w z1.s, p0/z, [%[inptr1]]\n"
                    "incw %[inpos], all, mul #1\n"
                    "ld1w z2.s, p0/z, [%[inptr2]]\n"
                    "addvl %[inptr0], %[inptr0], #1\n"
                    "zip1 z12.d, z2.d, z6.d\n"
                    "ld1w z3.s, p0/z, [%[inptr3]]\n"
                    "zip2 z13.d, z2.d, z6.d\n"
                    "ld1w z4.s, p0/z, [%[inptr4]]\n"
                    "zip1 z8.d, z0.d, z4.d\n"
                    "ld1w z5.s, p0/z, [%[inptr5]]\n"
                    "zip2 z9.d, z0.d, z4.d\n"
                    "addvl %[inptr1], %[inptr1], #1\n"
                    "zip1 z10.d, z1.d, z5.d\n"
                    "addvl %[inptr2], %[inptr2], #1\n"
                    "zip2 z11.d, z1.d, z5.d\n"
                    "addvl %[inptr3], %[inptr3], #1\n"
                    "zip1 z14.d, z3.d, z6.d\n"
                    "addvl %[inptr4], %[inptr4], #1\n"
                    "zip2 z15.d, z3.d, z6.d\n"
                    "addvl %[inptr5], %[inptr5], #1\n"
                    "zip1 z0.d, z8.d, z12.d\n"
                    "whilelt p0.d, %[outpos], %[outwidth]\n"
                    "zip2 z1.d, z8.d, z12.d\n"
                    "incd %[outpos], all, mul #1\n"
                    "zip1 z2.d, z9.d, z13.d\n"
                    "whilelt p1.d, %[outpos], %[outwidth]\n"
                    "zip2 z3.d, z9.d, z13.d\n"
                    "incd %[outpos], all, mul #1\n"
                    "zip1 z4.d, z10.d, z14.d\n"
                    "whilelt p2.d, %[outpos], %[outwidth]\n"
                    "zip2 z5.d, z10.d, z14.d\n"
                    "incd %[outpos], all, mul #1\n"
                    "zip1 z6.d, z11.d, z15.d\n"
                    "whilelt p3.d, %[outpos], %[outwidth]\n"
                    "zip2 z7.d, z11.d, z15.d\n"
                    "incd %[outpos], all, mul #1\n"
                    "zip1 z8.d, z0.d, z4.d\n"
                    "st1d z8.d, p0, [%[outptr]]\n"
                    "zip2 z9.d, z0.d, z4.d\n"
                    "st1d z9.d, p1, [%[outptr], #1, MUL VL]\n"
                    "zip1 z10.d, z1.d, z5.d\n"
                    "st1d z10.d, p2, [%[outptr], #2, MUL VL]\n"
                    "zip2 z11.d, z1.d, z5.d\n"
                    "st1d z11.d, p3, [%[outptr], #3, MUL VL]\n"
                    "zip1 z12.d, z2.d, z6.d\n"
                    "whilelt p0.d, %[outpos], %[outwidth]\n"
                    "zip2 z13.d, z2.d, z6.d\n"
                    "st1d z12.d, p0, [%[outptr], #4, MUL VL]\n"
                    "zip1 z14.d, z3.d, z7.d\n"
                    "incd %[outpos], all, mul #1\n"
                    "zip2 z15.d, z3.d, z7.d\n"
                    "whilelt p1.d, %[outpos], %[outwidth]\n"
                    "st1d z13.d, p1, [%[outptr], #5, MUL VL]\n"
                    "incd %[outpos], all, mul #1\n"
                    "whilelt p2.d, %[outpos], %[outwidth]\n"
                    "st1d z14.d, p2, [%[outptr], #6, MUL VL]\n"
                    "incd %[outpos], all, mul #1\n"
                    "whilelt p3.d, %[outpos], %[outwidth]\n"
                    "st1d z15.d, p3, [%[outptr], #7, MUL VL]\n"
                    "incd %[outpos], all, mul #1\n"
                    "addvl %[outptr], %[outptr], #8\n"
                    "b 1b\n"
                    "2:\n"
                : [inpos] "+r" (inpos), [outpos] "+r" (outpos), [outptr] "+r" (outptr), [inptr0] "+r" (inptr0), [inptr1] "+r" (inptr1), [inptr2] "+r" (inptr2), [inptr3] "+r" (inptr3), [inptr4] "+r" (inptr4), [inptr5] "+r" (inptr5)
                : [outwidth] "r" (outwidth), [inwidth] "r" (inwidth)
                : "p0", "p1", "p2", "p3", "z0", "z1", "z2", "z3", "z4", "z5", "z6", "z7", "z8", "z9", "z10", "z11", "z12", "z13", "z14", "z15", "cc", "memory"
                );
                break;
            
            case 7:
                __asm __volatile(
                    "1:\n"
                    "whilelt p0.s, %[inpos], %[inwidth]\n"
                    "b.none 2f\n"
                    "mov z7.s, #0\n"
                    "ld1w z0.s, p0/z, [%[inptr0]]\n"
                    "ld1w z1.s, p0/z, [%[inptr1]]\n"
                    "incw %[inpos], all, mul #1\n"
                    "ld1w z2.s, p0/z, [%[inptr2]]\n"
                    "addvl %[inptr0], %[inptr0], #1\n"
                    "ld1w z3.s, p0/z, [%[inptr3]]\n"
                    "addvl %[inptr1], %[inptr1], #1\n"
                    "zip1 z14.d, z3.d, z7.d\n"
                    "ld1w z4.s, p0/z, [%[inptr4]]\n"
                    "zip1 z8.d, z0.d, z4.d\n"
                    "ld1w z5.s, p0/z, [%[inptr5]]\n"
                    "zip2 z9.d, z0.d, z4.d\n"
                    "ld1w z6.s, p0/z, [%[inptr6]]\n"
                    "zip1 z10.d, z1.d, z5.d\n"
                    "addvl %[inptr2], %[inptr2], #1\n"
                    "zip2 z11.d, z1.d, z5.d\n"
                    "addvl %[inptr3], %[inptr3], #1\n"
                    "zip1 z12.d, z2.d, z6.d\n"
                    "addvl %[inptr4], %[inptr4], #1\n"
                    "zip2 z13.d, z2.d, z6.d\n"
                    "addvl %[inptr5], %[inptr5], #1\n"
                    "zip2 z15.d, z3.d, z7.d\n"
                    "addvl %[inptr6], %[inptr6], #1\n"
                    "zip1 z0.d, z8.d, z12.d\n"
                    "whilelt p0.d, %[outpos], %[outwidth]\n"
                    "zip2 z1.d, z8.d, z12.d\n"
                    "incd %[outpos], all, mul #1\n"
                    "zip1 z2.d, z9.d, z13.d\n"
                    "whilelt p1.d, %[outpos], %[outwidth]\n"
                    "zip2 z3.d, z9.d, z13.d\n"
                    "incd %[outpos], all, mul #1\n"
                    "zip1 z4.d, z10.d, z14.d\n"
                    "whilelt p2.d, %[outpos], %[outwidth]\n"
                    "zip2 z5.d, z10.d, z14.d\n"
                    "incd %[outpos], all, mul #1\n"
                    "zip1 z6.d, z11.d, z15.d\n"
                    "whilelt p3.d, %[outpos], %[outwidth]\n"
                    "zip2 z7.d, z11.d, z15.d\n"
                    "incd %[outpos], all, mul #1\n"
                    "zip1 z8.d, z0.d, z4.d\n"
                    "st1d z8.d, p0, [%[outptr]]\n"
                    "zip2 z9.d, z0.d, z4.d\n"
                    "st1d z9.d, p1, [%[outptr], #1, MUL VL]\n"
                    "zip1 z10.d, z1.d, z5.d\n"
                    "st1d z10.d, p2, [%[outptr], #2, MUL VL]\n"
                    "zip2 z11.d, z1.d, z5.d\n"
                    "st1d z11.d, p3, [%[outptr], #3, MUL VL]\n"
                    "zip1 z12.d, z2.d, z6.d\n"
                    "whilelt p0.d, %[outpos], %[outwidth]\n"
                    "zip2 z13.d, z2.d, z6.d\n"
                    "st1d z12.d, p0, [%[outptr], #4, MUL VL]\n"
                    "zip1 z14.d, z3.d, z7.d\n"
                    "incd %[outpos], all, mul #1\n"
                    "zip2 z15.d, z3.d, z7.d\n"
                    "whilelt p1.d, %[outpos], %[outwidth]\n"
                    "st1d z13.d, p1, [%[outptr], #5, MUL VL]\n"
                    "incd %[outpos], all, mul #1\n"
                    "whilelt p2.d, %[outpos], %[outwidth]\n"
                    "st1d z14.d, p2, [%[outptr], #6, MUL VL]\n"
                    "incd %[outpos], all, mul #1\n"
                    "whilelt p3.d, %[outpos], %[outwidth]\n"
                    "st1d z15.d, p3, [%[outptr], #7, MUL VL]\n"
                    "incd %[outpos], all, mul #1\n"
                    "addvl %[outptr], %[outptr], #8\n"
                    "b 1b\n"
                    "2:\n"
                : [inpos] "+r" (inpos), [outpos] "+r" (outpos), [outptr] "+r" (outptr), [inptr0] "+r" (inptr0), [inptr1] "+r" (inptr1), [inptr2] "+r" (inptr2), [inptr3] "+r" (inptr3), [inptr4] "+r" (inptr4), [inptr5] "+r" (inptr5), [inptr6] "+r" (inptr6)
                : [outwidth] "r" (outwidth), [inwidth] "r" (inwidth)
                : "p0", "p1", "p2", "p3", "z0", "z1", "z2", "z3", "z4", "z5", "z6", "z7", "z8", "z9", "z10", "z11", "z12", "z13", "z14", "z15", "cc", "memory"
                );
                break;
            
            default:
            case 8:
                __asm __volatile(
                    "1:\n"
                    "whilelt p0.s, %[inpos], %[inwidth]\n"
                    "b.none 2f\n"
                    "ld1w z0.s, p0/z, [%[inptr0]]\n"
                    "incw %[inpos], all, mul #1\n"
                    "ld1w z1.s, p0/z, [%[inptr1]]\n"
                    "addvl %[inptr0], %[inptr0], #1\n"
                    "ld1w z2.s, p0/z, [%[inptr2]]\n"
                    "addvl %[inptr1], %[inptr1], #1\n"
                    "ld1w z3.s, p0/z, [%[inptr3]]\n"
                    "addvl %[inptr2], %[inptr2], #1\n"
                    "ld1w z4.s, p0/z, [%[inptr4]]\n"
                    "addvl %[inptr3], %[inptr3], #1\n"
                    "zip1 z8.d, z0.d, z4.d\n"
                    "ld1w z5.s, p0/z, [%[inptr5]]\n"
                    "zip2 z9.d, z0.d, z4.d\n"
                    "ld1w z6.s, p0/z, [%[inptr6]]\n"
                    "zip1 z10.d, z1.d, z5.d\n"
                    "ld1w z7.s, p0/z, [%[inptr7]]\n"
                    "zip2 z11.d, z1.d, z5.d\n"
                    "addvl %[inptr4], %[inptr4], #1\n"
                    "zip1 z12.d, z2.d, z6.d\n"
                    "addvl %[inptr5], %[inptr5], #1\n"
                    "zip2 z13.d, z2.d, z6.d\n"
                    "addvl %[inptr6], %[inptr6], #1\n"
                    "zip1 z14.d, z3.d, z7.d\n"
                    "addvl %[inptr7], %[inptr7], #1\n"
                    "zip2 z15.d, z3.d, z7.d\n"
                    "whilelt p0.d, %[outpos], %[outwidth]\n"
                    "zip1 z0.d, z8.d, z12.d\n"
                    "incd %[outpos], all, mul #1\n"
                    "zip2 z1.d, z8.d, z12.d\n"
                    "whilelt p1.d, %[outpos], %[outwidth]\n"
                    "zip1 z2.d, z9.d, z13.d\n"
                    "incd %[outpos], all, mul #1\n"
                    "zip2 z3.d, z9.d, z13.d\n"
                    "whilelt p2.d, %[outpos], %[outwidth]\n"
                    "zip1 z4.d, z10.d, z14.d\n"
                    "incd %[outpos], all, mul #1\n"
                    "zip2 z5.d, z10.d, z14.d\n"
                    "whilelt p3.d, %[outpos], %[outwidth]\n"
                    "zip1 z6.d, z11.d, z15.d\n"
                    "incd %[outpos], all, mul #1\n"
                    "zip2 z7.d, z11.d, z15.d\n"
                    "zip1 z8.d, z0.d, z4.d\n"
                    "st1d z8.d, p0, [%[outptr]]\n"
                    "zip2 z9.d, z0.d, z4.d\n"
                    "st1d z9.d, p1, [%[outptr], #1, MUL VL]\n"
                    "zip1 z10.d, z1.d, z5.d\n"
                    "st1d z10.d, p2, [%[outptr], #2, MUL VL]\n"
                    "zip2 z11.d, z1.d, z5.d\n"
                    "st1d z11.d, p3, [%[outptr], #3, MUL VL]\n"
                    "zip1 z12.d, z2.d, z6.d\n"
                    "whilelt p0.d, %[outpos], %[outwidth]\n"
                    "zip2 z13.d, z2.d, z6.d\n"
                    "st1d z12.d, p0, [%[outptr], #4, MUL VL]\n"
                    "zip1 z14.d, z3.d, z7.d\n"
                    "incd %[outpos], all, mul #1\n"
                    "zip2 z15.d, z3.d, z7.d\n"
                    "whilelt p1.d, %[outpos], %[outwidth]\n"
                    "st1d z13.d, p1, [%[outptr], #5, MUL VL]\n"
                    "incd %[outpos], all, mul #1\n"
                    "whilelt p2.d, %[outpos], %[outwidth]\n"
                    "st1d z14.d, p2, [%[outptr], #6, MUL VL]\n"
                    "incd %[outpos], all, mul #1\n"
                    "whilelt p3.d, %[outpos], %[outwidth]\n"
                    "st1d z15.d, p3, [%[outptr], #7, MUL VL]\n"
                    "incd %[outpos], all, mul #1\n"
                    "addvl %[outptr], %[outptr], #8\n"
                    "b 1b\n"
                    "2:\n"
                : [inpos] "+r" (inpos), [outpos] "+r" (outpos), [outptr] "+r" (outptr), [inptr0] "+r" (inptr0), [inptr1] "+r" (inptr1), [inptr2] "+r" (inptr2), [inptr3] "+r" (inptr3), [inptr4] "+r" (inptr4), [inptr5] "+r" (inptr5), [inptr6] "+r" (inptr6), [inptr7] "+r" (inptr7)
                : [outwidth] "r" (outwidth), [inwidth] "r" (inwidth)
                : "p0", "p1", "p2", "p3", "z0", "z1", "z2", "z3", "z4", "z5", "z6", "z7", "z8", "z9", "z10", "z11", "z12", "z13", "z14", "z15", "cc", "memory"
                );
                break;
            
            
        }
    }
}

#endif // __ARM_FEATURE_SVE
