/*
 * Copyright (c) 1995 - 2001 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <nnpfs/nnpfs_locl.h>
#include <nnpfs/nnpfs_message.h>
#include <nnpfs/nnpfs_fs.h>
#include <nnpfs/nnpfs_dev.h>
#include <nnpfs/nnpfs_syscalls.h>

RCSID("$Id: nnpfs_wrap-osf.c,v 1.10 2002/09/07 10:45:41 lha Exp $");

#include <nnpfs/nnpfs_deb.h>

extern int nnpfs_dev_major;

cfg_subsys_attr_t nnpfs_attributes[] = {
    { 
	"syscall",
	CFG_ATTR_INTTYPE,
	CFG_OP_QUERY, 
	(caddr_t)&nnpfs_syscall_num,
	0,
	0,
	0 
    },
    {
	"major",
	CFG_ATTR_INTTYPE,
	CFG_OP_QUERY, 
	(caddr_t)&nnpfs_dev_major,
	0,
	0,
	0 
    },
    { 
	"debug",
	CFG_ATTR_UINTTYPE,
	CFG_OP_QUERY|CFG_OP_RECONFIGURE,
	(caddr_t)&nnpfsdeb,
	0,
	0xffffffff,
	0 
    },
    { "" }
};

/*
 * Iff `dev' represents a valid nnpfs device.
 */

int
nnpfs_is_nnpfs_dev (dev_t dev)
{
    return major (dev) == nnpfs_dev_major
	&& minor(dev) >= 0 && minor(dev) < NNNPFS;
}

int
nnpfs_configure(cfg_op_t op,
	      cfg_attr_t *indata,
	      size_t indatalen,
	      cfg_attr_t *outdata,
	      size_t outdatalen)
{
    int ret = 0;
    
    switch(op) {
    case CFG_OP_CONFIGURE:
	nnpfs_install_syscall();
	ret = nnpfs_install_device();
	if(ret) {
	    nnpfs_uninstall_syscall();
	    break;
	}
	ret = nnpfs_install_fs();
	if(ret) {
	    nnpfs_uninstall_fs();
	    nnpfs_uninstall_syscall();
	    break;
	}
	break;
    case CFG_OP_UNCONFIGURE:
	ret = nnpfs_uninstall_fs();
	if(ret != 0)
	    break;
	ret = nnpfs_uninstall_device();
	if(ret != 0)
	    break;
	/* this won't fail */
	nnpfs_uninstall_syscall();
	break;
    case CFG_OP_QUERY:
    case CFG_OP_RECONFIGURE:
	break;
    default:
	return ENOTSUP;
    }
    return ret;
}
