// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GDKMM_IMAGE_H
#define _GDKMM_IMAGE_H

#include <glibmm.h>

/* $Id: image.h,v 1.1 2005/03/22 21:05:16 taybin Exp $ */

/* bitmap.h
 *
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <gdkmm/visual.h>
#include <gdkmm/colormap.h>
#include <gdkmm/types.h> //For ByteOrder.
#include <gdk/gdkimage.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdkImage GdkImage;
typedef struct _GdkImageClass GdkImageClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{ class Image_Class; } // namespace Gdk
namespace Gdk
{


/** @addtogroup gdkmmEnums Enums and Flags */

/**
 * @ingroup gdkmmEnums
 */
enum ImageType
{
  IMAGE_NORMAL,
  IMAGE_SHARED,
  IMAGE_FASTEST
};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::ImageType> : public Glib::Value_Enum<Gdk::ImageType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{


/** This represents an area for drawing graphics. It has now been superceded to a large extent by the much more flexible
 * Gdk::Drawable RGB functions.
 * To create an image from part of a Gdk::Window use Gdk::Drawable::get_image().
 *
 * The image can be manipulated with get_pixel() and put_pixel(), or alternatively by changing the actual pixel data, though
 * manipulating the pixel data requires complicated code to cope with the different formats that may be used.
 * To draw a Gdk::Image in a Gdk::Window or Gdk::Pixmap use Gdk::Drawable::draw_image().
 */

class Image : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Image CppObjectType;
  typedef Image_Class CppClassType;
  typedef GdkImage BaseObjectType;
  typedef GdkImageClass BaseClassType;

private:  friend class Image_Class;
  static CppClassType image_class_;

private:
  // noncopyable
  Image(const Image&);
  Image& operator=(const Image&);

protected:
  explicit Image(const Glib::ConstructParams& construct_params);
  explicit Image(GdkImage* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Image();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdkImage*       gobj()       { return reinterpret_cast<GdkImage*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdkImage* gobj() const { return reinterpret_cast<GdkImage*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdkImage* gobj_copy();

private:

  
protected:

  /** Instantiate a new Gdk::Image.
   *
   * @param type The type of the Gdk::Image. Gdk::IMAGE_FASTEST is probably the best choice, since it will try to create a Gdk::IMAGE_SHARED image first and if that fails it will then use Gdk::IMAGE_NORMAL.
   * @param visual The Gdk::Visual to use for the image.
   * @param width The width of the image in pixels.
   * @param height The height of the image in pixels.
   */
  Image(ImageType type, const Glib::RefPtr<Visual>& visual, int	width, int height);
  
  
public:
  
  static Glib::RefPtr<Image> create(ImageType type, const Glib::RefPtr<Visual>& visual, int width, int height);


  //We ignore gdk_image_new_bitmap() because the documentation says that it is incredibly broken.
  

  void put_pixel(int x, int y, guint32 pixel);
  
  guint32 get_pixel(int	x, int	y) const;
  
  /** Sets the colormap for the image to the given colormap.  Normally
   * there's no need to use this function, images are created with the
   * correct colormap if you get the image from a drawable. If you
   * create the image from scratch, use the colormap of the drawable you
   * intend to render the image to.
   * @param colormap A Gdk::Colormap.
   */
  void set_colormap(const Glib::RefPtr<Colormap>& colormap);
  
  /** Retrieves the colormap for a given image, if it exists.  An image
   * will have a colormap if the drawable from which it was created has
   * a colormap, or if a colormap was set explicitely with
   * set_colormap().
   * @return Colormap for the image.
   */
  Glib::RefPtr<Colormap> get_colormap();
  
  /** Retrieves the colormap for a given image, if it exists.  An image
   * will have a colormap if the drawable from which it was created has
   * a colormap, or if a colormap was set explicitely with
   * set_colormap().
   * @return Colormap for the image.
   */
  Glib::RefPtr<const Colormap> get_colormap() const;
  
  ImageType get_image_type() const;
  Glib::RefPtr<Visual> get_visual();
  Glib::RefPtr<const Visual> get_visual() const;
  ByteOrder get_byte_order() const;
  int get_width() const;
  int get_height() const;
  guint16 get_bpp() const;
  guint16 get_bpl() const;
  guint16 get_bits_per_pixel() const;

  //This memory block is not read-only, apparently:
  void* get_mem();
  const void* get_mem() const;

  //TODO: This should be const really.
  void* get_windowing_data() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} /* namespace Gdk */


namespace Glib
{
  /** @relates Gdk::Image
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gdk::Image> wrap(GdkImage* object, bool take_copy = false);
}


#endif /* _GDKMM_IMAGE_H */

