/*
    Copyright (C) 2002 Paul Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: audio_track.h,v 1.10 2004/02/29 23:33:57 pauld Exp $
*/

#ifndef __ardour_audio_track_h__
#define __ardour_audio_track_h__

#include <ardour/route.h>

namespace ARDOUR {

class Session;
class DiskStream;

class AudioTrack : public Route
{
  public:
	AudioTrack (Session&, string name, Route::Flag f = Route::Flag (0));
	AudioTrack (Session&, const XMLNode&);
	~AudioTrack ();
	
	void set_name (string str, void *src);

	int  roll (jack_nframes_t nframes, jack_nframes_t end_frame, jack_nframes_t offset, int declick,
		   bool can_record, bool rec_monitors_input);
	int  no_roll (jack_nframes_t nframes, jack_nframes_t end_frame, jack_nframes_t offset, bool state_changing,
		      bool can_record, bool rec_monitors_input);

	void toggle_monitor_input ();

	bool can_record() const { return true; }
	void set_record_enable (bool yn, void *src);
	bool record_enabled() const;

	IO& input_io();
	IO& output_io() { return *this; }

	DiskStream& disk_stream() const { return *diskstream; }
	int set_diskstream (DiskStream&, void *);
	int use_diskstream (string name);
	int use_diskstream (id_t id);

	jack_nframes_t update_total_latency();
	
	int export_stuff (vector<Sample*>& buffers, jack_nframes_t nframes, jack_nframes_t end_frame);

	SigC::Signal1<void,void*> diskstream_changed;

	int set_state(const XMLNode& node);
	
	
	enum FreezeState {
		NoFreeze,
		Frozen,
		UnFrozen
	};

	FreezeState freeze_state() const { return _freeze_state; }
 
	void freeze (UndoCommand);
	void unfreeze ();
	void refreeze ();

  protected:
	DiskStream *diskstream;

	void passthru         (jack_nframes_t nframes, jack_nframes_t offset, int declick);
	void passthru_silence (jack_nframes_t nframes, jack_nframes_t offset, int declick);

  private:
	FreezeState _freeze_state;
	UndoCommand _freeze_cmd;

	void diskstream_record_enable_changed (void *src);
	void diskstream_input_channel_changed (void *src);

	void input_change_handler (void *src);
	void output_change_handler (void *src);

	SigC::Connection recenable_connection;
	XMLNode& state(bool);
};

}; /* namespace ARDOUR*/

#endif /* __ardour_audio_track_h__ */
