/*
    Copyright (C) 2001 Paul Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: streamview.h,v 1.30 2004/02/20 22:00:17 pauld Exp $
*/

#ifndef __ardour_streamview_h__
#define __ardour_streamview_h__

#include <list>
#include <cmath>

#include <gtk--.h>
#include <gtk-canvas.h>

#include <ardour/location.h>
#include "enums.h"

namespace ARDOUR {
	class Route;
	class DiskStream;
	class Crossfade;
	class PeakData;
	class AudioRegion;
}


class PublicEditor;
class Selectable;
class AudioTimeAxisView;
class AudioRegionView;
class AudioRegionSelection;
class CrossfadeView;

class StreamView : public SigC::Object
{
  public:
	StreamView (AudioTimeAxisView&);
	~StreamView ();

	void set_waveform_shape (WaveformShape);

	AudioTimeAxisView& trackview() { return _trackview; }

	void set_zoom_all();

	int set_height (gdouble);
	int set_position (gdouble x, gdouble y);

	int set_samples_per_unit (gdouble spp);
	gdouble get_samples_per_unit () { return _samples_per_unit; }

	int set_amplitude_above_axis (gdouble app);
	gdouble get_amplitude_above_axis () { return _amplitude_above_axis; }

	void set_show_waveforms (bool yn);

	GtkCanvasItem *canvas_item() { return canvas_group; }

	SigC::Signal1<void,AudioRegionView*> AudioRegionViewAdded;

	enum ColorTarget {
		RegionColor,
		StreamBaseColor
	};

	void apply_color (GdkColor&, ColorTarget t);
	void set_selected_regionviews (AudioRegionSelection&);
	void get_selectables (jack_nframes_t start, jack_nframes_t end, list<Selectable *>&);

	void foreach_regionview (SigC::Slot1<void,AudioRegionView*> slot);

	void attach ();
	
	void region_layered (AudioRegionView*);
	
	AudioRegionView* find_view (const ARDOUR::AudioRegion&);

  private:
	AudioTimeAxisView& _trackview;

	GtkCanvasItem *canvas_group;
	GtkCanvasItem *canvas_rect; /* frame around the whole thing */

	typedef list<AudioRegionView *> AudioRegionViewList;
	AudioRegionViewList region_views;

	typedef list<CrossfadeView*> CrossfadeViewList;
	CrossfadeViewList crossfade_views;

	double _samples_per_unit;
	double _amplitude_above_axis;

	SigC::Connection screen_update_connection;
	vector<GtkCanvasItem *> rec_rects;
	bool rec_updating;
	void update_rec_box ();
	void transport_changed();
	void rec_enable_changed(void * src = 0);
	void sess_rec_enable_changed();
	void setup_rec_box ();
	
	void add_region_view (ARDOUR::Region *);
	void remove_region_view (ARDOUR::Region *);

	void display_diskstream (ARDOUR::DiskStream *);
	void undisplay_diskstream ();
	void redisplay_diskstream ();
	void diskstream_changed (void *);
	void playlist_state_changed (ARDOUR::Change);
	void playlist_changed (ARDOUR::DiskStream *);
	void playlist_modified ();

	void add_crossfade (ARDOUR::Crossfade*);
	void remove_crossfade (ARDOUR::Crossfade*);

	/* XXX why are these different? */
	
	GdkColor region_color;
	unsigned int stream_base_color;

	vector<SigC::Connection> playlist_connections;
	SigC::Connection playlist_change_connection;
};

#endif /* __ardour_streamview_h__ */
