/*
    Copyright (C) 2002 Paul Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: send_ui.cc,v 1.5 2003/12/13 20:53:09 pbd Exp $
*/

#include <ardour/send.h>

#include "utils.h"
#include "send_ui.h"
#include "io_selector.h"
#include "doi.h"
#include "ardour_ui.h"

using namespace ARDOUR;

SendUI::SendUI (Send& s, Session& se)
	: _send (s),
	  _session (se),
	  gpm (s, se)
{
	hbox.pack_start (gpm, true, true);
	set_name ("SendUIFrame");
	
	vbox.set_spacing (5);
	vbox.set_border_width (5);

	vbox.pack_start (hbox, false, false, false);
	vbox.pack_start (gpm.pan_box, false,false);

	io = new IOSelector (se, s, false);
	
	pack_start (vbox, false, false);

	pack_start (*io, true, true);

	show_all ();

	_send.set_metering (true);
	_send.output_configuration_changed.connect (slot (*this, &SendUI::output_configuration_changed));
	
	gpm.setup_pan ();
	gpm.setup_meters ();

	screen_update_connection = ARDOUR_UI::instance()->RapidScreenUpdate.connect (slot (*this, &SendUI::update));
}

SendUI::~SendUI ()
{
	_send.set_metering (false);
	screen_update_connection.disconnect();
}

void
SendUI::output_configuration_changed (void* ignored)
{
	gpm.setup_pan();
}

void
SendUI::send_going_away (Redirect *ignored)
{
	delete_when_idle<SendUI> (this);
}

void
SendUI::update ()
{
	gpm.update_meters ();
}
	
SendUIWindow::SendUIWindow (Send& s, Session& ss)
{
	ui = new SendUI (s, ss);

	vpacker.set_border_width (5);

	hpacker.pack_start (*ui, true, true);

	vpacker.pack_start (hpacker);

	add (vpacker);
	set_name ("SendUIWindow");

	s.GoingAway.connect (slot (*this, &SendUIWindow::send_going_away));

	delete_event.connect (bind (slot (just_hide_it), reinterpret_cast<Window *> (this)));

}

SendUIWindow::~SendUIWindow ()
{
}

void
SendUIWindow::send_going_away (Redirect *ignored)
{
	delete_when_idle<SendUIWindow> (this);
}

