/*
    Copyright (C) 2004 Paul Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: mixer_selection.h,v 1.1 2004/02/10 18:31:27 pauld Exp $
*/

#ifndef __ardour_gtk_mixer_selection_h__
#define __ardour_gtk_mixer_selection_h__

#include <sigc++/signal_system.h>

#include "redirect_selection.h"
#include "strip_selection.h"

class MixerSelection : public SigC::Object 
{
  public:
	RedirectSelection    redirects;
	MixerStripSelection  strips;

	MixerSelection() {}

	MixerSelection& operator= (const MixerSelection& other);

	SigC::Signal0<void> RedirectsChanged;
	SigC::Signal0<void> MixerStripsChanged;

	void clear ();
	bool empty();

	void set (ARDOUR::Redirect*);
	void add (ARDOUR::Redirect*);
	void remove (ARDOUR::Redirect*);

	void set (MixerStrip*);
	void add (MixerStrip*);
	void remove (MixerStrip*);

	void clear_redirects ();
	void clear_strips ();

	bool selected (MixerStrip*);
};

bool operator==(const MixerSelection& a, const MixerSelection& b);

#endif /* __ardour_gtk_mixer_selection_h__ */
