/*
    Copyright (C) 2000 Paul Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: ardour_ui_ed.cc,v 1.64 2004/01/15 01:56:10 pbd Exp $
*/

/* This file contains any ARDOUR_UI methods that require knowledge of
   the editor, and exists so that no compilation dependency exists
   between the main ARDOUR_UI modules and the PublicEditor class. This
   is to cut down on the nasty compile times for both these classes.
*/


#include "ardour_ui.h"
#include "public_editor.h"
#include "audio_clock.h"
#include "editor.h"

#include <ardour/session.h>

#include "i18n.h"

using namespace ARDOUR;
using namespace Gtk;
using namespace Gtkmmext;

int
ARDOUR_UI::create_editor ()

{
	try {
		editor = new Editor (*engine);
	}

	catch (failed_constructor& err) {
		return -1;
	}

	return 0;
}

void
ARDOUR_UI::build_menu_bar ()

{
	using namespace Menu_Helpers;

	menu_bar.set_name ("MainMenuBar");

	MenuList& items = menu_bar.items();

	/* file menu */
	
	Menu *session_menu = manage (new Menu);
	MenuList& file_items = session_menu->items();

	file_items.push_back (MenuElem (_("New"), slot (*this, &ARDOUR_UI::new_session)));
	file_items.push_back (MenuElem (_("Open"), slot (*this, &ARDOUR_UI::open_session)));
	file_items.push_back (MenuElem (_("Recent"), slot (*this, &ARDOUR_UI::open_recent_session)));
	file_items.push_back (MenuElem (_("Close"), slot (*this, &ARDOUR_UI::unload_session)));
	close_item = file_items.back();
	close_item->set_sensitive (false);

	file_items.push_back (SeparatorElem());

	file_items.push_back (MenuElem (_("Add Track/Bus"), slot (*this, &ARDOUR_UI::add_route)));
	add_track_item = file_items.back ();
	add_track_item->set_sensitive (false);

	file_items.push_back (SeparatorElem());
	
	/* <CMT Additions> */
	Menu* image_compositor_menu = manage(new Menu());
	MenuList& image_compositor_items = image_compositor_menu->items();
	image_compositor_items.push_back(MenuElem (_("Connect"), (slot (editor, &PublicEditor::connect_to_image_compositor)))) ;
	file_items.push_back(MenuElem (_("Image Compositor"), *image_compositor_menu)) ;
	image_compositor_item = file_items.back() ;
	//image_compositor_item->set_sensitive(false) ;
	file_items.push_back (SeparatorElem());
	/* </CMT Additions> */


	file_items.push_back (MenuElem (_("Save"), bind (slot (*this, &ARDOUR_UI::save_state), string(""))));
	save_item = file_items.back();
	save_item->set_sensitive (false);

	file_items.push_back (MenuElem (_("Snapshot"), slot (*this, &ARDOUR_UI::snapshot_session)));
	snapshot_item = file_items.back();
	snapshot_item->set_sensitive (false);
/*
	file_items.push_back (MenuElem (_("Save as...")));
	save_as_item = file_items.back();
	save_as_item->set_sensitive (false);
*/
	file_items.push_back (MenuElem (_("Save Template..."), slot (*this, &ARDOUR_UI::save_template)));
	save_template_item = file_items.back();
	save_template_item->set_sensitive (false);

	Menu *export_menu = manage (new Menu);
	MenuList& export_items = export_menu->items();
	
	export_items.push_back (MenuElem (_("Export session to audiofile..."), slot (*editor, &PublicEditor::export_session)));
	export_items.push_back (MenuElem (_("Export selection to audiofile..."), slot (*editor, &PublicEditor::export_selection)));
	export_items.push_back (MenuElem (_("Export to CD")));
	export_items.back()->set_sensitive (false);
	export_items.push_back (MenuElem (_("Export CD track markers"), slot (*editor, &PublicEditor::start_export_cd_markers)));

	file_items.push_back (MenuElem (_("Export"), *export_menu));
	export_item = file_items.back();
	export_item->set_sensitive (false);

	file_items.push_back (SeparatorElem());

	Menu *cleanup_menu = manage (new Menu);
	MenuList& cleanup_items = cleanup_menu->items();
	
	cleanup_items.push_back (MenuElem (_("Cleanup unused sources"), slot (*(ARDOUR_UI::instance()), &ARDOUR_UI::cleanup)));
	cleanup_items.push_back (MenuElem (_("Flush wastebasket"), slot (*(ARDOUR_UI::instance()), &ARDOUR_UI::flush_trash)));

	file_items.push_back (MenuElem (_("Cleanup"), *cleanup_menu));
	cleanup_item = file_items.back ();
	cleanup_item->set_sensitive (false);

	file_items.push_back (SeparatorElem());
	file_items.push_back (MenuElem (_("Quit"), slot (*(ARDOUR_UI::instance()), &ARDOUR_UI::finish)));

	items.push_back (MenuElem (_("Session"), *session_menu));

	/* edit menu; the editor is responsible for the contents */

	Menu *edit_menu = manage (new Menu);
	editor->set_edit_menu (*edit_menu);
	items.push_back (MenuElem (_("Edit"), *edit_menu));

	/* windows menu */

	Menu *window_menu = new Menu();
	MenuList& window_items = window_menu->items();

	window_items.push_back (TearoffMenuElem());

	window_items.push_back (MenuElem (_("Editor"), slot (*this, &ARDOUR_UI::goto_editor_window)));
	window_items.push_back (MenuElem (_("Mixer"), slot (*this, &ARDOUR_UI::goto_mixer_window)));

	window_items.push_back (SeparatorElem());

	window_items.push_back 
		(CheckMenuElem 
		 (_("Options Editor"),
		  slot (*this, &ARDOUR_UI::toggle_options_window)));
	 options_window_check = dynamic_cast<CheckMenuItem*>(window_items.back());
	// options_window_check->set_sensitive (false);

	window_items.push_back
		(CheckMenuElem
		 (_("Audio Library"),
		  slot (*this, &ARDOUR_UI::toggle_sfdb_window)));
	sfdb_check = dynamic_cast<CheckMenuItem*>(window_items.back());

	window_items.push_back 
		(CheckMenuElem 
		 (_("Route Parameters"),
		  slot (*this, &ARDOUR_UI::toggle_route_params_window)));
	route_params_check = dynamic_cast<CheckMenuItem*>(window_items.back());
	route_params_check->set_sensitive (false);

	window_items.push_back 
		(CheckMenuElem 
		 (_("Connections"),
		  slot (*this, &ARDOUR_UI::toggle_connection_editor)));
	connection_editor_check = dynamic_cast<CheckMenuItem*>(window_items.back());
	connection_editor_check->set_sensitive (false);

	window_items.push_back 
		(CheckMenuElem 
		 (_("Meter Bridge"),
		  slot (*this, &ARDOUR_UI::toggle_meter_bridge_window)));
	meter_bridge_dialog_check = dynamic_cast<CheckMenuItem*>(window_items.back());
	meter_bridge_dialog_check->set_sensitive (false);

	window_items.push_back 
		(CheckMenuElem 
		 (_("Locations"),
		  slot (*this, &ARDOUR_UI::toggle_location_window)));
	locations_dialog_check = dynamic_cast<CheckMenuItem*>(window_items.back());
	locations_dialog_check->set_sensitive (false);

	window_items.push_back 
		(CheckMenuElem 
		 (_("Big Clock"),
		  slot (*this, &ARDOUR_UI::toggle_big_clock_window)));
	big_clock_check = dynamic_cast<CheckMenuItem*>(window_items.back());

	window_items.push_back (SeparatorElem());

	window_items.push_back (MenuElem (_("About"), slot (*this, &ARDOUR_UI::show_splash)));
	
	
	items.push_back (MenuElem (_("Windows"), *window_menu));

	wall_clock_box.add (wall_clock_label);
	wall_clock_box.set_name ("WallClock");
	wall_clock_label.set_name ("WallClock");

	disk_space_box.add (disk_space_label);
	disk_space_box.set_name ("WallClock");
	disk_space_label.set_name ("WallClock");

	cpu_load_box.add (cpu_load_label);
	cpu_load_box.set_name ("CPULoad");
	cpu_load_label.set_name ("CPULoad");

	buffer_load_box.add (buffer_load_label);
	buffer_load_box.set_name ("BufferLoad");
	buffer_load_label.set_name ("BufferLoad");

	disk_rate_box.add (disk_rate_label);
	disk_rate_box.set_name ("DiskRate");
	disk_rate_label.set_name ("DiskRate");

	sample_rate_box.add (sample_rate_label);
	sample_rate_box.set_name ("SampleRate");
	sample_rate_label.set_name ("SampleRate");

	menu_hbox.pack_start (menu_bar, true, true);
	menu_hbox.pack_end (wall_clock_box, false, false, 10);
	menu_hbox.pack_end (disk_space_box, false, false, 10);
	menu_hbox.pack_end (cpu_load_box, false, false, 10);
	menu_hbox.pack_end (disk_rate_box, false, false, 10);
	menu_hbox.pack_end (buffer_load_box, false, false, 10);
	menu_hbox.pack_end (sample_rate_box, false, false, 10);

	menu_bar_base.set_name ("MainMenuBar");
	menu_bar_base.add (menu_hbox);
}

