// -*- c++ -*-
//  Generated by gtkmmproc from ./../menuitem.gen_h -- DO NOT MODIFY!
#include <gtk--/menuitem.h>
#include <gtk--/private/menuitem_p.h>
#include <gtk--/label.h>
#include <gtk--/misc.h>
#include <gtk--/menu.h>
#include <gtk--/box.h>
#include <gtk--/window.h>
#include <gtk--/menubar.h>

// gtk_menu_item_(de)select are just a wrapper for gtk_item_(de)select
// and defined in Gtk_Item, so they do not be redefined here

namespace Gtk {
void
MenuItem::accelerate()
  {
    using namespace Menu_Helpers;

    MenuShell* parent=dynamic_cast<MenuShell*>(get_parent());
    Window* window=(Window*)parent->get_data("gtkmm-accel-window");
    AccelGroup* nav_group=parent->get_accel_group();
    AccelGroup* accel_group=(window?window->get_accel_group():0);
    bool in_menubar=Gtk::MenuBar::isA(parent);

    AccelKey accel(accel_key);
    AccelKey nav(nav_key);
    if (accel_group&&accel.key()!=GDK_VoidSymbol)
      {
        add_accelerator("activate_item",*accel_group,
                        accel.key(),accel.mod(),GtkAccelFlags(0));
        if (!in_menubar) show_accel_label();
      }

    if (nav_group&&!in_menubar&&nav.key()!=GDK_VoidSymbol)
      add_accelerator("activate_item",*nav_group,
                      nav.key(), nav.mod(), GtkAccelFlags(0));

    if (window&&has_submenu()) get_submenu()->accelerate(*window);
  }

}

Gtk::MenuItem::MenuItem(const string &label,gfloat x,gfloat y)
  : Item((GtkItem*)(gtk_object_new(get_type(),0)))
{
  initialize_class();
  add_label(label,x,y);
  accel_key=nav_key=GDK_VoidSymbol;
  accel_label_=0;
}

Gtk::MenuItem::MenuItem()
  : Item((GtkItem*)(gtk_object_new(get_type(),0)))
{
  initialize_class();
  accel_key=nav_key=GDK_VoidSymbol;
  accel_label_=0;
}

Gtk::MenuItem::MenuItem(GtkMenuItem *castitem)
  : Item((GtkItem*)(castitem))
{
  initialize_class();
  accel_key=nav_key=GDK_VoidSymbol;
  accel_label_=0;
}

void Gtk::MenuItem::show_accel_label()
{
  if (accel_label_)
    {
      accel_label_->show();
      return;
    }

  if (accel_key==GDK_VoidSymbol) return;

  Widget *contents=get_child();

  if (!contents) return;
  if (!Box::isA(contents))
    {
      SigC::Reference hc(*contents);
      Box *box=manage(new HBox());
      remove();
      add(*box);
      box->pack_start(*contents);
      box->set_spacing(15);
      box->show_all();
      contents=box;
    }

  accel_label_=manage(new Label(Menu_Helpers::AccelKey(accel_key).abrev(),1.0,0.5));
  ((Box*)contents)->pack_end(*accel_label_);
  accel_label_->show();
}

namespace Gtk {
Gtk::MenuItem *wrap (GtkMenuItem *o)
  {
    return static_cast<Gtk::MenuItem *> (Gtk::wrap_auto ((GtkObject *) (o)));
  }
}

namespace Gtk {
MenuItem_Class MenuItem::menu_item_class = {0};

Object* MenuItem_Class::wrap_new(GtkObject* o)
  {
    Object* cpp=manage(new MenuItem((GtkMenuItem*)(o)));
    return cpp;
  }

bool MenuItem::isA( Object *checkcast)
  {
    return GTK_IS_MENU_ITEM(checkcast->gtkobj());
  }

GtkType MenuItem::get_type()
  {
    return menu_item_class.get_type();
  }

GtkType MenuItem_Class::get_type()
  {
    if (!type)
      {
        CppClassParent::CppObjectType::get_type();
        GtkTypeInfo info =
          {
            "Gtk__MenuItem",
            sizeof(BaseObjectType),
            sizeof(BaseClassType),
            (GtkClassInitFunc) class_init_function,
            (GtkObjectInitFunc) object_init_function,
            /* reserved_1 */ NULL,
            /* reserved_2 */ NULL,
            /*base_class_init_func */ (GtkClassInitFunc) NULL
          };
        type=gtk_type_unique(gtk_menu_item_get_type(), &info);
      }
    return type;
  }

const char* const MenuItem::signal_names[]={
   "activate",
   "activate_item",
   0};

void MenuItem::initialize_class()
  {

     menu_item_self=this;

  }

void MenuItem_Class::class_init_function(GtkMenuItemClass *klass)
  {
    CppClassParent::class_init_function((BaseClassParent*)klass);
    klass->activate=activate_callback;
    klass->activate_item=activate_item_callback;
  }

void MenuItem_Class::object_init_function(GtkMenuItem *)
  {}

}

Gtk::MenuItem::~MenuItem() { destroy_(); }

void Gtk::MenuItem::set_submenu(Gtk::Menu& submenu)
  {
    gtk_menu_item_set_submenu(gtkobj(),submenu.Widget::gtkobj());
  }

void Gtk::MenuItem::remove_submenu()
  {
    gtk_menu_item_remove_submenu(gtkobj());
  }

void Gtk::MenuItem::set_placement(GtkSubmenuPlacement placement)
  {
    gtk_menu_item_set_placement(gtkobj(),placement);
  }

void Gtk::MenuItem::configure(gint show_toggle_indicator,gint show_submenu_indicator)
  {
    gtk_menu_item_configure(gtkobj(),show_toggle_indicator,show_submenu_indicator);
  }

void Gtk::MenuItem::right_justify()
  {
    gtk_menu_item_right_justify(gtkobj());
  }

void Gtk::MenuItem_Class::activate_callback(GtkMenuItem* o_)
  {
    CppObjectType *obj=
      static_cast<CppObjectType *>(static_cast<Gtk::Object *>(
        gtk_object_get_data_by_id((GtkObject*)o_,Gtk::quark_)));

    if (obj)
      obj->activate_impl();
    else
      {
        BaseClassType* base=
          static_cast<BaseClassType*>(
            gtk_type_parent_class(((GtkObject*)o_)->klass->type));
        if (base->activate)
          (base->activate)(o_);
      }

  }

void Gtk::MenuItem::activate_impl()
  {
    BaseClassType* base=
      static_cast<BaseClassType*>(
        gtk_type_parent_class(gtkobject->klass->type));
    if (base->activate)
      (base->activate)(gtkobj());

  }

void Gtk::MenuItem_Class::activate_item_callback(GtkMenuItem* o_)
  {
    CppObjectType *obj=
      static_cast<CppObjectType *>(static_cast<Gtk::Object *>(
        gtk_object_get_data_by_id((GtkObject*)o_,Gtk::quark_)));

    if (obj)
      obj->activate_item_impl();
    else
      {
        BaseClassType* base=
          static_cast<BaseClassType*>(
            gtk_type_parent_class(((GtkObject*)o_)->klass->type));
        if (base->activate_item)
          (base->activate_item)(o_);
      }

  }

void Gtk::MenuItem::activate_item_impl()
  {
    BaseClassType* base=
      static_cast<BaseClassType*>(
        gtk_type_parent_class(gtkobject->klass->type));
    if (base->activate_item)
      (base->activate_item)(gtkobj());

  }

Gtk::Menu* Gtk::MenuItem::get_submenu() const
  { return Gtk::wrap((GtkMenu*)(gtkobj()->submenu)); }
