/* 
 * Ardesia -- a program for painting on the screen
 * with this program you can play, draw, learn and teach
 * This program has been written such as a freedom sonet
 * We believe in the freedom and in the freedom of education
 *
 * Copyright (C) 2009 Pilolli Pietro <pilolli@fbk.eu>
 *
 * Ardesia is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Ardesia is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */


#include <background_window_callbacks.h>
#include <background_window.h>
#include <utils.h> 


/* Expose event in background window occurs. */
G_MODULE_EXPORT gboolean
back_event_expose(GtkWidget *widget, 
		  GdkEventExpose *event,
		  gpointer user_data)
{
  BackgroundData *background_data = (BackgroundData *) user_data;

  gint is_fullscreen = gdk_window_get_state (gtk_widget_get_window (widget) ) & GDK_WINDOW_STATE_FULLSCREEN;
  if (!is_fullscreen)
    {
      return TRUE;
    }

  if (!background_data->back_cr)
    {
      background_data->back_cr = gdk_cairo_create (gtk_widget_get_window (widget) );
    }

  if (background_data->background_image)
    {
      set_background_image (background_data->background_image);
    }
  else if (background_data->background_color)
    {
      set_background_color (background_data->background_color);
    }
  else
    {
      clear_background_window ();
    }

  return TRUE;
}


