#include "all.h"

void read_revision_all(char *repo, char *rev, int repo_index, int rev_index);

int read_stats_all(struct stats *, char *, int, int, FILE *);

int init_all(char *repo){

#define init_all_finish(value) {					\
			gstrdel(path);							\
			if (revs != NULL){						\
				for (i = 0; i < rev_count[0]; i++)	\
					if (revs[i] != NULL)			\
						free(revs[i]);				\
				free(revs);							\
			};										\
			return value;							\
		}

    char **revs = NULL;
    char *extension = NULL;
    char *path = NULL;
    int i = 0;

#ifdef ALL_DEBUG
	printf("[Function: init] Received repo path %s;\n", repo);
#endif
	if (gmstrcpy(&path, repo, "/rdiff-backup-data", 0) != 0)
		init_all_finish(-1);
	set_root();
	if ((rev_count = single(int)) == NULL)
		init_all_finish(-1);
    if ((rev_count[0] = unzip_revs(path)) == -1)
    	init_all_finish(-1);
    if ((revs = calloc(rev_count[0], sizeof(char *))) == NULL)
    	init_all_finish(-1);
    if (get_revisions(rev_count[0], revs) == -1)
    	init_all_finish(-1);
    gstrsort(revs, rev_count[0]);
    for (i = rev_count[0] - 1; i >= 0; i--){
    	extension = gpthext(revs[i]);
    	if (strcmp(extension, "snapshot") == 0)
    		snapshot_copy(revs[i]);
    	else // strcmp(extension, "diff") == 0)
    		snapshot_append(revs[i]);
		gstrdel(extension);
		read_revision_all(NULL, revs[i], -1, rev_count[0] - i - 1);
	};
	init_all_finish(0);	
	
};

int init_all_multi(int count, char **repos){

#define init_all_multi_free_revs											\
			if (revs != NULL){												\
				for (k = 0; k < rev_count[i]; k++)							\
					if (revs[k] != NULL)									\
						free(revs[k]);										\
				free(revs);													\
				gmstrcpy(&snapshot, tmp_file, "/", CURRENT_SNAPSHOT, 0);	\
				unlink(snapshot);											\
				gstrdel(snapshot);											\
			}

#define init_all_multi_finish(value) {							\
			gstrdel(repo_dir);									\
			init_all_multi_free_revs;							\
			return value;										\
		}

    int i = 0;
    int j = 0;
    int k = 0;
    char **revs = NULL;
    char *repo_dir = NULL;
	char *extension = NULL;
	char *snapshot = NULL;

#ifdef ALL_DEBUG
    printf("[Function: init_multi] Received %d repos;\n", count);
#endif
	set_root();
	if ((rev_count = calloc(repo_count, sizeof(int))) == NULL)
		init_all_multi_finish(-1);
    for (i = 0; i < repo_count; i++){
		if (gmstrcpy(&repo_dir, repos[i], "/rdiff-backup-data", NULL) == -1)
			continue;
		if ((rev_count[i] = unzip_revs(repo_dir)) == -1)
			continue;
		if ((revs = calloc(rev_count[i], sizeof(char *))) == NULL)
			continue;
		if (get_revisions(rev_count[i], revs) == -1){
			init_all_multi_free_revs;
			continue;
		};
		if (add_repo_dir(repo_names[i], i) == -1){
			init_all_multi_free_revs;
			continue;
		};
		for (j = rev_count[i] - 1; j >= 0; j--){
			extension = gpthext(revs[j]);
			if (strcmp(extension, "snapshot") == 0)
    			snapshot_copy(revs[j]);
    		else // strcmp(extension, "diff") == 0)
    			snapshot_append(revs[j]);
		    gstrdel(extension);
		    read_revision_all(repo_names[i], revs[j], i, rev_count[i] - j - 1);
		};
		init_all_multi_free_revs;
    };
    
    return 0;

};

void read_revision_all(char *repo, char *rev, int repo_index, int rev_index){

#define read_revision_error {						\
	    gstrdel(file);									\
	    gstrdel(rev_dir);								\
	    if (file != NULL)								\
	    	fclose(file);								\
	    return;										\
	}
	
#ifdef ALL_DEBUG
	printf("[Function: read_repo_revision] Received repo %s and revision %s;\n", repo, rev);
#endif
    char *rev_dir = NULL;
    char *file_path = NULL;
    FILE *file = NULL;
    struct stats *stats = calloc(1, sizeof(struct stats));

	if (repo == NULL){
		if (gmstrcpy(&rev_dir, "/", get_revs_dir(rev), 0) != 0)
			read_revision_error;
	}
	else{ // repo != NULL
    	if (gmstrcpy(&rev_dir, "/", repo, "/", get_revs_dir(rev), 0) != 0)
			read_revision_error;
	};
    if (gmstrcpy(&file_path, tmp_file, "/", CURRENT_SNAPSHOT, 0) != 0)
		read_revision_error;
    if ((file = fopen(file_path, "r")) == NULL)
		read_revision_error;
    add_revs_dir(rev, repo);

    while (read_stats_all(stats, rev_dir, repo_index, rev_index, file) == 0){
    	if (stats->type == -1)
    		delete(stats->path);
    	else
			add_file(stats);
	};

    fclose(file);
    gmstrcpy(&file_path, tmp_file, "/", rev, 0);
    unlink(file_path);
    gstrdel(file_path);
    gstrdel(rev_dir);
    free(stats);
    
};

int read_stats_all(struct stats *stats, char *prefix, int repo, int rev, FILE *file){

	if (read_stats(stats, file) != 0)
		return -1;
	if (gmstrcpy(&stats->path, prefix, "/", stats->internal, 0) == -1)
		return -1;
	gstrdel(stats->internal);
	if (gpthcldptr(&stats->name, stats->path) == -1)
		return -1;
	if (stats->type == S_IFDIR)
		stats->size = DIR_SIZE;
    stats->internal = stats->path + strlen(prefix) + strlen("/");
    stats->repo = repo;
    stats->rev = rev;
#ifdef ALL_DEBUG_DEEP
	printf("[Function: read_stats_all] Read data of file %s\n", stats->path);
#endif
    return 0;
   
};
