#include "initialize.h"

// private:

void check_mount(){
    
    if (gpthpro(&mount) != 0)
    	fail(ERR_NO_MOUNT);
            
};

void check_repo(int index){

    char *rdiff_backup_dir = NULL;

#ifdef DEBUG
	printf("[Function: check_repo] Checking repo %s;\n", repos[index]);
#endif
	if (gmstrcpy(&rdiff_backup_dir, repos[index], "/rdiff-backup-data", 0) == -1)
		fail(-1);
	if (gpthpro(&rdiff_backup_dir) != 0)
		fail(ERR_NO_REPO);
	gstrdel(rdiff_backup_dir);
	if (gpthpro(&repos[index]) != 0)
		fail(ERR_NO_REPO);
#ifdef DEBUG
	printf("[Function: check_repo] Setting repo to %s;\n", repos[index]);
#endif
	
};

void check_repos(){
    
    int i = 0;
    
    repo_names = calloc(repo_count, sizeof(char *));
    for (i = 0; i < repo_count; i++)
		if (gpthcld(&repo_names[i], repos[i]) == -1)	
			fail(-1);
    for (i = 0; i < repo_count; i++)
		check_repo(i);
    
};

void data_structure_setup(){

    if (structure == DATA_STRUCT_SIMPLE){
    	init = &init_all;
    	init_multi = &init_all_multi;
    	set_root = &simple_set_root;
		add_file = &simple_add_file;
		get_children = &simple_get_children;
		get_file = &simple_get_file;
		delete = &simple_delete;
    }
    else if (structure == DATA_STRUCT_TREE){
    	init = &init_all;
    	init_multi = &init_all_multi;
    	set_root = &tree_set_root;
		add_file = &tree_add_file;
		get_children = &tree_get_children;
		get_file = &tree_get_file;
		delete = &tree_delete;
    }
    else if (structure == DATA_STRUCT_VERSIONS){
    	init =  &init_versions;
    	init_multi = &init_versions_multi;
    	set_root = &tree_set_root;
    	add_file = &tree_add_file;
    	get_children = &tree_get_children;
    	get_file = &tree_get_file;
    	delete = &tree_delete;
    };

    if (repo_count == 1)
		init(repos[0]);
    else if (repo_count > 1)
		init_multi(repo_count, repos);
    else
		fail(ERR_NO_REPO);

};

void fuse_operations_setup(){

	operations.getattr 	= &revs_getattr;
	operations.readdir 	= &revs_readdir;
	operations.readlink = &archfs_readlink;
	operations.open	   	= &revs_open;
	operations.read    	= &revs_read;
	operations.release 	= &revs_release;
	operations.destroy 	= &revs_destroy;

};

void create_tmp_dir(char **tmp_dir, char **tmp_file){
    
    if (*tmp_dir == NULL)
    	if (gstrcpy(tmp_dir, DEFAULT_TMP_DIR) == -1)
    		fail(-1);
    if (gpthpro(tmp_dir) != 0)
    	fail(ERR_NO_TMP);
    int length = strlen(*tmp_dir) + strlen("/archfs-XXXXXX");
    char tmp_template[length + 1];

    strcpy(tmp_template, *tmp_dir);
   	strcpy(tmp_template + strlen(*tmp_dir), "/archfs-XXXXXX");
    if (mkdtemp(tmp_template) == NULL)
		fail(-1);
    if (((*tmp_file) = gstralloc(length)) == NULL)
    	fail(-1);
    strcpy((*tmp_file), tmp_template);
#ifdef DEBUG
    printf("[Function: create_tmp_dir] Created directory %s;\n", *tmp_file);
#endif
        
};

// public:

void initialize(){

    check_mount();
    check_repos();
   	create_tmp_dir(&tmp_dir, &tmp_file);

    data_structure_setup();
    fuse_operations_setup();
    if (cache_limit == 0)
   		retriever_init_simple(repo_count, rev_count);
   	else
   		retriever_init_limit(repo_count, rev_count);
   	
};
