#!/usr/bin/env python
# -*- coding: utf-8 -*-
# restore.py
#  
#  Author: Laudeci Oliveira <laudeci@gmail.com>
#          Rafael Proença   <cypherbios@ubuntu.com>
# 
#  This program is free software; you can redistribute it and/or 
#  modify it under the terms of the GNU General Public License as 
#  published by the Free Software Foundation; either version 2 of the
#  License, or (at your option) any later version.
# 
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
# 
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
#  USA

from messageBox import MessageBox
import ProgressWindow
import apt_inst
import apt_pkg
import config
import gnomevfs
import gobject
import gtk
import gtk.glade
import metaPackage
import os
import pango
import pygtk
import shutil
import utils
import msg

class restoreAptOnCd:
    
    def __init__(self, gladeFileName,mediaPath=""):
        self.formName = "frmRestoreCD"
        self.gladeFile = gtk.glade.XML(gladeFileName, self.formName)
        self.cursorManager = utils.cursorManager()
        self.mediaPath = mediaPath
        self.checkOldVersions = False
        
    def run(self):
        """This function will show the Create frmRestoreCD"""
        #Get the  dialog widget
        self.frmRestoreCD = self.gladeFile.get_widget(self.formName)
        self.frmRestoreCD.set_position(gtk.WIN_POS_CENTER)
        self.frmRestoreCD.set_modal(True)
        self.frmRestoreCD.set_sensitive(False)
        
        # ---- dictionary ----
        dic = { 'on_btnRestoreGo_clicked':self.on_btnRestoreGo_clicked }
        self.gladeFile.signal_autoconnect(dic)
        
        #Holds a Variable to use with progressWindos
        self.wProgress = None
        
        self.cmdRestoreGo = self.gladeFile.get_widget("btnRestoreGo")
        self.cmdCancel = self.gladeFile.get_widget("btnCancel")
        self.ckbtnOldVersions = self.gladeFile.get_widget("ckbtnOldVersions")
        self.ckbtnOldVersions.connect('toggled',self.on_ckbtnOldVersions_toggled)
        
        self.ckbtnAutoSelectDepends = self.gladeFile.get_widget('ckbtnAutoSelectDepends')

        self.comboBox = self.gladeFile.get_widget('drivesComboBox')
        
        ret = metaPackage.updatePackageCount(None,False)
        self.updateCountView(ret)
        
        self.createPackageViewList()
        ret = metaPackage.updatePackageCount(self.packageList)
        self.updateCountView(ret)
        
        self.frmRestoreCD.set_sensitive(True)
        result = self.frmRestoreCD.run()

        #we are done with the dialog, destory it
        self.frmRestoreCD.destroy()

        #return the result
        return     result
        
    def createDebFileList(self):
        #fileNames = [nFile for nFile in os.listdir(self.mediaPath) if nFile.endswith(".deb")]
        recursive = utils.RecursiveSearch
        fileNames = [nFile for nFile in recursive(self.mediaPath, "*.deb")]
        mLen = len(fileNames)
        self.wProgress.TaskLenght(mLen)
        for iIndex in range(mLen):
            #if '.deb' in fileName:
            self.wProgress.update(iIndex)
            iList = metaPackage.createNewItem(fileNames[iIndex],False, self.mediaPath)
            metaPackage.addNewListItem(self.packageList,iList)
        self.wProgress.Task(msg.MESSAGE_0045)
        metaPackage.uncheckMinorVersion(self.packageList)        
        ret = metaPackage.updatePackageCount(self.packageList)
        self.updateCountView(ret)
        if metaPackage.get_ErrorCount() > 0:
            if metaPackage.get_ErrorCount() >1:
                strMsg = msg.MESSAGE_0032 % metaPackage.get_ErrorCount()
            else:
                strMsg = msg.MESSAGE_0033 % metaPackage.get_ErrorCount()
                
            mReturn = MessageBox().ShowError(strMsg,self.frmRestoreCD)
        return
    
    def addListColumn(self, title, columnId, activatable = False):
        """This function adds a column to the list view.
        First it create the gtk.TreeViewColumn and then set
        some needed properties"""
        if activatable:
            cell = gtk.CellRendererToggle()
            cell.set_property('activatable', activatable)
            cell.connect('toggled',self.on_Column_toggled, self.packageList)
            column = gtk.TreeViewColumn(title, cell)
            column.add_attribute( cell, "active", 0)
        else :
            cell = gtk.CellRendererText()
            column = gtk.TreeViewColumn(title, cell, markup=config.LIST_CONTENTS)

        column.set_resizable(True)
        column.set_sort_column_id(columnId)
        self.packageView.append_column(column)
        
        return
    
    def createPackageViewList(self):
        #Get the listView from the widget Tree
        self.packageView = self.gladeFile.get_widget("tvwPackages")
        self.packageView.connect('row-activated',self.on_double_Click)
        self.cursorManager.setBusy(self.frmRestoreCD,True)
        self.packageView.set_sensitive(False)
        
        self.wProgress = ProgressWindow.AptOnCDProgressDialog(self.frmRestoreCD)
        self.wProgress.Title("APTonCD")
        self.wProgress.TaskTitle(msg.MESSAGE_0034)
        self.wProgress.Task(msg.MESSAGE_0002)
        self.wProgress.Description(msg.MESSAGE_0035)
        
        self.cursorManager.setBusy(self.wProgress,True)
        self.wProgress.isCancelEnabled(False)

        # filename, fullfilename with path, and a bool value
        # indicating if it is a custom deb file
        # stores deb information

        #changed to add the last param.. to show deb description
        self.packageList = gtk.ListStore(bool, str, bool, object, bool,bool)
        
        self.addListColumn('   ', 0,True)
        self.addListColumn('Package',1,False)
        
        #this will create a tooltip object    
        self.toolTip = gtk.Tooltips() 
        self.toolTip.set_tip(self.packageView, "")

        # this will turn searchable on
        self.packageView.set_enable_search(True)
        self.packageView.set_search_column(1)
        self.packageView.set_search_equal_func(utils.TreeViewSearch, None)

        # prepares list for drag and drop operations
        self.packageView.enable_model_drag_dest([('text/plain', 0, 0), ('text/uri-list', 0, 1)],
                        gtk.gdk.ACTION_DEFAULT | gtk.gdk.ACTION_MOVE)
        #packages events to show tooltips
        self.packageView.connect("motion-notify-event", utils.packageTooltip, self.toolTip, 1)
        
        # this will start the list sorted by name
        self.packageList.set_sort_column_id(1, gtk.SORT_ASCENDING)
        
        self.createDebFileList()
        # this will create the main list and store it in the view
        self.packageView.set_model(self.packageList)
        
        self.wProgress.destroy()
        
        self.packageView.connect("button_press_event", self.on_button_press_event)
        self.packageView.set_sensitive(True)
        self.cursorManager.setBusy(self.frmRestoreCD,False)
        return
    
    def updateCountView(self,value):
        self.gladeFile.get_widget("lblPackageList").set_text(value[0])
        self.gladeFile.get_widget("lblSelected").set_text(value[2])
        
    # Signals Handlers
    def on_double_Click(self, treeview, path, view_column):
        renderer = treeview.get_column(0).get_cell_renderers()[0]
        renderer.emit('toggled',path[0])
                
    def on_ckbtnOldVersions_toggled(self,widget):
        self.checkOldVersions = self.ckbtnOldVersions.get_active()
        

    def on_button_press_event(self, widget, event):
        if event.button == 3 and event.type == gtk.gdk.BUTTON_PRESS:
            c = utils.ContextMenu(self)
            c.addMenuItem(msg.MESSAGE_0036, self.on_checkAll)
            c.addMenuItem(msg.MESSAGE_0037, self.on_uncheckAll)
            c.addMenuItem("-")
            c.addMenuItem(msg.MESSAGE_0038, self.on_removePackage)
            c.addMenuItem("-")
            c.addMenuItem(msg.MESSAGE_0039, self.on_invertcheckAll)
            c.popup(None, None, None, event.button, event.get_time())
        return
    
    def checkUncheck(self,iType,path = None, model = None):
        self.cursorManager.setBusy(self.frmRestoreCD,True)
        
        if iType == 0:
            metaPackage.removePackage(self.packageView)
        elif iType == 1:
            metaPackage.checkAll(self.packageList,self.checkOldVersions)
        elif iType == 2:
            metaPackage.uncheckAll(self.packageList)
        elif iType == 3:
            metaPackage.invertcheckAll(self.packageList,self.checkOldVersions)
        elif iType == 4:
            metaPackage.Column_toggled(path,model,self.checkOldVersions)
            # if user wants, aptoncd will check dependets packages 
            if self.ckbtnAutoSelectDepends.get_active():
                if model[path][config.C_CHECKED]:
                    metaPackage.checkDepends(self.packageList,model[path][config.C_PKG].get_pkg_depends())
            
        ret =metaPackage.updatePackageCount(self.packageList)    
        self.updateCountView(ret)
        self.cursorManager.setBusy(self.frmRestoreCD,False)
    
    def on_removePackage(self, *args):
        self.checkUncheck(0)
        return
    
    def on_checkAll(self,*args):
        self.checkUncheck(1)
        return
    
    def on_uncheckAll(self,*args):
        self.checkUncheck(2)
        return
    
    def on_invertcheckAll(self,*args):
        self.checkUncheck(3)
        return
    
    def on_Column_toggled(self, cell, path, model):
        self.checkUncheck(4, path, model)
        cell.set_active(False)
        return
    
    def addMediaAsSource(self,*args):
    	os.system("gksu --desktop /usr/share/applications/aptoncd.desktop 'synaptic --hide-main-window --ask-cdrom' &")
       
    # Restore APTonCD
    def on_btnRestoreGo_clicked(self,*args):
        self.cmdRestoreGo.set_sensitive(False)
        self.cmdCancel.set_sensitive(False)

	aptcache = config.LOCAL_APT_FOLDER
        if not utils.checkAccess(aptcache):
        	MessageBox().ShowError((msg.MESSAGE_0040))
        	return
        
        self.wProgress = ProgressWindow.AptOnCDProgressDialog(self.frmRestoreCD)
        self.wProgress.Title("APTonCD")
        self.wProgress.TaskTitle(msg.MESSAGE_0041)
        self.wProgress.Task(msg.MESSAGE_0002)
        self.wProgress.Description(msg.MESSAGE_0014)
        self.restoreAptOnCD()
        
        self.wProgress.destroy()
        
        self.cmdRestoreGo.set_sensitive(True)
        self.cmdCancel.set_sensitive(True)
        
    def restoreAptOnCD(self):
        errorMsg=""
        
        self.wProgress.show()
        
        iIndex = 0
       
        filesToCopy = [files for files in self.packageList if files[config.C_CHECKED]]
        self.wProgress.TaskLenght(len(filesToCopy)-1)
        
        for cds in filesToCopy:                    
            iIndex +=1
            self.wProgress.update(iIndex)
            
            pkg = cds[config.C_PKG]
            filedestination = os.path.join(config.LOCAL_APT_FOLDER  , pkg.get_pkg_FileName())
            
            if self.wProgress.cancel_status:
                errorMsg = msg.MESSAGE_0016
                break
                    
            pkg.copyTo(filedestination )
            self.wProgress.Task(msg.MESSAGE_0044 + pkg.get_pkg_FileName())
                
            
        if self.wProgress.cancel_status or len(errorMsg)>0:
            self.wProgress.hide()
        
        if len(errorMsg) > 0 :
            strMsg = msg.MESSAGE_0042
            mReturn = MessageBox().ShowInfo(strMsg,self.frmRestoreCD)
        else :
            mReturn = MessageBox().ShowInfo((msg.MESSAGE_0043))
