# -*- coding: utf-8 -*-
###########################################
#  Rafael Proena <cypherbios@ubuntu.com>
#  Laudeci Oliveira <laudeci@gmail.com>
#
#  Copyright 2006 APTonCD DevTeam.
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published
#  by the Free Software Foundation; version 2 only.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
###########################################

import gtk
from APTonCD.core import constants
from gtk import glade

_busy_count = -1

def set_parent_widget_from_glade(glade, itemname, reparent_to_widget):
	item = get_widget(glade, itemname)
	item = item.get_child()
	item.reparent(reparent_to_widget)
	return item
			
def popup_emoticons_under_button(menu, button, parent_win):
    """ pops emoticons menu under button, which is in parent_win
        taken from gajim gtkgui_helpers.py
    """
    window_x1, window_y1 = parent_win.get_origin()
    def position_menu_under_button(menu):
        # inline function, which will not keep refs, when used as CB
        button_x, button_y = button.allocation.x , button.allocation.y 

        # now convert them to X11-relative
        window_x, window_y = window_x1, window_y1
        x = window_x + (button_x + 10)
        y = window_y + (button_y - 10)

        menu_width, menu_height = menu.size_request()

        ## should we pop down or up?
        if (y + button.allocation.height + menu_height < gtk.gdk.screen_height()):
            # now move the menu below the button
            y += button.allocation.height
        else:
            # now move the menu above the button
            y -= menu_height

        # push_in is True so all the menuitems are always inside screen
        push_in = True
        return (x, y, push_in)

    menu.popup(None, None, position_menu_under_button, 1, 0)

def get_top_parent(widget):
	"""
		Return the ultimate parent of a widget; the assumption that code
		using this makes is that it will be a gtk.Window, i.e. the widget
		is fully packed when this is called.
	"""
	return widget and widget.get_ancestor(gtk.Window)


def get_children(widget, type):
	"""
		This will get a child widget from a top widget.
		
		Ex. gtk.Radiobutton has a Label as child widget.
		so you can set that Label's properties if you get it.
	"""
	result = None
	try:
		
		for n in widget.get_children():
			if isinstance(n,type):
				result = n
				break
	except Exception, e:
		print str(e)
	
	return result
	
def get_top_window(widget):
    """
        Returns the top window where an widget is contained.
    """
    return widget.get_parent_window()

def setCursorToBusy(root = None, wait_cursor = False):
	"""
		Set a busy cursor and refreshes the window.
	"""
	global _busy_count
	
	if root:
		main_window = get_top_window(root)
		if isinstance(main_window, gtk.gdk.Window):
			if wait_cursor:
				_busy_count +=1
				if _busy_count <= 1:
					main_window.set_cursor(gtk.gdk.Cursor(gtk.gdk.WATCH))
					processEvents()
			else:
				_busy_count -=1
				if _busy_count <1:
					main_window.set_cursor(gtk.gdk.Cursor(gtk.gdk.LEFT_PTR))
					_busy_count =0

def setCursorToNormal(root = None, wait_cursor = False):
    """
        Returns a cursor states to default cursor..
    """
    setCursorToBusy(root, wait_cursor)

def processEvents():
    """
        Proccess all wainting events like drawing window.
    """
    gtk.gdk.flush()
    while gtk.events_pending():
        gtk.main_iteration(False)
        
def get_glade(glade_file, domain_name):
    """
        Returns a reference for a glade object.
    """
    return glade.XML(glade_file, domain_name)

def get_widget(glade_file, widget_name):
    """
        Reeturns a reference for a widget in a glade.
    """
    return glade_file.get_widget(widget_name)

def connect(widget, event_name, function_callback, *args):
    """
        Connect widgets signals to callback functions
    """
    return widget.connect(event_name, function_callback, *args)

def message(text = '', parentWindow= None):
    """
    """
    dlg = gtk.MessageDialog(parentWindow, gtk.DIALOG_MODAL, gtk.MESSAGE_INFO, gtk.BUTTONS_OK, text)
    dlg.set_markup(text)
    dlg.run()
    dlg.destroy()
    return
  
def erro_message(text = '', parentWindow= None):
    dlg= gtk.MessageDialog(parentWindow, gtk.DIALOG_MODAL,  gtk.MESSAGE_ERROR, gtk.BUTTONS_OK, text)
    dlg.set_title(constants.MESSAGE_0006)
    dlg.set_markup(text)
    if parentWindow:
        try:
            dlg.set_icon(parentWindow.get_icon())
        except Exception, e:
            print 'Erro:\n',str(e)
            pass
    dlg.run()
    dlg.destroy()
    return

def warn_message(text = '', parentWindow= None):
    dlg= gtk.MessageDialog(parentWindow, gtk.DIALOG_MODAL,  gtk.MESSAGE_WARNING, gtk.BUTTONS_OK, text)
    dlg.set_title(constants.MESSAGE_0063)
    dlg.set_markup(text)
    if parentWindow:
        try:
            dlg.set_icon(parentWindow.get_icon())
        except Exception, e:
            print 'Erro:\n',str(e)
            pass
    dlg.run()
    dlg.destroy()
    return
    
def question_message_cancel(text, parentWindow= None):
    dlg = gtk.MessageDialog (parentWindow, gtk.DIALOG_MODAL, gtk.MESSAGE_WARNING, gtk.BUTTONS_OK_CANCEL, text)
    dlg.set_markup(text)
    response = dlg.run ()
    dlg.destroy ()
    
    return (response == gtk.RESPONSE_OK)
    
def question_message(text, parentWindow= None):
    dlg = gtk.MessageDialog (parentWindow, gtk.DIALOG_MODAL, gtk.MESSAGE_QUESTION, gtk.BUTTONS_YES_NO, text)
    dlg.set_markup(text)
    response = dlg.run ()
    dlg.destroy ()
    
    return (response == gtk.RESPONSE_YES)
