# apt-transport-s3

### Table of Contents
1. [License & Copyright](#license & copyright)
2. [Requirements](#requirements)
3. [Configuration](#configuration)
3. [Usage](#usage)

## apt-transport-s3
Allow to have a privately hosted apt repository on S3. Access keys are read from
`/etc/apt/s3auth.conf` file or IAM role if machine is hosted on AWS or has
access to AWS metadata server on 169.254.169.254.

## License & Copyright
    # Copyright (C) 2014 Bashton Ltd.
    #
    # This program is free software; you can redistribute it and/or modify
    # it under the terms of the GNU General Public License as published by
    # the Free Software Foundation; either version 2 of the License, or
    # (at your option) any later version.

    # This program is distributed in the hope that it will be useful,
    # but WITHOUT ANY WARRANTY; without even the implied warranty of
    # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    # GNU General Public License for more details.

    # You should have received a copy of the GNU General Public License
    # along with this program; if not, write to the Free Software
    # Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.


## Requirements
### Additional package dependencies (except installed by default in Debian)
1. python-configobj

## Configuration
/etc/apt/s3auth.conf or <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-roles-for-amazon-ec2.html">IAM role</a>
can provide credentials required for using private apt repositories.

Example of s3auth.conf file:
```
AccessKeyId = myaccesskey
SecretAccessKey = mysecretaccesskey
Token = ''
```

Token should be empty string.

## Usage
Install the .deb package from the releases page.  The bucket repo should be
specified using an s3:// prefix, for example:

`deb s3://aptbucketname.s3.amazonaws.com/repo/ trusty main contrib non-free`
