#! /usr/bin/perl
# This is a library file for Apt-cacher to allow code
# common to Apt-cacher itself plus its supporting scripts
# (apt-cacher-report.pl and apt-cacher-cleanup.pl) to be
# maintained in one location.

# This function reads the given config file into the
# given hash ref. The key and value are separated by
# a '=' and will have all the leading and trailing 
# spaces removed.
sub read_config
{
	# set the default config variables
	my $config = {
			cache_dir => '/var/log/cache/apt-cacher',
			logdir => '/var/log/apt-cacher',
			admin_email => 'root@localhost',
			generate_reports => 0,
			expire_hours => 36,
			http_proxy => 'proxy.example.com:8080',
			use_proxy => 0,
			debug => 0,
			clean_cache => 0,
	};

	($config_file) = @_;

	open CONFIG, $config_file or die $!;

	while (<CONFIG>)
	{
		s/#.*$//;	# kill off comments
		s/^\s+//;	# kill off leading spaces
		s/\s+$//;	# kill off trailing spaces
		if ($_)
		{
			my ($key, $value) = split(/\s*=\s*/);	# split into key and value pair
			$value = 0 unless ($value);
			#print "key: $key, value: $value\n";
			$config->{$key} = $value;
			#print "$config{$key}\n";
		}
	}

	close CONFIG;

	return $config;
}

# Convert an IP address to an IP number (integer)
sub ip2int
{
        $ipaddress = $_[0];
        my @parts = split /\./, $ipaddress;
        $ipint = $parts[3] + ($parts[2] * 256) + ($parts[1] * 256 * 256) + ($parts[0] * 256 * 256 * 256);
        return ($ipint);
}

1;
