/*
 * mirror.cpp
 *
 *  Created on: 25.11.2010
 *      Author: ed
 */


#define LOCAL_DEBUG
#include "debug.h"

#include "mirror.h"
#include "header.h"
#include "dirwalk.h"
#include "meta.h"
#include "acfg.h"

#include <fnmatch.h>

pkgmirror::pkgmirror(int fd): tCacheMan(fd),
m_bCalcSize(false), m_bSkipIxUpdate(false), m_bDoDownload(false),
m_totalneed(0)
{
	m_sTypeName="Mirroring";
}

pkgmirror::~pkgmirror()
{
}

bool pkgmirror::ProcessRegular(const string &sPath, const struct stat &stinfo)
{
	if (endsWithSzAr(sPath, ".head"))
		return true;

	if (sPath.size() <= CACHE_BASE_LEN) // heh?
		return false;

	if (0 == sPath.compare(CACHE_BASE_LEN, 1, "_"))
		return true; // not for us, also includes _import

	AddIFileCandidate(sPath.substr(CACHE_BASE_LEN));

	return ! CheckAbortCondition();
}

tStrDeq GetVariants(cmstring &mine)
{
	tStrDeq ret;
	string base;
	for(cmstring *p=suxeWempty; p<suxeWempty+_countof(suxeWempty); p++)
	{
		if(endsWith(mine, *p))
		{
			base=mine.substr(0, mine.size()-p->size());
			break;
		}
	}
	for(cmstring *p=suxeWempty; p<suxeWempty+_countof(suxeWempty); p++)
	{
		string cand=base+*p;
		if(cand!=mine)
			ret.push_back(cand);
	}
	return ret;
}

void pkgmirror::Action(const string &cmd)
{
	SendChunk("<b>Locating index files, scanning...</b><br>\n");

	SetCommonUserFlags(cmd);
	m_bErrAbort=false; // does not f...ing matter, do what we can

	m_bCalcSize=(cmd.find("calcSize=cs")!=stmiss);
	m_bDoDownload=(cmd.find("doDownload=dd")!=stmiss);
	m_bSkipIxUpdate=(cmd.find("skipIxUp=si")!=stmiss);

	DirectoryWalk(acfg::cachedir, this);

	if(CheckAbortCondition())
		return;

	if(m_indexFilesRel.empty())
	{
		SendChunk("<font size=0 color=red>No index files detected. Unable to continue, cannot map files to internal locations.</font>");
		return;
	}

	if(CheckAbortCondition())
		return;

	if(!m_bSkipIxUpdate)
		UpdateIndexFiles();


	if(CheckAbortCondition())
		return;

	tStrSet srcs;
	class __srcpicker : public ifileprocessor
	{
	public:
		tStrSet *pSrcs;
		tStrVec matchList;
		__srcpicker(tStrSet *x) : pSrcs(x)
		{
			Tokenize(acfg::mirrorsrcs, SPACECHARS, matchList);
		};
		void TryAdd(cmstring &s)
		{
			for(tStrVecIterConst it=matchList.begin(); it!=matchList.end(); it++)
				if(0==fnmatch(it->c_str(), s.c_str(), FNM_PATHNAME))
				{
					pSrcs->insert(s);
					break;
				}
		}
		void HandlePkgEntry(const tRemoteFileInfo &entry, bool)
		{
			TryAdd(entry.sDirectory+entry.sFileName);
		}
	} picker(&srcs);

	mstring sErr;

	for(tS2IDX::iterator it=m_indexFilesRel.begin(); it!=m_indexFilesRel.end();it++)
	{
		if(endsWithSzAr(it->first, "Release"))
		{
			if(!GetFlags(it->first).uptodate)
				if(!DownloadIdxFile(it->first, sErr))
					SendFmt() << "<font color=\"red\">" << sErr << "</font><br>\n";
			ParseAndProcessIndexFile(picker, it->first, EIDX_RELEASE);
		}
		else
			picker.TryAdd(it->first);
	}

	SendChunk("<b>Identifying relevant index files...</b><br>");

	// unless found in release files, get the from the local system
	for (tStrVecIterConst it = picker.matchList.begin(); it != picker.matchList.end(); it++)
	{
		tStrDeq paths(ExpandFilePattern(CACHE_BASE+it->c_str(), false));
		for(tStrDeq::iterator j=paths.begin(); j!=paths.end(); j++)
			picker.TryAdd(*j);
	}

	restart_clean: // start over if the set changed while having a hot iterator
	for(tStrSet::iterator it=srcs.begin(); it!=srcs.end(); it++)
	{
		if(GetFlags(*it).uptodate) // this is the one
		{
		tStrDeq bros(GetVariants(*it));
		int nDeleted=0;
		for(tStrDeq::iterator b=bros.begin(); b!=bros.end(); b++)
			nDeleted+=srcs.erase(*b);
		if(nDeleted)
			goto restart_clean;
		}
	}

	// now there may still be something like Sources and Sources.bz2 if they
	// were added by Release file scan. Choose the prefered simply by extension.

	restart_clean2: // start over if the set changed while having a hot iterator
	for (const string *p = suxeByCompSize; p < suxeByCompSize
	+ _countof(suxeByCompSize); p++)
	{
		for (tStrSet::iterator it = srcs.begin(); it != srcs.end(); it++)
		{
			if(endsWith(*it, *p))
			{
				tStrDeq bros(GetVariants(*it));
			int nDeleted=0;
			for(tStrDeq::iterator b=bros.begin(); b!=bros.end(); b++)
				nDeleted+=srcs.erase(*b);
			if(nDeleted)
				goto restart_clean2;
			}
		}
	}

	for (tStrSet::iterator it=srcs.begin(); it!=srcs.end(); it++)
	{
		SendFmt() << "File list: " << *it<< "<br>";
		if(!GetFlags(*it).uptodate)
			DownloadIdxFile(*it, sErr);

		if(CheckAbortCondition())
			return;
	}

	off_t total=0;

	if (m_bCalcSize)
	{

		SendChunk("<b>Counting downloadable content size...</b><br>");
		for (tStrSet::iterator it = srcs.begin(); it != srcs.end(); it++)
		{
			class __cnt: public ifileprocessor
			{
			public:
				__cnt() :
					sum(0), have(0)
				{
				}
				;
				off_t sum, have;
				void HandlePkgEntry(const tRemoteFileInfo &entry, bool)
				{
					sum += entry.fpr.size;
					have += GetFileSize(CACHE_BASE + entry.sDirectory + entry.sFileName, 0);
					//off_t have=GetFileSize(CACHE_BASE+entry.sDirectory+entry.sFileName, 0);
					//sum+=(entry.fpr.size-have);
				}
			} counter;

			ParseAndProcessIndexFile(counter, *it, GuessIndexType(*it));

			SendFmt() << *it << ": " << offttosH(counter.sum - counter.have) << "/" << offttosH(
					counter.sum) << "<br>\n";
			total += counter.sum;
			m_totalneed += (counter.sum - counter.have);

			if(CheckAbortCondition())
				return;
		}
		SendFmt() << "Total size: " << offttosH(total) << ", missing: up to "
				<< offttosH(m_totalneed) << "<br>\n";
	}

	if(m_bDoDownload && (m_totalneed>0 || !m_bCalcSize))
	{
		SendChunk("<b>Starting download...</b><br>");

		for (tStrSet::iterator it=srcs.begin(); it!=srcs.end(); it++)
		{
			if(CheckAbortCondition())
				return;

			ParseAndProcessIndexFile(*this, *it, GuessIndexType(*it));
		}
	}

}

void pkgmirror::UpdateFingerprint(const mstring &sPathRel, off_t nOverrideSize,
			uint8_t *pOverrideSha1, uint8_t *pOverrideMd5)
{

}

void pkgmirror::HandlePkgEntry(const tRemoteFileInfo &entry, bool bUncompressForChecksum)
{
	off_t davor(0);
	if(m_bVerbose)
		davor=GetFileSize(CACHE_BASE + entry.sDirectory + entry.sFileName, 0);

	DownloadSimple(entry.sDirectory+entry.sFileName);

	if(m_bVerbose)
	{
		off_t diff=(GetFileSize(CACHE_BASE + entry.sDirectory + entry.sFileName, 0)-davor);
		if(m_totalneed && diff)
		{
			m_totalneed-=diff;
			SendFmt() << "Remaining download size: " << offttosH(m_totalneed)<< "<br>\n";
		}
	}
}
