/*
 * tcpconnect.h
 *
 *  Created on: 27.02.2010
 *      Author: ed
 */

#ifndef TCPCONNECT_H_
#define TCPCONNECT_H_

class tcpconnect;
typedef SHARED_PTR<tcpconnect> tTcpHandlePtr;

class tcpconnect
{
public:
	virtual ~tcpconnect();

	static SHARED_PTR<tcpconnect> CreateConnected(cmstring &sHostname, cmstring &sPort,
			mstring &sErrOut,
			bool *pbSecondHand=NULL, acfg::tRepoData::IHookHandler *pStateTracker=NULL);
	/// Moves the connection handle to the reserve pool (resets the specified sptr).
	/// Shold only be supplied with IDLE connection handles in a sane state.
	static void RecycleIdleConnection(tTcpHandlePtr & handle);
	static time_t ExpireCache();

	bool Connect(cmstring &sHostname, cmstring &sPort, mstring &sErrOut);
	inline int GetFD() { return m_conFd; }
	inline cmstring & GetHostname() { return m_sHostName; }
	inline cmstring & GetPort() { return m_sPort; }
	const tHttpUrl * GetProxyData() const { return m_proxy; }
	void Disconnect();

protected:
	tcpconnect operator=(const tcpconnect&);
	tcpconnect(const tcpconnect&);
	tcpconnect();

	int m_conFd;
	mstring m_sHostName, m_sPort;

	tHttpUrl * m_proxy;

	acfg::tRepoData::IHookHandler *m_pConnStateObserver;
};


#endif /* TCPCONNECT_H_ */
