/*
 * bgtask.cpp
 *
 *  Created on: 18.09.2009
 *      Author: ed
 */

#include <cstring>

#include "bgtask.h"

#include "lockable.h"
#include "acfg.h"
#include "meta.h"
#include "filereader.h"

#include <limits.h>
#include <errno.h>



using namespace MYSTD;

bool bSigTaskAbort=false;
pthread_mutex_t abortMx=PTHREAD_MUTEX_INITIALIZER;


time_t nMaintId(0), nLastId(0);
lockable idLock;

bgtask::bgtask(int fd) : maintenance(fd)
{
}

bgtask::~bgtask()
{

	if(m_reportStream.is_open())
		m_reportStream.close();
}

void _AddFooter(tSS &msg)
{
	msg << "<hr><address>Server " << acfg::agentname
			<<" | <a href=\"https://flattr.com/thing/51105/Apt-Cacher-NG\">"
			"Flattr it!</a> | <a href=\"http://www.unix-ag.uni-kl.de/~bloch/acng/\">"
			"Apt-Cacher NG homepage</a></address>";
}

/*
 *  TODO: this is kept in expiration class for historical reasons. Should be moved to some shared upper
 * class, like "detachedtask" or something like that
 */
void bgtask::Run(const string &cmd)
{

	if (cmd.find("&sigabort")!=stmiss)
	{
		lockguard g(&abortMx);
		bSigTaskAbort=true;
		tStrPos nQuest=cmd.find("?");
		if(nQuest!=stmiss)
		{
			tSS buf(255);
			buf << "HTTP/1.1 302 Redirect\r\nLocation: "
				<< cmd.substr(0,nQuest)<< "\r\nConnection: close\r\n\r\n";
			SendRawData(buf.rptr(), buf.size(), 0);
		}
		return;
	}

	SendChunkedPageHeader("200");

	acbuf deco;
	const char *mark(NULL);
	if(deco.initFromFile((acfg::confdir+SZPATHSEP+m_szDecoFile).c_str()))
	{
		mark=::strchr(deco.rptr(), '~');
		if(mark)
		{
			SendChunk(deco.rptr(), mark-deco.rptr());
			deco.drop((mark-deco.rptr())+1);
		}
		else
		{
			SendChunk(deco.rptr(), deco.size());
			deco.clear();
		}
	}

	static lockable onlyOneCanRun;

	tSS msg;

	if(!onlyOneCanRun.tryLock())
	{
		if(cmd.find("&readonly")==stmiss)
		{
			msg << "<font color=blue>A maintenance task is already running!</font><br>\n"
					"<ul><li><a href=" <<  cmd << "&readonly#bottom>"
							"View current log messages</a></li><li><a href=/"
					<<acfg::reportpage << ">Return to main page</a></li></ul>"
					"<p>(<a href=" << cmd << "&sigabort>Abort current task ASAP</a>)";

			_AddFooter(msg);
			SendChunk(msg);
		}
		else
		{
			time_t id(0);
			{
				lockguard g(idLock);
				id=nMaintId;
			}
			DumpLog(id);
			msg << "<br>\n<a name=bottom>To be continued... (reload this page to see recent output)"
					"<br><a href=/" << acfg::reportpage << ">Return to main page</a>\n";
			_AddFooter(msg);
			SendChunk(msg);

		}
	}
	else
	{
		// locking worked but not intended to act now
		if(cmd.find("&readonly")!=stmiss)
		{
			msg << "<font color=blue>Previous maintainenance task is completed!</font><br>\n"
						"<ul><li><a href=/" << acfg::reportpage
						<< ">Return to main page</a></li></ul><p>Last log contents:<br>\n";
			SendChunk(msg);

			DumpLog(nLastId);

			msg.clear();
			_AddFooter(msg);
			SendChunk(msg);
		}
		else
		{
			/*****************************************************
			 * This is the worker part
			 *****************************************************/
			{
				lockguard g(idLock);
				nMaintId=time(NULL);
			}
			tSS path(acfg::logdir.length()+24);
			path<<acfg::logdir<<CPATHSEP<<"maint_" << nMaintId << ".log";
			m_reportStream.open(path.c_str(), ios::out);

			{
				lockguard g(&abortMx);
				bSigTaskAbort=false;
			}

			SendChunk("Starting maintenance task, apt-cacher-ng version: " ACVERSION ".<br />");

			Action(cmd);

			{
				lockguard g(&abortMx);
				bSigTaskAbort=false;
			}

			msg.clear();
			msg<<"<br>\n<a href=\"/"<<acfg::reportpage<<"\">Return to main page</a>";
			_AddFooter(msg);
			SendChunk(msg);

			{
				lockguard g(idLock);
				nLastId=nMaintId;
				nMaintId=0;
			}

		}
		onlyOneCanRun.unlock();
	}
	if(!deco.empty())
		SendChunk(deco.rptr(), deco.size());
	EndTransfer();
}

bool bgtask::CheckAbortCondition()
{
	lockguard g(&abortMx);
	return bSigTaskAbort;
}



void bgtask::DumpLog(time_t id)
{
	filereader reader;

	if (id<=0)
		return;

	tSS path(acfg::logdir.length()+24);
	path<<acfg::logdir<<CPATHSEP<<"maint_" << id << ".log";
	if (!reader.OpenFile(path))
		maintenance::SendChunk(_SZ2PS("Log not available"));
	else
		maintenance::SendChunk(reader.GetBuffer(), reader.GetSize());
}

void bgtask::SendChunk(const char *data, size_t len)
{
	if(m_reportStream.is_open())
	{
		m_reportStream.write(data, len);
		m_reportStream.flush();
	}
	maintenance::SendChunk(data, len);
}

time_t bgtask::GetTaskId()
{
	return nMaintId;
}
