#!/usr/bin/perl -w
use strict;
use Socket;
use MIME::Base64;
use Sys::Hostname;

my %cfg;
my $retcode=0;

for my $file (</etc/apt-cacher-ng/*.conf>)
{
   my $fd;
   open($fd, $file) or next;
   while(<$fd>)
   {
      chomp;
      s/^\s+//;
      s/\s+$//;
      next if /^#/;
			my ($key, $value) = split(/\s*=\s*/);
      if(!defined($value) && /(\w+)\s*:\s*(\S+)/)
      {
         $key=$1;
         $value=$2;
      }
      next unless defined($value);
      #print "$key -> $value\n";
      $cfg{lc($key)}=$value;
   }
}

die "Cannot find CacheDir in the configuration, aborted.\n" if(!$cfg{cachedir});

syswrite(STDOUT, "Scanning $cfg{cachedir}, please wait...\n");
my %distdirs;
my %counts;

foreach(`find $cfg{cachedir}/. | grep /dists/`)
{
   $_ =~ s!/./!/!g ;
   /(.*\/dists\/([^\/]+))\//;
   next if ! defined($1);
   # There may be many of them, spread around different servers!
   $distdirs{$1}=$2;
   $counts{$2}++;
}

my $hideidx=0;

while(1)
{
   die "No distribution index files found\n" if( ! keys %counts);

   syswrite(STDOUT, "Found distributions:\n");
   my $pos=1;
   my @tmp;
   foreach(keys %counts)
   {
      $tmp[$pos]=$_;
      print "\t".$pos++.". $_ ($counts{$_} index files)\n" if !$hideidx;
   }
   $hideidx=0;
   syswrite(STDOUT, "
WARNING: The removal action would wipe out whole directories containing
         index files. Select d to see detailed list.

Which distribution to remove? (Number, 0 to exit, d for details): ");
   my $response=0;
   sysread(STDIN, $response, 234);
   if($response=~/^d/)
   {
      print "\nDirectories to remove:\n";
      $pos=1;
      foreach my $dname (keys %counts)
      {
         print " ".$pos++.". $dname: \n"; 
         foreach(keys %distdirs)
         {
            if ($distdirs{$_} eq $dname)
            {
               print "  $_ \n"; 
            }
         }
      }
      $hideidx=1; # not displaying the list again
      next;
   }

   exit 0 if( ! ($response=~/\d/) || 0 == $response);
   my $opfer=$tmp[$response];
   syswrite(STDOUT, "Please wait, removing distribution files of $opfer ...\n");
   foreach(keys %distdirs)
   {
      next if ($distdirs{$_} ne $opfer || !-d $_);
      print "Removing $_ ...\n";
      system("/bin/rm", "-r", $_);

      delete $distdirs{$_};
   }
   delete $counts{$opfer};
   syswrite(STDOUT, <<EWARN

NOTE: some package files may become unreferenced now but they will only be
removed after one or multiple expiration runs. To do that immediately, use
the web interface to trigger the expiration and maybe delete unreferenced 
files manually. Press Return to continue...
EWARN
);
   sysread(STDIN, $response, 234);
}

