/***************************************************************************
                          Apollonplayertab.h  -  description
                             -------------------
    begin                : Sat June 7 2003
    copyright            : (C) 2003 by Arend van Beelen
    email                : arend@auton.nl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __APOLLONPLAYERTAB_H
#define __APOLLONPLAYERTAB_H

#include <kparts/part.h>
#include <ksqueezedtextlabel.h>
#include <kurl.h>

#include <qstring.h>

#include "apollontab.h"

class KJanusWidget;
class QFrame;
class QLabel;

class QTextEdit;

class QVBoxLayout;


/**
 * This class provides a tab widget with an embedded Kaboodle Part, which allows
 * for the playback of movies and audio tracks.
 */
class ApollonPlayerTab : public ApollonTab
{
  Q_OBJECT

	public:
		/**
		 * Constructor.
		 */
		ApollonPlayerTab(QWidget* parent, const char *name, KJanusWidget *janus = 0, int pageNum = 0);

		/**
		 * Destructor.
		 */
		~ApollonPlayerTab();

		/**
		 * Plays the given URL.
		 */
		void play(KURL url, const QString &previewTitle = QString::null);

	private:
		KParts::ReadOnlyPart *m_part;
		QTextEdit            *m_errorView;
		QFrame               *m_titleFrame;

		QVBoxLayout          *m_titleFrameLayout;
		KSqueezedTextLabel   *m_titleLabel;

		KJanusWidget         *m_janus;
		int                   m_pageNum;

	signals:

	public slots:

};

#endif
