#include <qstring.h>
#include <qmessagebox.h>

#include <dcopclient.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <kdebug.h>
#include <kiconloader.h>
#include <kstandarddirs.h>
#include <kuniqueapplication.h>

#include "apollon.h"
#include "firstrun.h"
#include "prefix.h"

static KCmdLineOptions options[] = {  {"d", I18N_NOOP("switches on debug output"), 0} , { "s <argument>", I18N_NOOP("Connect to server host:port."), 0 } , { 0, 0, 0 }  };

int main( int argc, char **argv )
{
	KAboutData aboutData( "apollon", "Apollon", "0.9.4", "A giFT client for KDE", KAboutData::License_GPL, "(c) 2003, Bastiaan Naber \n(c) 2003, Martin Köbele \n(c) 2003, Arend van Beelen \n(c) 2002, Robert Wittams", 0, 0, "apollon-devel@lists.sourceforge.net");
	aboutData.addAuthor("Bastiaan Naber", 0, "bastiaan@ricardis.tudelft.nl");
	aboutData.addAuthor("Martin Köbele", 0, "apollon@mkoebele.de");
	aboutData.addAuthor("Arend van Beelen", 0, "arend@auton.nl");
	aboutData.addAuthor("Emre Uyguroglu", 0, "002415@students.emu.edu.tr");
	aboutData.addAuthor("Please contact us via the SourceForge mailinglist", 0, "apollon-user@lists.sourceforge.net");
	aboutData.addAuthor("or on IRC: irc.freenode.net#apollon");

	KCmdLineArgs::init(argc, argv, &aboutData);

	KCmdLineArgs::addCmdLineOptions( options );
	KUniqueApplication::addCmdLineOptions();

	//If there's already a apollon instance running, just exit.
	if(!KUniqueApplication::start())
		return 0;

	KUniqueApplication a;

	KGlobal::dirs()->addPrefix(strdup(PREFIX));
	KGlobal::iconLoader()->addAppDir(strdup(DATADIR));

	// register ourselves as a dcop client
	a.dcopClient()->registerAs(a.name(), false);

	FirstRunWizard wizard;

	if(wizard.checkFirstRun() == false)
		return 0;

	ApollonApp *apollon = new ApollonApp;

	a.setMainWidget( apollon );
	if (!apollon->startDocked())
	  apollon->show();

	return a.exec();
}
