/***************************************************************************
                          ApollonSearchListView.cpp  -  description
                             -------------------
    begin                : Sun December 14 2003
    copyright            : (C) 2003 by Arend van Beelen
    email                : arend@auton.nl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <kiconloader.h>
#include <kicontheme.h>
#include <kaction.h>
#include <kdebug.h>
#include <klocale.h>
#include <kpopupmenu.h>
#include <qcursor.h>
#include <qheader.h>

#include "apollonsearchlistview.h"
#include "apollonsearchviewitem.h"
const int defaultColumnWidth = 50;

ApollonSearchListView::ApollonSearchListView(QWidget *parent) :
  ApollonListView(parent),
  QToolTip(viewport()),
  m_headerMenu(NULL)
{
	// create all the columns
	addColumn("");
	setColumnWidthMode(0, QListView::Manual);
	setColumnWidth(0, 55);

	addColumn(i18n("File Name"));
	setColumnWidthMode(1, QListView::Manual);
	setColumnWidth(1, 350);

	addColumn(i18n("Size"));
	setColumnWidthMode(2, QListView::Manual);
	setColumnAlignment(2, Qt::AlignRight);
	setColumnWidth(2, 80);

	addColumn(i18n("Availability"));
	setColumnWidthMode(3, QListView::Manual);
	setColumnAlignment(3, Qt::AlignRight);
	setColumnWidth(3, 50);

	addColumn(i18n("User"));
	setColumnWidthMode(4, QListView::Manual);
	setColumnAlignment(4, Qt::AlignRight);
	setColumnWidth(4, 80);

	addColumn(i18n("Artist"));
	setColumnWidthMode(5, QListView::Manual);
	setColumnAlignment(5, Qt::AlignLeft);
	setColumnWidth(5, 80);

	addColumn(i18n("Album"));
	setColumnWidthMode(6, QListView::Manual);
	setColumnAlignment(6, Qt::AlignLeft);
	setColumnWidth(6, 80);

	addColumn(i18n("Title"));
	setColumnWidthMode(7, QListView::Manual);
	setColumnAlignment(7, Qt::AlignLeft);
	setColumnWidth(7, 80);

	addColumn(i18n("Duration"));
	setColumnWidthMode(8, QListView::Manual);
	setColumnAlignment(8, Qt::AlignRight);
	setColumnWidth(8, 50);

	addColumn(i18n("File Type"));
	setColumnWidthMode(9, QListView::Manual);
	setColumnAlignment(9, Qt::AlignLeft);
	setColumnWidth(9, 0);

	addColumn(i18n("Bitrate"));
	setColumnWidthMode(10, QListView::Manual);
	setColumnAlignment(10, Qt::AlignRight);
	setColumnWidth(10, 50);

	addColumn(i18n("Category"));
	setColumnWidthMode(11, QListView::Manual);
	setColumnAlignment(11, Qt::AlignLeft);
	setColumnWidth(11, 0);

	addColumn(i18n("Directory"));
	setColumnWidthMode(12, QListView::Manual);
	setColumnAlignment(12, Qt::AlignLeft);
	setColumnWidth(12, 0);

	setSorting(2, false);

	setSelectionMode(QListView::Extended);
	setShowSortIndicator(true);
	setAllColumnsShowFocus(true);
	setRootIsDecorated(true);

	// initialize the header menu
	m_columnVisibleAction = new KActionMenu(i18n("&Show Columns"), this, "showColumns");

	m_headerMenu = m_columnVisibleAction->popupMenu();
	m_headerMenu->insertTitle(i18n("Show"));
	m_headerMenu->setCheckable(true);

	for(int i = columnName; i < header()->count(); ++i)
	{
		m_headerMenu->insertItem(header()->label(i), i - 1);
		m_headerMenu->setItemChecked(i - 1, columnWidth(i) > 0);
	}

	connect(m_headerMenu, SIGNAL(activated(int)), this, SLOT(toggleColumnVisible(int)));
	
	setWakeUpDelay(800);
	m_wakeUpTimer = new QTimer();
	connect(m_wakeUpTimer, SIGNAL(timeout()), SLOT(slotShowTip()));
}

ApollonSearchListView::~ApollonSearchListView()
{
}

void ApollonSearchListView::maybeTip(const QPoint& p)
{
	ApollonSearchViewItem* item = (ApollonSearchViewItem*)itemAt(p);
	if (! item) {
		m_wakeUpTimer->stop();
		return;
	}
	
	m_rect = itemRect(item);
	if (! m_rect.isValid()) {
		m_wakeUpTimer->stop();
		return;
	}
	m_rect.setWidth(width());
	
	KIconLoader *loader = KGlobal::iconLoader();
	QMimeSourceFactory::defaultFactory()->setPixmap( "mimetypeicon",  loader->loadIcon(item->mimeTypeIcon(), KIcon::MainToolbar));
	
	m_tipContent = "<big><img source=\"mimetypeicon\"> " + item->fileName() + "</big> <hr>" +
		( item->title().isEmpty() ? "" : 
			"<b>"+i18n("Title") + ": &nbsp;</b>" + item->title() + "<br>" ) +
		( item->user().isEmpty() ? "" : 
			"<b>"+i18n("User") + ": &nbsp;</b>" + item->user() + "<br>" ) +
		( item->album().isEmpty() ? "" : 
			"<b>"+i18n("Album") + ": &nbsp;</b>" + item->album() + "<br>" ) +
		( item->artist().isEmpty() ? "" : 
			"<b>"+i18n("Artist") + ": &nbsp;</b>" + item->artist() + "<br>"  ) +
		( item->category().isEmpty() ? "" : 
			"<b>"+i18n("Category") + ": &nbsp;</b>" + item->category() + "<br>" ) +
		( item->size().isEmpty() ? "" : 
			"<b>"+i18n("Size") + ": &nbsp;</b>" + item->text(ApollonSearchListView::columnSize) + "<br>" ) +
		( item->duration().isEmpty() ?  "" : 
			"<b>"+i18n("Duration") + ": &nbsp;</b>" + item->text(ApollonSearchListView::columnDuration) + "<br>" ) +
		( item->bitrate().isEmpty() ? "" : 
			"<b>"+i18n("Bitrate") + ": &nbsp;</b>" + item->text(ApollonSearchListView::columnBitrate) + "<br>" ) +
		"<b>"+i18n("File Type") + ": &nbsp;</b>" + item->mimeTypeComment() + "<br>";
		
	m_wakeUpTimer->start(m_wakeUpDelay);
}

void ApollonSearchListView::slotShowTip() 
{
	tip(m_rect, m_tipContent);
}

void ApollonSearchListView::restoreLayout(KConfig *config, const QString &group)
{
	KListView::restoreLayout(config, group);

	for(int i = columnName; i < header()->count(); ++i)
	{
		m_headerMenu->setItemChecked(i - 1, columnWidth(i) > 0);
	}
}

void ApollonSearchListView::setColumnWidth(int column, int w)
{
	KListView::setColumnWidth(column, w);

	if(m_headerMenu)
		m_headerMenu->setItemChecked(column - 1, w > 0);
}

void ApollonSearchListView::toggleColumnVisible(int column)
{
	column++;

	if(columnWidth(column) == 0)
	{
		setColumnWidth(column, defaultColumnWidth);
	}
	else
	{
		setColumnWidth(column, 0);
	}
}

bool ApollonSearchListView::eventFilter(QObject *watched, QEvent *e)
{
	if(watched == header())
	{
		if(e->type() == QEvent::MouseButtonPress)
		{
			QMouseEvent *me = static_cast<QMouseEvent*>(e);

			switch(me->button())
			{
				case RightButton:
					m_headerMenu->popup(QCursor::pos());
					return true;

				default:
					break;
			}
		}
	}

	return KListView::eventFilter(watched, e);
}
