/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.parsers;

import cz.startnet.utils.pgdiff.Resources;
import cz.startnet.utils.pgdiff.parsers.Parser;
import cz.startnet.utils.pgdiff.parsers.ParserException;
import cz.startnet.utils.pgdiff.parsers.ParserUtils;
import cz.startnet.utils.pgdiff.schema.PgColumn;
import cz.startnet.utils.pgdiff.schema.PgConstraint;
import cz.startnet.utils.pgdiff.schema.PgDatabase;
import cz.startnet.utils.pgdiff.schema.PgInheritedColumn;
import cz.startnet.utils.pgdiff.schema.PgRelation;
import cz.startnet.utils.pgdiff.schema.PgSchema;
import cz.startnet.utils.pgdiff.schema.PgSequence;
import cz.startnet.utils.pgdiff.schema.PgTable;
import java.text.MessageFormat;
import java.util.ArrayList;

public class AlterRelationParser {
    public static void parse(PgDatabase pgDatabase, String string, boolean bl) {
        Parser parser = new Parser(string);
        parser.expect("ALTER");
        parser.expectOptional("FOREIGN");
        if (parser.expectOptional("TABLE")) {
            parser.expectOptional("ONLY");
        } else if (!parser.expectOptional("MATERIALIZED", "VIEW") && !parser.expectOptional("VIEW")) {
            parser.throwUnsupportedCommand();
        }
        String string2 = parser.parseIdentifier();
        String string3 = ParserUtils.getSchemaName(string2, pgDatabase);
        PgSchema pgSchema = pgDatabase.getSchema(string3);
        if (pgSchema == null) {
            throw new RuntimeException(MessageFormat.format(Resources.getString("CannotFindSchema"), string3, string));
        }
        String string4 = ParserUtils.getObjectName(string2);
        PgRelation pgRelation = pgSchema.getRelation(string4);
        if (pgRelation == null) {
            PgSequence pgSequence = pgSchema.getSequence(string4);
            if (pgSequence != null) {
                AlterRelationParser.parseSequence(parser, pgSequence, bl, string2, pgDatabase);
                return;
            }
            throw new RuntimeException(MessageFormat.format(Resources.getString("CannotFindObject"), string2, string));
        }
        PgTable pgTable = null;
        if (pgRelation instanceof PgTable) {
            pgTable = (PgTable)pgRelation;
        }
        while (!parser.expectOptional(";")) {
            if (parser.expectOptional("ALTER")) {
                AlterRelationParser.parseAlterColumn(parser, pgRelation);
            } else if (parser.expectOptional("CLUSTER", "ON")) {
                pgRelation.setClusterIndexName(ParserUtils.getObjectName(parser.parseIdentifier()));
            } else if (parser.expectOptional("OWNER", "TO")) {
                pgRelation.setOwnerTo(parser.parseIdentifier());
            } else if (pgTable != null && parser.expectOptional("ADD")) {
                if (parser.expectOptional("FOREIGN", "KEY")) {
                    AlterRelationParser.parseAddForeignKey(parser, pgTable);
                } else if (parser.expectOptional("CONSTRAINT")) {
                    AlterRelationParser.parseAddConstraint(parser, pgTable, pgSchema);
                } else {
                    parser.throwUnsupportedCommand();
                }
            } else if (pgTable != null && parser.expectOptional("ENABLE", "ROW", "LEVEL", "SECURITY")) {
                pgTable.setRLSEnabled(true);
            } else if (pgTable != null && parser.expectOptional("DISABLE", "ROW", "LEVEL", "SECURITY")) {
                pgTable.setRLSEnabled(false);
            } else if (pgTable != null && parser.expectOptional("FORCE", "ROW", "LEVEL", "SECURITY")) {
                pgTable.setRLSForced(true);
            } else if (pgTable != null && parser.expectOptional("NO", "FORCE", "ROW", "LEVEL", "SECURITY")) {
                pgTable.setRLSForced(false);
            } else if (pgTable != null && parser.expectOptional("ENABLE")) {
                AlterRelationParser.parseEnable(parser, bl, string2, pgDatabase);
            } else if (pgTable != null && parser.expectOptional("DISABLE")) {
                AlterRelationParser.parseDisable(parser, bl, string2, pgDatabase);
            } else {
                parser.throwUnsupportedCommand();
            }
            if (parser.expectOptional(";")) break;
            parser.expect(",");
        }
    }

    private static void parseEnable(Parser parser, boolean bl, String string, PgDatabase pgDatabase) {
        if (parser.expectOptional("REPLICA")) {
            if (parser.expectOptional("TRIGGER")) {
                if (bl) {
                    pgDatabase.addIgnoredStatement("ALTER TABLE " + string + " ENABLE REPLICA TRIGGER " + parser.parseIdentifier() + ';');
                } else {
                    parser.parseIdentifier();
                }
            } else if (parser.expectOptional("RULE")) {
                if (bl) {
                    pgDatabase.addIgnoredStatement("ALTER TABLE " + string + " ENABLE REPLICA RULE " + parser.parseIdentifier() + ';');
                } else {
                    parser.parseIdentifier();
                }
            } else {
                parser.throwUnsupportedCommand();
            }
        } else if (parser.expectOptional("ALWAYS")) {
            if (parser.expectOptional("TRIGGER")) {
                if (bl) {
                    pgDatabase.addIgnoredStatement("ALTER TABLE " + string + " ENABLE ALWAYS TRIGGER " + parser.parseIdentifier() + ';');
                } else {
                    parser.parseIdentifier();
                }
            } else if (parser.expectOptional("RULE")) {
                if (bl) {
                    pgDatabase.addIgnoredStatement("ALTER TABLE " + string + " ENABLE RULE " + parser.parseIdentifier() + ';');
                } else {
                    parser.parseIdentifier();
                }
            } else {
                parser.throwUnsupportedCommand();
            }
        }
    }

    private static void parseDisable(Parser parser, boolean bl, String string, PgDatabase pgDatabase) {
        if (parser.expectOptional("TRIGGER")) {
            if (bl) {
                pgDatabase.addIgnoredStatement("ALTER TABLE " + string + " DISABLE TRIGGER " + parser.parseIdentifier() + ';');
            } else {
                parser.parseIdentifier();
            }
        } else if (parser.expectOptional("RULE")) {
            if (bl) {
                pgDatabase.addIgnoredStatement("ALTER TABLE " + string + " DISABLE RULE " + parser.parseIdentifier() + ';');
            } else {
                parser.parseIdentifier();
            }
        } else {
            parser.throwUnsupportedCommand();
        }
    }

    private static void parseAddConstraint(Parser parser, PgTable pgTable, PgSchema pgSchema) {
        String string = ParserUtils.getObjectName(parser.parseIdentifier());
        PgConstraint pgConstraint = new PgConstraint(string);
        pgConstraint.setTableName(pgTable.getName());
        pgTable.addConstraint(pgConstraint);
        if (parser.expectOptional("PRIMARY", "KEY")) {
            pgSchema.addPrimaryKey(pgConstraint);
            pgConstraint.setDefinition("PRIMARY KEY " + parser.getExpression());
        } else {
            pgConstraint.setDefinition(parser.getExpression());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void parseAlterColumn(Parser parser, PgRelation pgRelation) {
        parser.expectOptional("COLUMN");
        String string = ParserUtils.getObjectName(parser.parseIdentifier());
        if (parser.expectOptional("SET")) {
            if (parser.expectOptional("STATISTICS")) {
                PgColumn pgColumn = pgRelation.getColumn(string);
                if (pgColumn == null) {
                    throw new RuntimeException(MessageFormat.format(Resources.getString("CannotFindTableColumn"), string, pgRelation.getName(), parser.getString()));
                }
                pgColumn.setStatistics(parser.parseInteger());
                return;
            } else if (parser.expectOptional("NOT NULL")) {
                if (pgRelation.containsColumn(string)) {
                    PgColumn pgColumn = pgRelation.getColumn(string);
                    if (pgColumn == null) {
                        throw new RuntimeException(MessageFormat.format(Resources.getString("CannotFindTableColumn"), string, pgRelation.getName(), parser.getString()));
                    }
                    pgColumn.setNullValue(false);
                    return;
                } else {
                    if (!pgRelation.containsInheritedColumn(string)) throw new ParserException(MessageFormat.format(Resources.getString("CannotFindColumnInTable"), string, pgRelation.getName()));
                    PgInheritedColumn pgInheritedColumn = pgRelation.getInheritedColumn(string);
                    if (pgInheritedColumn == null) {
                        throw new RuntimeException(MessageFormat.format(Resources.getString("CannotFindTableColumn"), string, pgRelation.getName(), parser.getString()));
                    }
                    pgInheritedColumn.setNullValue(false);
                }
                return;
            } else if (parser.expectOptional("DEFAULT")) {
                String string2 = parser.getExpression();
                if (pgRelation.containsColumn(string)) {
                    PgColumn pgColumn = pgRelation.getColumn(string);
                    if (pgColumn == null) {
                        throw new RuntimeException(MessageFormat.format(Resources.getString("CannotFindTableColumn"), string, pgRelation.getName(), parser.getString()));
                    }
                    pgColumn.setDefaultValue(string2);
                    return;
                } else {
                    if (!pgRelation.containsInheritedColumn(string)) throw new ParserException(MessageFormat.format(Resources.getString("CannotFindColumnInTable"), string, pgRelation.getName()));
                    PgInheritedColumn pgInheritedColumn = pgRelation.getInheritedColumn(string);
                    if (pgInheritedColumn == null) {
                        throw new RuntimeException(MessageFormat.format(Resources.getString("CannotFindTableColumn"), string, pgRelation.getName(), parser.getString()));
                    }
                    pgInheritedColumn.setDefaultValue(string2);
                }
                return;
            } else if (parser.expectOptional("STORAGE")) {
                PgColumn pgColumn = pgRelation.getColumn(string);
                if (pgColumn == null) {
                    throw new RuntimeException(MessageFormat.format(Resources.getString("CannotFindTableColumn"), string, pgRelation.getName(), parser.getString()));
                }
                if (parser.expectOptional("PLAIN")) {
                    pgColumn.setStorage("PLAIN");
                    return;
                } else if (parser.expectOptional("EXTERNAL")) {
                    pgColumn.setStorage("EXTERNAL");
                    return;
                } else if (parser.expectOptional("EXTENDED")) {
                    pgColumn.setStorage("EXTENDED");
                    return;
                } else if (parser.expectOptional("MAIN")) {
                    pgColumn.setStorage("MAIN");
                    return;
                } else {
                    parser.throwUnsupportedCommand();
                }
                return;
            } else {
                parser.throwUnsupportedCommand();
            }
            return;
        } else {
            parser.throwUnsupportedCommand();
        }
    }

    private static void parseAddForeignKey(Parser parser, PgTable pgTable) {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        parser.expect("(");
        while (!parser.expectOptional(")")) {
            arrayList.add(ParserUtils.getObjectName(parser.parseIdentifier()));
            if (parser.expectOptional(")")) break;
            parser.expect(",");
        }
        String string = ParserUtils.generateName(pgTable.getName() + "_", arrayList, "_fkey");
        PgConstraint pgConstraint = new PgConstraint(string);
        pgTable.addConstraint(pgConstraint);
        pgConstraint.setDefinition(parser.getExpression());
        pgConstraint.setTableName(pgTable.getName());
    }

    private static void parseSequence(Parser parser, PgSequence pgSequence, boolean bl, String string, PgDatabase pgDatabase) {
        while (!parser.expectOptional(";")) {
            if (parser.expectOptional("OWNER", "TO")) {
                if (bl) {
                    pgDatabase.addIgnoredStatement("ALTER TABLE " + string + " OWNER TO " + parser.parseIdentifier() + ';');
                    continue;
                }
                parser.parseIdentifier();
                continue;
            }
            parser.throwUnsupportedCommand();
        }
    }

    private AlterRelationParser() {
    }
}

