#! /usr/bin/ruby
# EUC-JP/ˤۤ
require 'anthy'

Anthy::quit()

Anthy::conf_override("CONFFILE","../anthy-conf")
Anthy::conf_override("DIC_FILE","../mkanthydic/anthy.dic")
Anthy::conf_override("ANTHYDIR","../depgraph")

Anthy::init()

Anthy::set_personality("")

$ac = Anthy::Context.new()

class Test
  def initialize(s, ex)
    @src_array = s
    @exp_array = ex
    @src_str = @src_array.join
  end
  def check(verbose)
    $ac.set_string(@src_str)
    unless do_compare()
      $ac.print() if verbose
      return false
    end
    return true
  end
  def do_compare
    if (@src_array.size != $ac.get_stat.nr_segment) 
      return false
    end
    @src_array.each_with_index do |src, index| 
      return false if $ac.get_segment(index, -1) != src
    end
    return true
  end
end

class TestManager
  def initialize
    @tests = []
  end
  def add(str, ex)
    @tests << Test.new(str, ex)
  end
  def test(verbose)
    test_num = @tests.size
    ng_num = @tests.find_all{|i| !i.check(verbose)}.size
    
    print test_num
    print "tests, "
    print (test_num - ng_num)
    print "hits, "
    print ng_num
    print " misses\n"
    print (test_num - ng_num) * 100 / test_num
    print "%\n"
  end
end

m = TestManager.new
m.add(["Ǥʤ","Ф","ޤ"], [])
m.add(["Ǥʤ","դ"], [])
m.add(["꤫Τ","ޤ","뤤","ʤǤ"], [])
m.add(["꤬Ǥ"], [])
m.add(["","","Τ"],[])
m.add(["ä","Ĥˤʤä"],[])
m.add(["äƤ"],[])
m.add(["줿","ܤ","ʤΤ","ϤäƤ","餤","Τʤ"], [])
m.add(["äƤ"], [])
m.add(["ʤ","󤼤","褦礯"], [])
m.add(["ĤƤʤ","Ȥ","","ʤƤʤǤɤ"], [])
m.add(["Ϥʤ"], [])
m.add(["㤯"], [])
m.add(["Ƥ"], [])
m.add(["Ƥ","","դ󤫤","ä","Ǥ","󤬤Ƥޤ"], [])
m.add(["Ȥ"], [])
m.add(["Ϥ","ʤ褦"], [])
m.add(["Ϥ","ʤ"],[])
m.add(["Τ", "ʤä","äƤ"], [])
m.add(["äƤ"], [])
m.add(["äȤ"], [])
m.add(["󤬤Ƥ","Ȥ","äǤ"], [])
m.add(["󤬤ƤߤޤΤ"],[])
m.add(["󤬤ʤ"], [])
m.add(["Ф"], [])
m.add(["","ब","礦ۤ",""], [])
m.add(["Ƥ뤫","⤤ޤ"], [])
m.add(["礦","Ƥ"], [])
m.add(["礦"], [])
m.add(["Ĥ", "ߤ", "줤", ""], [])
m.add(["ۤ","󤸤","ؤ󤳤"], [])
m.add(["","call-with-current-continuation",""],[])
m.add(["","դ","ˤ夦礯줿","桼","ʤޤ"], [])
m.add(["󤽡褦","ˤۤ󤴤ˤ夦礯","פ","餷","С","꡼ޤ"], [])
m.add(["󤷤ʤ",""], [])
m.add(["Ƥ뤫","⤤ޤ"], [])
m.add(["Ӥ","","Ĥ"], [])
m.add(["", "Ĥ"], [])
m.add(["礦","Ƥ餦ȤˤʤǤ"], [])
m.add(["褦", ""], [])
m.add(["礷󤷤Ǥ","Ƥ"], [])
m.add(["ʤ",""],[])
m.add(["","Ĥ","ޤ","Ϥ"],[])
m.add(["ä", "", "", "", "ȤӤ", "֤"], [])
m.add(["礦","ƤȤ","֤"], [])
m.add(["Τ"], [])
m.add(["Τ⤢"], [])
m.add(["Ĥ褤","Ҥ"], [])
m.add(["Ǥ","ޤ줿"], [])
m.add(["ɤʤ뤫","󤬤"], [])
m.add(["Ȥʤ"], [])
m.add(["ɤ","Τ","API","ҤĤ褦","ɤ"], [])
m.add(["ʤ","ۤ","󤵤","","ʤ"],[])
m.add(["ˤۤ󤸤","󤭤礦ʤ","ruby","ᤤʤǤ礦"], [])
m.add(["ˤۤ","ؤ󤫤","Ƥ"],[])
m.add(["Τ","Ǥ"],[])
m.add(["Τ",""],[])
m.add(["ؤ"],[])
m.add(["᤬","Ϥʤޤ"], [])
m.add(["","Ȥ"], [])
m.add(["ޤ","Ϥ䤤","äΤ"], [])
m.add(["餤","礦"], [])
m.add(["褯","󤬤Ƥߤ"],[])
m.add(["錄",""],[])
m.add(["錄","ʤޤ", "ФǤ"], [])
m.add(["錄ΤʤޤϤʤΤǤ"], [])
m.add(["ruby","anthy","Ĥ褦ˤʤä"], [])
m.add(["uim-fep","餷","С"], [])
m.add(["100ˤ"],[])
m.add(["3礯"],[])
#
m.add(["ߤΤƤޤ"], [])
m.add(["äƤޤ"], ["ä","ޤ"])
m.add(["ä褦",""],[])
m.add(["Ƥ"],[])
m.add(["錄","碌","äƤΤǤ礦"],[])
m.add(["֤ޤ","դ餰"],[])
m.add(["󤼤","ۤ","狼ޤ"],[])
m.add(["狼ޤ"],[])
m.add(["Ф褦ȤƤ"],[])
m.add(["ä","ޤ"],[])
m.add(["Ĥ","ۤ"],[])
m.add(["","ä","졼","","Ƥ"],[])
m.add(["ƤʤǤ礦"],[])
m.add(["Ĥ褦","Ф","","礦"],[])
m.add(["Ȥޤ","Ƥޤ"],[])
m.add(["礦","ʤȤ","ҤĤ褦"],[])
m.add(["Ϥʤ","Ȥʤ","ޤ󤷡","Τǡ","ʤ","","ޤ"],[])
m.add(["","Τ","ʤǤ"], [])
m.add(["Τ","Ϥ褦ˤ뤳Ȥ","夦褦"],[])
m.add(["ۤ","äѤĤ","","","ޤ"],[])
m.add(["ȤȤĤ","ˤä","Ƥߤ褦","äΤ"],[])
m.add(["Ȥʤ"],[])
m.add(["ߤ","Ȥʤ"],[])
m.add(["फ󤷤","褽"],[])
m.add(["Ҥ"],[])
m.add(["󤫤Ƥ"],[])
m.add(["̤ʤ"],[])
m.add(["󤸤Ƥߤ"],[])
m.add(["Ҥ"],[])
m.add(["󤿤ä"],[])
m.add(["ߤʤǤ"],[])
m.add(["ޤä","餷","Ǥ","Τ","Ĥ󤹤"],[])

m.test(true)

m2 = TestManager.new
m2.add(["Ǥʤ","Ф","ޤ"], [])
m2.add(["ĤƤʤ","Ȥ","","ʤƤʤǤɤ"], [])
#m2.test(true)
