/*
 * ʸФ򥽡Ȥ롣
 * Ūˤ϶ܤʸ⸫ơñηˤɾ򤹤롣
 * ֤äκ⤹롣
 *
 * Funded by IPA̤Ƨեȥ¤ 2001 9/22
 * Copyright (C) 2000-2003 TABATA Yusuke
 * Copyright (C) 2001 UGAWA Tomoharu
 *
 * $Id: candsort.c,v 1.27 2002/11/17 14:45:47 yusuke Exp $
 *
 */

#include <stdlib.h>
#include <segment.h>
#include <splitter.h>
#include "sorter.h"
#include "ordering.h"

/* ؽˤ */
#define OCHAIRE_BASE OCHAIRE_SCORE
/* seginfoʬ̵ȤΡҤ餬ʥʤΥ */
#define NOCONV_WITH_BIAS 900000
/* ̤θ */
#define NORMAL_BASE 100
/* ñ */
#define SINGLEWORD_BASE 10
/* Ҥ餬ʥʤΥǥեȤΥ */
#define NOCONV_BASE 1

/* ̵äݤƤȽǤ */
static int
uncertain_segment_p(struct seg_ent *se)
{
  struct seg_info *si;
  if (se->nr_seginfo == 0) {
    return 0;
  }
  si = se->si[0];
  /* Ĺ6 */
  if (se->len * 3 >= (si->info_len) * 5) {
    return 1;
  }
  return 0;
}

static void
release_redundant_candidate(struct seg_ent *se)
{
  int i, j;
  /* ϥȤƤΤscore0θ䤬¤Ǥ */
  for (i = 0; i < se->nr_cands && se->cands[i]->score; i++);
  /* iθ */
  if (i < se->nr_cands) {
    for (j = i; j < se->nr_cands; j++) {
      anthy_release_cand_ent(se->cands[j]);
    }
    se->nr_cands = i;
  }
}

/* qsortѤθӴؿ */
static int
candidate_compare_func(const void *p1, const void *p2)
{
  const struct cand_ent *const *c1 = p1, *const *c2 = p2;
  return (*c2)->score - (*c1)->score;
}

static void
sort_segment(struct seg_ent *se)
{
  qsort(se->cands, se->nr_cands,
	sizeof(struct cand_ent *),
	candidate_compare_func);
}

static void
trim_kana_candidate(struct seg_ent *se)
{
  int i;
  if (se->cands[0]->flag & CEF_KATAKANA) {
    return ;
  }
  for (i = 1; i < se->nr_cands; i++) {
    if (se->cands[i]->flag & CEF_KATAKANA) {
      /* ޤǲ */
      se->cands[i]->score = NOCONV_BASE;
    }
  }
}

static void
check_dupl_candidate(struct seg_ent *se)
{
  int i,j;
  for (i = 0; i < se->nr_cands - 1; i++) {
    for (j = i + 1; j < se->nr_cands; j++) {
      if (!anthy_xstrcmp(&se->cands[i]->str, &se->cands[j]->str)) {
	/* 롼ɤޥåΤ֤Ȥ٤ */
	se->cands[j]->score = 0;
	se->cands[i]->flag |= se->cands[j]->flag;
      }
    }
  }
}

/* ʻƤˤä줿ɾ */
static void
eval_candidate_by_seginfo(struct seg_ent *seg,
			  struct cand_ent *ce)
{
  int i;
  int score = 0;
  /* ޤñ٤ˤscoreû */
  for (i = 0; i < ce->nr_words; i++) {
    int pos, div = 1;
    struct cand_elm *elm = &ce->elm[i];
    if (elm->nth < 0) {
      /* ƤоݳʤΤǥå */
      continue;
    }
    pos = anthy_wtype_get_pos(elm->wt);
    if (pos == POS_PRE || pos == POS_SUC) {
      div = 8;
    }
    score +=
      anthy_get_nth_dic_ent_freq(elm->se, elm->nth) *
      elm->str.len * elm->str.len *
      elm->ratio / (RATIO_BASE * div);
  }
  score = score *
    (seg->len * seg->len);

  /* ʸṽ¤ΥκĴ */
  if (ce->si) {
    /* ʸǤäȤ⤤ seg_infoȤʤ */
    int i;
    int ratio = RATIO_BASE * ce->si->score / seg->si[0]->score;
    /* 3 */
    for (i = 0; i < 3; i++) {
      score *= ratio;
      score /= RATIO_BASE;
    }
  }
  ce->score = NORMAL_BASE + score;
}

/* ɾ */
static void
eval_candidate(struct seg_ent *seg, struct cand_ent *ce, int uncertain)
{
  if ((ce->flag &
       (CEF_OCHAIRE | CEF_SINGLEWORD | CEF_HIRAGANA |
	CEF_KATAKANA | CEF_GUESS)) == 0) {
    /* splitterξ(seginfo)ˤä줿 */
    eval_candidate_by_seginfo(seg, ce);
  } else if (ce->flag & CEF_OCHAIRE) {
    ce->score = OCHAIRE_BASE;
  } else if (ce->flag & CEF_SINGLEWORD) {
    ce->score = SINGLEWORD_BASE;
  } else if (ce->flag & (CEF_HIRAGANA | CEF_KATAKANA | CEF_GUESS)) {
    if (uncertain) {
      /*
       * ʸϳʤɤǡҤ餬ʥʤ
       * Ф褤
       */
      ce->score = NOCONV_WITH_BIAS;
      if (CEF_KATAKANA & ce->flag) {
	ce->score ++;
      }
      if (CEF_GUESS & ce->flag) {
	ce->score += 2;
      }
    } else {
      ce->score = NOCONV_BASE;
    }
  }
  ce->score += 1;
}

static void
eval_segment(struct seg_ent *se)
{
  int i;
  int uncertain = uncertain_segment_p(se);
  for (i = 0; i < se->nr_cands; i++) {
    eval_candidate(se, se->cands[i], uncertain);
  }
}

/** ƤФ륨ȥݥ */
void
anthy_sort_candidate(struct segment_list *sl, int nth)
{
  int i;
  /* ޤɾ */
  for (i = nth; i < sl->nr_segments; i++) {
    eval_segment(anthy_get_nth_segment(sl, i));
  }
  /* Ĥ˥Ȥ */
  for (i = nth; i < sl->nr_segments; i++) {
    sort_segment(anthy_get_nth_segment(sl, i));
  }
  /* ֤äȥ㤤0դ */
  for (i = nth; i < sl->nr_segments; i++) {
    check_dupl_candidate(anthy_get_nth_segment(sl, i));
  }
  /* ⤦ɥȤ */
  for ( i = nth ; i < sl->nr_segments ; i++){
    sort_segment(anthy_get_nth_segment(sl, i));
  }
  /* ɾ0θ */
  for (i = nth ;i < sl->nr_segments ; i++) {
    release_redundant_candidate(anthy_get_nth_segment(sl, i));
  }
  /**/
  anthy_reorder_candidates_by_relation(sl, nth);
  /* ˤѹ */
  for (i = nth; i < sl->nr_segments; i++) {
    anthy_reorder_candidates_by_history(anthy_get_nth_segment(sl, i));
  }
  /* θ */
  for (i = nth; i < sl->nr_segments; i++) {
    anthy_proc_swap_candidate(anthy_get_nth_segment(sl, i));
  }
  /* ޤȤ */
  for ( i = nth ; i < sl->nr_segments ; i++){
    sort_segment(anthy_get_nth_segment(sl, i));
  }
  /* ʤθ䤬ƬǤʤкǸ˲ */
  for (i = nth; i < sl->nr_segments; i++) {
    trim_kana_candidate(anthy_get_nth_segment(sl, i));
  }
  /* ޤȤ */
  for ( i = nth ; i < sl->nr_segments ; i++){
    sort_segment(anthy_get_nth_segment(sl, i));
  }
}
