/*1:*/
#line 79 "statlib.w"

#define REVDATE "15th February 2003"

/*:1*//*49:*/
#line 2065 "statlib.w"


/*53:*/
#line 2267 "statlib.w"


#include "config.h"         


#include <iostream> 
#include <exception> 
#include <stdexcept> 
#include <string> 
using namespace std;

#include <stdio.h> 
#include <stdlib.h> 
#include <ctype.h> 
#ifdef HAVE_GETOPT
#ifdef HAVE_UNISTD_H
#include <unistd.h> 
#endif
#else
#include "getopt.h"     
#endif
#include "statlib.h"        


/*:53*/
#line 2067 "statlib.w"
;

/*51:*/
#line 2210 "statlib.w"

static void usage(void)
{
cout<<PRODUCT<<"  --  Analyse eggsummary files.  Call:\n";
cout<<"              "<<PRODUCT<<" [options] [infile] [outfile]\n";
cout<<"\n";
cout<<"Options:\n";
cout<<"           --copyright       Print copyright information\n";
cout<<"           -u, --help        Print this message\n";
cout<<"           --version         Print version number\n";
cout<<"\n";
cout<<"by John Walker\n";
cout<<"http://www.fourmilab.ch/\n";
}

/*:51*/
#line 2069 "statlib.w"
;

int main(int argc,char*argv[])
{
extern char*optarg;


int opt;

/*50:*/
#line 2178 "statlib.w"

while((opt= getopt(argc,argv,"nu-:"))!=-1){
switch(opt){

case'u':
case'?':
usage();
return 0;

case'-':
switch(optarg[0]){
case'c':
cout<<"This program is in the public domain.\n";
return 0;

case'h':
usage();
return 0;

case'v':
cout<<PRODUCT<<" "<<VERSION<<"\n";
cout<<"Last revised: "<<REVDATE<<"\n";
cout<<"The latest version is always available\n";
cout<<"at http://www.fourmilab.ch/eggtools/eggshell\n";
return 0;
}
}
}

/*:50*/
#line 2078 "statlib.w"
;

/*52:*/
#line 2229 "statlib.w"

{
int i;
dataTable<int> zot;
dataTable<int> ::iterator z;

#define PR for (z =  zot.begin(); z != zot.end(); z++) { cout << *z << " "; } cout << "\n";

for(i= 0;i<10;i++){
zot.push_back(rand()&0x3F);
}
PR;

sort(zot.begin(),zot.end());
PR;
reverse(zot.begin(),zot.end());
PR;

cout<<"Mean = "<<zot.mean()<<"\n";
cout<<"Geometric mean = "<<zot.geometricMean()<<"\n";
cout<<"Harmonic mean = "<<zot.harmonicMean()<<"\n";
cout<<"RMS = "<<zot.RMS()<<"\n";
cout<<"Median = "<<zot.median()<<"\n";
cout<<"Mode = "<<zot.mode()<<"\n";
cout<<"Percentile(0.5) = "<<zot.percentile(0.5)<<"\n";
cout<<"Quartile(1) = "<<zot.quartile(1)<<"\n";
cout<<"Quartile(3) = "<<zot.quartile(3)<<"\n";

cout<<"Variance = "<<zot.variance()<<"\n";
cout<<"Standard deviation = "<<zot.stdev()<<"\n";
cout<<"CentralMoment(3) = "<<zot.centralMoment(3)<<"\n";
cout<<"Skewness = "<<zot.skewness()<<"\n";
cout<<"Kurtosis = "<<zot.kurtosis()<<"\n";
}

/*:52*/
#line 2080 "statlib.w"
;

#if 1



{
normalDistribution nd(100,7.07);

cout<<"Normal dist: mu = "<<nd.get_mu()<<" sigma = "<<
nd.get_sigma()<<" variance = "<<nd.variance()<<"\n";
cout<<"  P = "<<nd.CDF_P(110)<<" Q = "<<nd.CDF_Q(110)<<"\n";
nd.writeParameters(cout);

nd.approximateBinomial(200);
cout<<"Normal dist: mu = "<<nd.get_mu()<<" sigma = "<<
nd.get_sigma()<<" variance = "<<nd.variance()<<"\n";
cout<<"  P = "<<nd.CDF_P(110)<<" Q = "<<nd.CDF_Q(110)<<
"  z = "<<nd.z_score(110)<<"\n";
}

{
poissonDistribution pd(10);

pd.writeParameters(cout);
cout<<"Poisson dist: lambda = "<<pd.get_lambda()<<"\n";
cout<<"  P = "<<pd.CDF_P(5)<<" Q = "<<pd.CDF_Q(5)<<"\n";
}

{
chiSquareDistribution xd(32);

xd.writeParameters(cout);
cout<<"Chi-square dist: k = "<<xd.get_k()<<"\n";
cout<<"  P = "<<xd.CDF_P(36)<<" Q = "<<xd.CDF_Q(36)<<"\n";
}

{
gammaDistribution gd(7.5,3.75);

gd.writeParameters(cout);
cout<<"Gamma dist: alpha = "<<gd.get_alpha()<<
"  lambda = "<<gd.get_lambda()<<"\n";
cout<<"  P = "<<gd.CDF_P(2.2)<<" Q = "<<gd.CDF_Q(2.2)<<"\n";
}

{
betaDistribution bd(3,4);

bd.writeParameters(cout);
cout<<"Beta dist: a = "<<bd.get_a()<<
"  b = "<<bd.get_b()<<"\n";
cout<<"  P = "<<bd.CDF_P(0.4)<<" Q = "<<bd.CDF_Q(0.4)<<"\n";
}

{
tDistribution xd(32);

xd.writeParameters(cout);
cout<<"t dist: k = "<<xd.get_k()<<"\n";
cout<<"  P = "<<xd.CDF_P(0.8)<<" Q = "<<xd.CDF_Q(0.8)<<"\n";
}

{
FDistribution fd(12,16);

fd.writeParameters(cout);
cout<<"F dist: u = "<<fd.get_u()<<"  v = "<<fd.get_v()<<"\n";
cout<<"  P = "<<fd.CDF_P(0.8)<<" Q = "<<fd.CDF_Q(0.8)<<"\n";
}

{
binomialDistribution bd(200,0.5);

cout<<"Binomial dist: n = "<<bd.get_n()<<" r = "<<
bd.get_r()<<" variance = "<<bd.variance()<<"\n";
cout<<"  P = "<<bd.CDF_P(110)<<" Q = "<<bd.CDF_Q(110)<<
"  z = "<<bd.z_score(110)<<"\n";
bd.writeParameters(cout);
}

{
negativeBinomialDistribution bd(10,0.5);

cout<<"Negative binomial dist: n = "<<bd.get_n()<<" r = "<<
bd.get_r()<<" variance = "<<bd.variance()<<"\n";
cout<<"  P = "<<bd.CDF_P(15)<<" Q = "<<bd.CDF_Q(15)<<"\n";
bd.writeParameters(cout);
}
#endif

return 0;
}

/*:49*/
