/*
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with the program; if not, see <http://www.gnu.org/licenses/>  
 *
 *
 * Authors:
 *		Michael Zucchi <notzed@ximian.com>
 *
 * Copyright (C) 1999-2008 Novell, Inc. (www.novell.com)
 *
 */

/*
  Concrete class for formatting mails to html
*/

#ifndef _EM_FORMAT_WEBKIT_H
#define _EM_FORMAT_WEBKIT_H
#include "mail/em-format.h"

typedef struct _EMFormatWebKit EMFormatWebKit;
typedef struct _EMFormatWebKitClass EMFormatWebKitClass;

#if 0
struct _EMFormatWebKitHandler {
	EFrormatHandler base;
};
#endif

struct _CamelMimePart;
struct _CamelMedium;
struct _CamelStream;

typedef enum {
	WEB_BEGIN_KEEP_SCROLL = 1 << 0,
	WEB_BEGIN_KEEP_IMAGES = 1 << 1,
	WEB_BEGIN_BLOCK_UPDATES = 1 << 2,
	WEB_BEGIN_BLOCK_IMAGES = 1 << 3,
	/*enable autochange content_type*/
	WEB_BEGIN_CHANGECONTENTTYPE = 1 << 4
} WebBeginFlags;

enum _em_format_webkit_header_flags {
	EM_FORMAT_WEBKIT_HEADER_TO = 1<<0,
	EM_FORMAT_WEBKIT_HEADER_CC = 1<<1,
	EM_FORMAT_WEBKIT_HEADER_BCC = 1<<2,
};

typedef enum {
	EM_FORMAT_WEBKIT_STATE_NONE = 0,
	EM_FORMAT_WEBKIT_STATE_RENDERING
} EMFormatWebKitState;

/* A HTMLJob will be executed in another thread, in sequence,
   It's job is to write to its stream, close it if successful,
   then exit */

typedef struct _EMFormatWebKitJob EMFormatWebKitJob;

/**
 * struct _EMFormatWebKitJob - A formatting job.
 *
 * @next: Double linked list header.
 * @prev: Double linked list header.
 * @format: Set by allocation function.
 * @stream: Free for use by caller.
 * @puri_level: Set by allocation function.
 * @base: Set by allocation function, used to save state.
 * @callback: This callback will always be invoked, only once, even if the user
 * cancelled the display.  So the callback should free any extra data
 * it allocated every time it is called.
 * @u: Union data, free for caller to use.
 *
 * This object is used to queue a long-running-task which cannot be
 * processed in the primary thread.  When its turn comes, the job will
 * be de-queued and the @callback invoked to perform its processing,
 * restoring various state to match the original state.  This is used
 * for image loading and other internal tasks.
 *
 * This object is struct-subclassable.  Only em_format_webkit_job_new()
 * may be used to allocate these.
 **/
struct _EMFormatWebKitJob {
	struct _EMFormatWebKitJob *next;
	struct _EMFormatWebKitJob *prev;

	EMFormatWebKit *format;
	struct _CamelStream *stream;

	/* We need to track the state of the visibility tree at
	   the point this uri was generated */
	struct _EMFormatPURITree *puri_level;
	struct _CamelURL *base;

	void (*callback)(struct _EMFormatWebKitJob *job, int cancelled);
	union {
		char *uri;
		struct _CamelMedium *msg;
		EMFormatPURI *puri;
		struct _EMFormatPURITree *puri_level;
		void *data;
	} u;
};

/* Pending object (classid: url) */
typedef struct _EMFormatWebKitPObject EMFormatWebKitPObject;

typedef GtkWidget * (*EMFormatWebKitPObjectFunc)(EMFormatWebKit *md, GtkWidget *, EMFormatWebKitPObject *pobject);

/**
 * struct _EMFormatWebKitPObject - Pending object.
 *
 * @next: Double linked list header.
 * @prev: Double linked list header.
 * @free: Invoked when the object is no longer needed.
 * @format: The parent formatter.
 * @classid: The assigned class id as passed to add_pobject().
 * @func: Callback function.
 * @part: The part as passed to add_pobject().
 *
 * This structure is used to track OBJECT tags which have been
 * inserted into the HTML stream.  When HTML requests them the
 * @func will be invoked to create the embedded widget.
 *
 * This object is struct-subclassable.  Only
 * em_format_webkit_add_pobject() may be used to allocate these.
 **/
struct _EMFormatWebKitPObject {
	struct _EMFormatWebKitPObject *next;
	struct _EMFormatWebKitPObject *prev;

	void (*free)(struct _EMFormatWebKitPObject *);
	struct _EMFormatWebKit *format;
	/* <Priv>*/
	GtkWidget *body;
	GtkWidget *view;
	struct _CamelStream *stream;
	/* </Priv>*/
	char *classid;

	EMFormatWebKitPObjectFunc func;
	struct _CamelMimePart *part;
};

#define EM_FORMAT_WEBKIT_HEADER_NOCOLUMNS (EM_FORMAT_HEADER_LAST)
#define EM_FORMAT_WEBKIT_HEADER_HTML (EM_FORMAT_HEADER_LAST<<1) /* header already in html format */
#define EM_FORMAT_WEBKIT_HEADER_NODEC (EM_FORMAT_HEADER_LAST<<2) /* header already in html format */
#define EM_FORMAT_WEBKIT_HEADER_LAST (EM_FORMAT_HEADER_LAST<<8)

#define EM_FORMAT_WEBKIT_VPAD "<table cellspacing=0 cellpadding=3><tr><td><a name=\"padding\"></a></td></tr></table>\n"

/**
 * struct _EMFormatWebKit - HTML formatter object.
 *
 * @format:
 * @priv:
 * @html:
 * @pending_object_list:
 * @headers:
 * @text_html_flags:
 * @body_colour:
 * @header_colour:
 * @text_colour:
 * @frame_colour:
 * @content_colour:
 * @citation_colour:
 * @load_http:2:
 * @load_http_now:1:
 * @mark_citations:1:
 * @simple_headers:1:
 * @hide_headers:1:
 * @show_icon:1:
 *
 * Most of these fields are private or read-only.
 *
 * The base HTML formatter object.  This object drives HTML generation
 * into a WebKit parser.  It also handles text to HTML conversion,
 * multipart/related objects and inline images.
 **/
struct _EMFormatWebKit {
	EMFormat format;

	struct _EMFormatWebKitPrivate *priv;

	struct _MailMessageView *msg_view;
	GtkWidget *body;

	EDList pending_object_list;

	GSList *headers;

	guint32 text_html_flags; /* default flags for text to html conversion */
	guint32 body_colour;	/* header box colour */
	guint32 header_colour;
	guint32 text_colour;
	guint32 frame_colour;
	guint32 content_colour;
	guint32 citation_colour;
	unsigned int load_http:2;
	unsigned int load_http_now:1;
	unsigned int mark_citations:1;
	unsigned int simple_headers:1; /* simple header format, no box/table */
	unsigned int hide_headers:1; /* no headers at all */
	unsigned int show_icon:1; /* show an icon when the sender used Evo */
	guint32 header_wrap_flags;

	EMFormatWebKitState state; /* actual state of the object */
};

struct _EMFormatWebKitClass {
	EMFormatClass format_class;

};

GType em_format_webkit_get_type(void);
EMFormatWebKit *em_format_webkit_new(void);

void em_format_webkit_load_http(EMFormatWebKit *emf);

void em_format_webkit_set_load_http(EMFormatWebKit *emf, int style);
void em_format_webkit_set_mark_citations(EMFormatWebKit *emf, int state, guint32 citation_colour);

/* retrieves a pseudo-part icon wrapper for a file */
struct _CamelMimePart *em_format_webkit_file_part(EMFormatWebKit *efh, const char *mime_type, const char *filename);

/* for implementers */
EMFormatWebKitPObject *em_format_webkit_add_pobject(EMFormatWebKit *efh, size_t size, const char *classid, struct _CamelMimePart *part, EMFormatWebKitPObjectFunc func);
EMFormatWebKitPObject *em_format_webkit_find_pobject(EMFormatWebKit *emf, const char *classid);
EMFormatWebKitPObject *em_format_webkit_find_pobject_func(EMFormatWebKit *emf, struct _CamelMimePart *part, EMFormatWebKitPObjectFunc func);
void em_format_webkit_remove_pobject(EMFormatWebKit *emf, EMFormatWebKitPObject *pobject);
void em_format_webkit_clear_pobject(EMFormatWebKit *emf);

EMFormatWebKitJob *em_format_webkit_job_new(EMFormatWebKit *emfh, void (*callback)(struct _EMFormatWebKitJob *job, int cancelled), void *data)
;
void em_format_webkit_job_queue(EMFormatWebKit *emfh, struct _EMFormatWebKitJob *job);
void em_format_webkit_set_message_view (EMFormatWebKit *efw, struct _MailMessageView *mmv, GtkWidget *body);
#endif /* ! EM_FORMAT_WEBKIT_H */
