//
// This file is part of the aMule Project.
//
// Copyright (c) 2003-2008 aMule Team ( admin@amule.org / http://www.amule.org )
// Copyright (c) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// Any parts of this program derived from the xMule, lMule or eMule project,
// or contributed by third-party developers are copyrighted by their
// respective authors.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301, USA
//

#include "UploadQueue.h"	// Interface declarations

#include <protocol/Protocols.h>
#include <protocol/ed2k/Client2Client/TCP.h>
#include <common/Macros.h>
#include <common/Constants.h>

#include <cmath>

#include "Types.h"		// Do_not_auto_remove (win32)

#ifdef __WXMSW__
	#include <winsock.h>	// Do_not_auto_remove
#else
	#include <sys/types.h>	// Do_not_auto_remove
	#include <netinet/in.h>	// Do_not_auto_remove
	#include <arpa/inet.h>	// Do_not_auto_remove
#endif

#include "ServerConnect.h"	// Needed for CServerConnect
#include "KnownFile.h"		// Needed for CKnownFile
#include "Packet.h"		// Needed for CPacket
#include "ClientTCPSocket.h"	// Needed for CClientTCPSocket
#include "SharedFileList.h"	// Needed for CSharedFileList
#include "updownclient.h"	// Needed for CUpDownClient
#include "amule.h"		// Needed for theApp
#include "Preferences.h"
#include "ClientList.h"
#include "Statistics.h"		// Needed for theStats
#include "Logger.h"
#include <common/Format.h>
#include "UploadBandwidthThrottler.h"
#include "GuiEvents.h"		// Needed for Notify_*

// ADUNANZA BEGIN
#ifndef KADCONSTANTS_H
#include <protocol/kad/Constants.h>
#endif //KADCONSTANTS_H
// ADUNANZA END

//TODO rewrite the whole networkcode, use overlapped sockets

CUploadQueue::CUploadQueue()
{
	m_nLastStartUpload = 0;

	lastupslotHighID = true;
// ADUNANZA BEGIN
	// mod Adu
	// Emanem
	// Inizializzo il numero di clients Adu
	m_AduClientsNum = 0;
	// fine mod Adu
// ADUNANZA END
}


// Mr Hyde test
class CAduClientTypeChooser
{
	protected:
		uint32 m_current;

	private:
		inline void doswitch() { m_current = ((m_current == ADUNANZA_FASTWEB) ? ADUNANZA_EXTERN : ADUNANZA_FASTWEB); }

	protected:
		CAduClientTypeChooser() : m_current(ADUNANZA_EXTERN) {};
		~CAduClientTypeChooser() {};

		inline uint32 get() const {return m_current;}
		inline uint32 getNext() const { return ((m_current == ADUNANZA_FASTWEB) ? ADUNANZA_EXTERN : ADUNANZA_FASTWEB); }


		void advance(uint32 desired) {
			switch (desired)
			{
				case ADUNANZA_NONE:
					return;

				case ADUNANZA_ANY:
					return;

				default:
					doswitch();
					return;
			}
		}

		void setCurrent(const CUpDownClient* pCurrent)
		{
			if (!pCurrent) return;
			m_current = (pCurrent->IsAdunanzA() ? ADUNANZA_FASTWEB : ADUNANZA_EXTERN);
		}
};


// Mr Hyde: la patch oroginale prevedeva anche il parametro
//	 uint32 tC
// che pero' non era usato.
// Rimosso.
void CUploadQueue::AddUpNextClient(CUpDownClient* directadd)
{
	CClientPtrList::iterator toadd = m_waitinglist.end();
	CClientPtrList::iterator toaddlow = m_waitinglist.end();
	
	sint64	bestscore = -1;
	sint64	bestlowscore = -1;
// ADUNANZA BEGIN
	// Mod Adu
	// lupz
	// capisco cosa voglio
	// uint32 typeClient = AduNextClient();
	uint32 typeClient = theApp->pUploadSlotsMng->next();

	//AddDebugLogLineM(false, logClient, CFormat(wxT("voglio: %u")) % typeClient);
	if (typeClient == ADUNANZA_NONE)
	{
		// std::clog << "(Mr Hyde DBG) DISCARDING ALL!" << std::endl;
		return;
	}
	// Fine mod Adu

	// Mod Adu
	// Emanem
	// Forziamo che il rapporto 1:1 sia rispettato
	//if (thePrefs.m_AduForceExt11 &&
	//	ADUNANZA_FASTWEB == AduGetTypeBand(0) &&
	//	0 == m_AduClientsNum)

	// lupz: aggiorno alla nuova logica

	// lupz: sistemo anche il criterio
	// il vecchio criterio causava frequenti coda piena

	if (directadd) {
		/*
		if (directadd->IsAdunanzA())
		{
			std::cout << "Arrived ADUNANZA DIRECT" << std::endl;
		}
		else
			std::cout << "Arrived EXTERN DIRECT" << std::endl;
			*/
		switch(typeClient) {
			case ADUNANZA_FASTWEB:
				if (!directadd->IsAdunanzA()) // ADUFLAGS
				{
		// std::cout << "DISCARDING DIRECT NOT ADU" << std::endl;
					return;
				}
				break;
			case ADUNANZA_EXTERN:
				if (directadd->IsAdunanzA()) // ADUFLAGS
				{
		// std::cout << "DISCARDING DIRECT ADU" << std::endl;
					return;
				}
				break;
			default:
				break;
		}
	} else if (!directadd) {
			// std::cout << "NOT Direct" << std::endl;
		// mod Adu
		// Emanem
		// Risistemo il valore temporaneo del numero di clients
		// AdunanzA
		//uint32 _tmp_m_AduClientsNum = 0;
		// fine mod Adu
#if 0 // Mr Hyde per prova scema
		switch(typeClient) {
			case ADUNANZA_FASTWEB:
				if (!m_AduClientsNum)
					return;
				break;
			case ADUNANZA_EXTERN:
				if (m_AduClientsNum >= m_waitinglist.size())
					return;
				break;
			default:
				break;
		}
#endif
	}

	// fine mod Adu
// ADUNANZA END

	CUpDownClient* newclient;
	// select next client or use given client
	if (!directadd) {
// ADUNANZA BEGIN
		// mod Adu
		// Emanem
		// Risistemo il valore temporaneo del numero di clients
		// AdunanzA
		uint32 _tmp_m_AduClientsNum = 0;
		uint32 _bis_m_AduClientsNum = m_AduClientsNum;
		// fine mod Adu
// ADUNANZA END
		// Track if we purged any clients from the queue, as to only send one notify in total
		bool purged = false;
		
		CClientPtrList::iterator it = m_waitinglist.begin();
		for (; it != m_waitinglist.end(); ) {
			CClientPtrList::iterator tmp_it = it++;
			CUpDownClient* cur_client = *tmp_it;

			// clear dead clients
			if ( (::GetTickCount() - cur_client->GetLastUpRequest() > MAX_PURGEQUEUETIME) || !theApp->sharedfiles->GetFileByID(cur_client->GetUploadFileID()) ) {
				purged = true;
				cur_client->ClearWaitStartTime();
				RemoveFromWaitingQueue(tmp_it);
				if (!cur_client->GetSocket()) {
					if(cur_client->Disconnected(wxT("AddUpNextClient - purged"))) {
// ADUNANZA BEGIN
						if (cur_client->IsAdunanzA() && (_bis_m_AduClientsNum > 0)) _bis_m_AduClientsNum-- ; // Mr Hyde
// ADUNANZA END
						cur_client->Safe_Delete();
						cur_client = NULL;
					}
				}
				continue;
			} 

// ADUNANZA BEGIN
// Codice originale un po' strano: fa comunque il find e SOLO DOPO si chiede se cir_client e' banned e, in quel caso, salta al prox.
// Insomma, se cur_client e' banned perde IMHO tempo a fare un find inutile!			
#if 0
			suspendlist::iterator it2 = std::find( suspended_uploads_list.begin(),
			                                      suspended_uploads_list.end(),
			                                      cur_client->GetUploadFileID() );
			if (cur_client->IsBanned() || it2 != suspended_uploads_list.end() ) { // Banned client or suspended upload ?
			        continue;
			}
#else
			if (cur_client->IsBanned()) {
				if (cur_client->IsAdunanzA() && (_bis_m_AduClientsNum > 0)) _bis_m_AduClientsNum-- ; // Mr Hyde
			       	continue; // skip banned client
			}
			suspendlist::iterator it2 = std::find( suspended_uploads_list.begin(),
			                                      suspended_uploads_list.end(),
			                                      cur_client->GetUploadFileID() );
			if (it2 != suspended_uploads_list.end() ) { // current client is also a "suspended upload", skip it
				if (cur_client->IsAdunanzA() && (_bis_m_AduClientsNum > 0)) _bis_m_AduClientsNum-- ; // Mr Hyde
			        continue;
			}
#endif
			// a questo punto posso controllare, al momento, quanta roba ho in coda di attesa
			unsigned int theWaitSize = m_waitinglist.size();
// ADUNANZA END			

			// finished clearing
			
			sint64 cur_score = cur_client->GetScore(true);
// ADUNANZA BEGIN
			// Codice AdunanzA
			// Emanem	18:15	4/4/2004
			//
			// In questo caso, in base al tipo di typeClient
			// in input si sceglie su che clients fare la "classifica"
			/// di priorita'
			bool bIsCurrentAdunanzA(cur_client->IsAdunanzA());	
			// nel caso incremento il contatore temporaneo
			if (bIsCurrentAdunanzA) {// ADUFLAGS 
				_tmp_m_AduClientsNum++;
			}
			// Se il tipo di client non e' disponibile
			// allora prendo il primo che mi capita

			if (typeClient == ADUNANZA_FASTWEB)
			{
				// Mr Hyde: in realta' m_AduClientsNum lo stiamo ricalcolando proprio adesso!!!!
				// In questo modo mi baso sui risultati del giro precedente
				// if (m_AduClientsNum <= 0) typeClient = ADUNANZA_ANY;
				if (_bis_m_AduClientsNum == 0) typeClient = ADUNANZA_ANY;
				// if ((_tmp_m_AduClientsNum == 0) && (m_AduClientsNum == 0)) typeClient = ADUNANZA_ANY; // Mr Hyde Test
			} 
			else if (typeClient == ADUNANZA_EXTERN)
			{
				// Mr Hyde: in realta' m_AduClientsNum lo stiamo ricalcolando proprio adesso!!!!
				// In questo modo mi baso sui risultati del giro precedente
				// if (m_AduClientsNum >= theWaitSize) typeClient = ADUNANZA_ANY;
				if (_bis_m_AduClientsNum >= theWaitSize) typeClient = ADUNANZA_ANY;
				// if ((_tmp_m_AduClientsNum >= theWaitSize) || (m_AduClientsNum >= theWaitSize)) typeClient = ADUNANZA_ANY; // Mr Hyde Test
			}

			bool doit(false);
			switch(typeClient) {
				case ADUNANZA_EXTERN:
					doit = !bIsCurrentAdunanzA; // ADUFLAGS
					break;
				case ADUNANZA_FASTWEB:
					doit = bIsCurrentAdunanzA; // ADUFLAGS
					break;

				// Mr Hyde Test: in caso di ANY prendo il contrario del precedente (per alternare un po')	
				case ADUNANZA_ANY:
					doit = true;
					/*
					if (bIsCurrentAdunanzA)
						doit = (previousType == ADUNANZA_ANY) or (previousType == ADUNANZA_EXTERN);
					else
						doit = (previousType == ADUNANZA_ANY) or (previousType == ADUNANZA_FASTWEB);
					*/
					break;
				default:
					doit = false; // in questo caso non devo fare niente! (e' NONE)
					break;
			}

			if (doit) {
// ADUNANZA END
			if (cur_score > bestscore) {
				bestscore = cur_score;
				toadd = tmp_it;
			} else {
				cur_score = cur_client->GetScore(false);
				if ((cur_score > bestlowscore) && !cur_client->m_bAddNextConnect){
					bestlowscore = cur_score;
					toaddlow = tmp_it;
				}
			}
// ADUNANZA BEGIN			
			} // if (doit)
// ADUNANZA END
		}

// ADUNANZA BEGIN
		// mod Adu
		// Emanem
		// risistemo il numero di clients AdunanzA
		m_AduClientsNum = _tmp_m_AduClientsNum;
		// VOLUTO COMM m_AduClientsNum = _bis_m_AduClientsNum;
// ADUNANZA END

		// Update the count on GUI if any clients were purged
		if (purged) {
			Notify_ShowQueueCount(m_waitinglist.size());
		}

		if (bestlowscore > bestscore){
			newclient = *toaddlow;
			newclient->m_bAddNextConnect = true;
		}

		if (toadd == m_waitinglist.end()) {
			return;
		}
		
		newclient = *toadd;
		lastupslotHighID = true; // VQB LowID alternate
		RemoveFromWaitingQueue(toadd);
		Notify_ShowQueueCount(m_waitinglist.size());
	} else {
		//prevent another potential access of a suspended upload

		suspendlist::iterator it = std::find( suspended_uploads_list.begin(),
		                                      suspended_uploads_list.end(),
		                                      directadd->GetUploadFileID() );
		if ( it != suspended_uploads_list.end() ) {
			return;
		} else {
			newclient = directadd;
		}
	}

	if (IsDownloading(newclient)) {
		return;
	}
	// tell the client that we are now ready to upload
	if (!newclient->IsConnected()) {
		newclient->SetUploadState(US_CONNECTING);
		if (!newclient->TryToConnect(true)) {
			return;
		}
	} else {
		CPacket* packet = new CPacket(OP_ACCEPTUPLOADREQ, 0, OP_EDONKEYPROT);
		theStats::AddUpOverheadFileRequest(packet->GetPacketSize());
		AddDebugLogLineM( false, logLocalClient, wxT("Local Client: OP_ACCEPTUPLOADREQ to ") + newclient->GetFullIP() );
		newclient->SendPacket(packet,true);
		newclient->SetUploadState(US_UPLOADING);
	}
	newclient->SetUpStartTime();
	newclient->ResetSessionUp();

	theApp->uploadBandwidthThrottler->AddToStandardList(m_uploadinglist.size(), newclient->GetSocket());
	m_uploadinglist.push_back(newclient);
// ADUNANZA BEGIN
	// Mod Adu
	// lupz
	if (newclient->IsAdunanzA()) // ADUFLAGS
		aduuploadinglist.push_back(newclient);
	theApp->pUploadSlotsMng->consume(newclient); // Mr Hyde
	// Fine mod Adu
// ADUNANZA END
	theStats::AddUploadingClient();

	// Statistic
	CKnownFile* reqfile = (CKnownFile*) newclient->GetUploadFile();
	if (reqfile) {
		reqfile->statistic.AddAccepted();
	}
	Notify_UploadCtrlAddClient(newclient);

}

void CUploadQueue::Process()
{
// ADUNANZA BEGIN
#if 0
	if (AcceptNewClient() && !m_waitinglist.empty()) {
#endif
	// if ((AduNextClient() != ADUNANZA_NONE) && AcceptNewClient()  && !m_waitinglist.empty()) { 	
	theApp->pUploadSlotsMng->update(m_uploadinglist); // Mr Hyde test
	if (/*(theApp->pUploadSlotsMng->next() != ADUNANZA_NONE) &&*/ AcceptNewClient()  && !m_waitinglist.empty()) { 	
// ADUNANZA END
		m_nLastStartUpload = ::GetTickCount();
		AddUpNextClient();
	}

	// The loop that feeds the upload slots with data.
	CClientPtrList::iterator it = m_uploadinglist.begin();
// ADUNANZA BEGIN
	uint64 aduSentBytes      = 0;
       	uint64 fakeSentBytes     = 0;
       	uint64 aduFiberSentBytes = 0;
// ADUNANZA END
	while (it != m_uploadinglist.end()) {
		// Get the client. Note! Also updates pos as a side effect.
		CUpDownClient* cur_client = *it++;
		
		// It seems chatting or friend slots can get stuck at times in upload.. This needs looked into..
		if (!cur_client->GetSocket()) {
			RemoveFromUploadQueue(cur_client, true);
			if(cur_client->Disconnected(_T("CUploadQueue::Process"))){
				cur_client->Safe_Delete();
			}
		} else {
// ADUNANZA BEGIN
#if 0
			cur_client->SendBlockData();
#endif
			uint64 loc_sentBytes = cur_client->SendBlockData();

			if (cur_client->IsAdunanzA()) { // ADUFLAGS
				aduSentBytes += loc_sentBytes;
				if (cur_client->IsFastwebFiber()) // ADUFLAGS
					aduFiberSentBytes += loc_sentBytes;
			}
			fakeSentBytes += loc_sentBytes;
// ADUNANZA END
		}
	}

	// Save used bandwidth for speed calculations
	uint64 sentBytes = theApp->uploadBandwidthThrottler->GetNumberOfSentBytesSinceLastCallAndReset();
	(void)theApp->uploadBandwidthThrottler->GetNumberOfSentBytesOverheadSinceLastCallAndReset();

	// Update statistics
	if (sentBytes) {
// ADUNANZA BEGIN
#if 0
		theStats::AddSentBytes(sentBytes);
#endif
		theStats::AddSentBytes(fakeSentBytes,
		                       aduSentBytes,
		                       aduFiberSentBytes);
// ADUNANZA END

	}
}


bool CUploadQueue::AcceptNewClient()
{
	// check if we can allow a new client to start downloading from us
	if (::GetTickCount() - m_nLastStartUpload < 1000 || m_uploadinglist.size() >= MAX_UP_CLIENTS_ALLOWED) {
		return false;
	}

	float kBpsUpPerClient = (float)thePrefs::GetSlotAllocation();
	float kBpsUp = theStats::GetUploadRate() / 1024.0f;
	if (thePrefs::GetMaxUpload() == UNLIMITED) {
		if (m_uploadinglist.size() < ((uint32)((kBpsUp)/kBpsUpPerClient)+2)) {
			return true;
		}
	} else {
// ADUNANZA BEGIN
#if 0
		uint16 nMaxSlots = 0;
#endif
		uint16 nMaxSlots = AduGetMaxUploadSlots();
#if 0
// Codice rimosso
// ADUNANZA END
		if (thePrefs::GetMaxUpload() >= 10) {
			nMaxSlots = (uint16)floor((float)thePrefs::GetMaxUpload() / kBpsUpPerClient + 0.5);
				// floor(x + 0.5) is a way of doing round(x) that works with gcc < 3 ...
			if (nMaxSlots < MIN_UP_CLIENTS_ALLOWED) {
				nMaxSlots=MIN_UP_CLIENTS_ALLOWED;
			}
		} else {
			nMaxSlots = MIN_UP_CLIENTS_ALLOWED;
		}

// ADUNANZA BEGIN
#endif
// ADUNANZA END
		if (m_uploadinglist.size() < nMaxSlots) {
			return true;
		}
	}
	return false;
}

// ADUNANZA BEGIN
bool CUploadQueue::AcceptNewClient(bool isAduClient)
{

	// uint32 typeClient = AduNextClient();
	uint32 typeClient = theApp->pUploadSlotsMng->next();

	switch (typeClient) {
		case ADUNANZA_NONE:
			return false;
			break;
		case ADUNANZA_FASTWEB:
			if (!isAduClient)
				return false;
			break;
		case ADUNANZA_EXTERN:
			if (isAduClient)
				return false;
			break;

		default:
			break;
	}

	return AcceptNewClient();
}
// ADUNANZA END


CUploadQueue::~CUploadQueue()
{
	wxASSERT(m_waitinglist.empty());
	wxASSERT(m_uploadinglist.empty());
}


bool CUploadQueue::IsOnUploadQueue(const CUpDownClient* client) const
{
	return std::find(m_waitinglist.begin(), m_waitinglist.end(), client)
		!= m_waitinglist.end();
}


bool CUploadQueue::IsDownloading(CUpDownClient* client) const
{
	return std::find(m_uploadinglist.begin(), m_uploadinglist.end(), client)
		!= m_uploadinglist.end();
}	


CUpDownClient* CUploadQueue::GetWaitingClientByIP_UDP(uint32 dwIP, uint16 nUDPPort, bool bIgnorePortOnUniqueIP, bool* pbMultipleIPs)
{
	CUpDownClient* pMatchingIPClient = NULL;
	
	int cMatches = 0;
	
	CClientPtrList::iterator it = m_waitinglist.begin();
	for (; it != m_waitinglist.end(); ++it) {
		CUpDownClient* cur_client = *it;
		
		if ((dwIP == cur_client->GetIP()) && (nUDPPort == cur_client->GetUDPPort())) {
			return cur_client;
		} else if ((dwIP == cur_client->GetIP()) && bIgnorePortOnUniqueIP) {
			pMatchingIPClient = cur_client;
			cMatches++;
		}
	}

	if (pbMultipleIPs) {
		*pbMultipleIPs = cMatches > 1;
	}
	
	if (pMatchingIPClient && cMatches == 1) {
		return pMatchingIPClient;	
	} else {
		return NULL;
	}
}


void CUploadQueue::AddClientToQueue(CUpDownClient* client)
{
// ADUNANZA BEGIN
// Mod Adu
// Emanem
// Questa mod serve a supportare piu' di 50 clients se
// connessi con un low-id
#if 0
	if (theApp->serverconnect->IsConnected() && theApp->serverconnect->IsLowID() && !theApp->serverconnect->IsLocalServer(client->GetServerIP(),client->GetServerPort()) && client->GetDownloadState() == DS_NONE && !client->IsFriend() && theStats::GetWaitingUserCount() > 50) {
#endif
	if (theApp->serverconnect->IsConnected() &&
	    (theApp->serverconnect->IsLowID()) &&
	    !theApp->serverconnect->IsLocalServer(client->GetServerIP(),client->GetServerPort()) &&
	    (client->GetDownloadState() == DS_NONE) &&
	    !client->IsFriend() && 
	    (theStats::GetWaitingUserCount() > theApp->glob_prefs->GetQueueSize()) ) {
		// Well, all that issues finish in the same: don't allow to add to the queue
		return;
	}

	// fine mod Adu
// ADUNANZA END

	if ( client->IsBanned() ) {
		return;
	}

	client->AddAskedCount();
	client->SetLastUpRequest();

	// Find all clients with the same user-hash
	CClientList::SourceList found = theApp->clientlist->GetClientsByHash( client->GetUserHash() );

	CClientList::SourceList::iterator it = found.begin();
	while (it != found.end()) {
		CUpDownClient* cur_client = *it++;
		
		if ( IsOnUploadQueue( cur_client ) ) {
			if ( cur_client == client ) {
// ADUNANZA BEGIN
				// Stefano Picerno: aggiunto && (uploadinglist.GetCount() < AduGetMaxUploadSlots())
#if 0
				if ( client->m_bAddNextConnect && ( ( m_uploadinglist.size() < thePrefs::GetMaxUpload() ) || ( thePrefs::GetMaxUpload() == UNLIMITED ) ) ) {
#endif
				//AddDebugLogLineM(false, logClient, CFormat(wxT("in up: %u massimi: %u")) % (uint32)uploadinglist.GetCount() % AduGetMaxUploadSlots());

				if ( client->m_bAddNextConnect && ( ( m_uploadinglist.size() < thePrefs::GetMaxUpload() ) || ( thePrefs::GetMaxUpload() == UNLIMITED ) ) && (m_uploadinglist.size() < AduGetMaxUploadSlots()) ) {
// ADUNANZA END
					if (lastupslotHighID) {
						client->m_bAddNextConnect = false;
						RemoveFromWaitingQueue(client, true);
						AddUpNextClient(client);
						lastupslotHighID = false; // LowID alternate
						return;
					}
				}

				client->SendRankingInfo();
				Notify_QlistRefreshClient(client);
				return;

			} else {
				// Hash-clash, remove unidentified clients (possibly both)
				
				if ( !cur_client->IsIdentified() ) {
					// Cur_client isn't identifed, remove it
					theApp->clientlist->AddTrackClient( cur_client );

					RemoveFromWaitingQueue( cur_client );
					if ( !cur_client->GetSocket() ) {
						if (cur_client->Disconnected( wxT("AddClientToQueue - same userhash") ) ) {
							cur_client->Safe_Delete();
						}
					}
				}

				if ( !client->IsIdentified() ) {
					// New client isn't identified, remove it
					theApp->clientlist->AddTrackClient( client );

					if ( !client->GetSocket() ) {
						if ( client->Disconnected( wxT("AddClientToQueue - same userhash") ) ) {
							client->Safe_Delete();
						}
					}

					return;
				}
			}
		}
	}

	// Count the number of clients with the same IP-address
	found = theApp->clientlist->GetClientsByIP( client->GetIP() );

	int ipCount = 0;
	for ( it = found.begin(); it != found.end(); it++ ) {
		if ( ( *it == client ) || IsOnUploadQueue( *it ) ) {
			ipCount++;
		}
	}

	// We do not accept more than 3 clients from the same IP
	if ( ipCount > 3 ) {
		return;
	} else if ( theApp->clientlist->GetClientsFromIP(client->GetIP()) >= 3 ) {
		return;
	}

	// statistic values
	CKnownFile* reqfile = (CKnownFile*) client->GetUploadFile();
	if (reqfile) {
		reqfile->statistic.AddRequest();
	}

	// TODO find better ways to cap the list
	if (m_waitinglist.size() >= (thePrefs::GetQueueSize())) {
		return;
	}

	if (client->IsDownloading()) {
		// he's already downloading and wants probably only another file
		CPacket* packet = new CPacket(OP_ACCEPTUPLOADREQ, 0, OP_EDONKEYPROT);
		theStats::AddUpOverheadFileRequest(packet->GetPacketSize());
		AddDebugLogLineM( false, logLocalClient, wxT("Local Client: OP_ACCEPTUPLOADREQ to ") + client->GetFullIP() );
		client->SendPacket(packet,true);
		return;
	}

// ADUNANZA BEGIN
#if 0
	if (m_waitinglist.empty() && AcceptNewClient()) {
#endif
	// if (m_waitinglist.empty() && AcceptNewClient(client->IsAdunanzA())) { // ADUFLAGS
	// Mr Hyde: secondo me qui non e' corretto chiedersi se e' AdunanzA:
	// ce gia' chi processa la coda che fa la distinzione!
	if (m_waitinglist.empty() && AcceptNewClient()) { // ADUFLAGS
// ADUNANZA END
		AddUpNextClient(client);
		m_nLastStartUpload = ::GetTickCount();
	} else {
		m_waitinglist.push_back(client);
		theStats::AddWaitingClient();
		client->ClearWaitStartTime();
		client->ClearAskedCount();
// ADUNANZA BEGIN
		// mod Adu
		// Emanem
		// se un client e' Adu incremento il conteggio
		if (client->IsAdunanzA())  // ADUFLAGS
			m_AduClientsNum++;
		// fine mod Adu
// ADUNANZA END
		client->SetUploadState(US_ONUPLOADQUEUE);
		client->SendRankingInfo();
		Notify_QlistAddClient(client);
		Notify_ShowQueueCount(m_waitinglist.size());
	}
}


bool CUploadQueue::RemoveFromUploadQueue(CUpDownClient* client, bool updatewindow)
{
	// Keep track of this client
	theApp->clientlist->AddTrackClient(client);
	
	CClientPtrList::iterator it = std::find(m_uploadinglist.begin(),
			m_uploadinglist.end(), client);
	
	if (it != m_uploadinglist.end()) {
		if (updatewindow) {
			Notify_UploadCtrlRemoveClient(client);
		}
		m_uploadinglist.erase(it);
// ADUNANZA BEGIN
		// Mod Adu
		// lupz
		CClientPtrList::iterator adu_it = std::find(aduuploadinglist.begin(), aduuploadinglist.end(), client);

		if (adu_it != aduuploadinglist.end())
			aduuploadinglist.erase(adu_it);
		// Fine mod Adu
// ADUNANZA END
		theStats::RemoveUploadingClient();
		if( client->GetTransferredUp() ) {
			theStats::AddSuccessfulUpload();
			theStats::AddUploadTime(client->GetUpStartTimeDelay() / 1000);
		} else {
			theStats::AddFailedUpload();
		}
		client->SetUploadState(US_NONE);
		client->ClearUploadBlockRequests();
		return true;
	}

	return false;
}


bool CUploadQueue::CheckForTimeOver(CUpDownClient* client)
{
// ADUNANZA BEGIN
#if 0
	if (thePrefs::TransferFullChunks()) {
		if( client->GetUpStartTimeDelay() > 3600000 ) { // Try to keep the clients from downloading forever.
			return true;
		}
		// For some reason, some clients can continue to download after a chunk size.
		// Are they redownloading the same chunk over and over????
		if( client->GetSessionUp() > 10485760 ) {
			return true;
		}
	} else {
		CClientPtrList::iterator it = m_waitinglist.begin();
		for (; it != m_waitinglist.end(); ++it ) {
			if (client->GetScore(true,true) < (*it)->GetScore(true,false)) {
				return true;
			}
		}
	}
	
	return false;
#endif
	// Mod Adu
	// Emanem
	// Se il client e' AdunanzA lo si lascia connesso
	// al max per 1 ora. Se e' esterno al max per
	// 10 minuti.
	if ( client && client->IsAdunanzA() ) // ADUFLAGS
	{
		if( client->GetUpStartTimeDelay() > SESSIONMAXTIME ){ // Try to keep the clients from downloading for ever.
			if (thePrefs::GetVerbose())
				AddDebugLogLineM(false, logClient, wxString::Format(_("%s: Upload session ended due to max time %s."), client->GetUserName().c_str(), CastSecondsToHM(SESSIONMAXTIME/1000).c_str() ));
			return true;
		}
	}
	else
	{
		if( client->GetUpStartTimeDelay() > MIN2MS(10) ) { // Try to keep the clients from downloading for ever.
			return true;
		}
	}
	// Fine mod Adu

	if (thePrefs::TransferFullChunks()) {
		// Allow the client to download a specified amount per session
		if ( client->IsAdunanzA() ) // ADUFLAGS
		{
			/* Kaiser -- 08/04/2004 - 15.43
			   Se e' un ext lo "stacca" dopo SESSIONMAXTRANS (9,3mb) altrimenti cerca
			   di staccarlo dopo ADU_SESSIONMAXTRANS (18,6mb) ovvero il doppio.
			   In questo modo possiamo favorire lo scambio tra aduner senza dover 
			   modificare i tempi di reask e rischiando quindi meno ban! */
			if( client->GetQueueSessionPayloadUp() > ADU_SESSIONMAXTRANS){
				// Inoltre se la prossima slot deve essere AdunanzA e non ho altri Adu in coda
				// non lo butto giu' per poi riprenderlo in coda di upload.
				// Quindi se la prossima slot e' non adunanza lo butto giu'.
				// Condizioni sufficienti per buttare giu' un client sono:
				// - Avere altri Adu in coda di attesa
				// - Che il prossimo client non sia Adu
				if ((theApp->uploadqueue->GetAdunanzAUserCount() > 0) || (ADUNANZA_FASTWEB != AduGetTypeBand()))
				{
					if (thePrefs::GetVerbose())
						AddDebugLogLineM(false, logClient,  wxString::Format(_("%s: Upload session ended due to max transfered amount. %s"), client->GetUserName().c_str(), CastItoXBytes((uint64) ADU_SESSIONMAXTRANS).c_str() ) );
					return true;
				}
			}
		}
		else
		{
			if( (client->GetQueueSessionPayloadUp() > SESSIONMAXTRANS) || AduMaxTrans() ){
				if (thePrefs::GetVerbose())
					AddDebugLogLineM(false, logClient, wxString::Format(_("%s: Upload session ended due to max transfered amount. %s"), client->GetUserName().c_str(), CastItoXBytes((uint64)SESSIONMAXTRANS).c_str() ));
				return true;
			}
		}
	} else {
		// Stefano Picerno: emule adunanza usa sempre TransferFullChunks = true !!!!!
		AddDebugLogLineM(false, logGeneral, _("ERROR: aMule AdunanzA assumes that TransferFullChunks is TRUE, but now it's false !!!." ) );
		// Fine modifica
	}
	
	return false;
// ADUNANZA END
}


uint16 CUploadQueue::GetWaitingPosition(const CUpDownClient *client) const
{
	if ( !IsOnUploadQueue(client) ) {
		return 0;
	}

	uint16 rank = 1;
	const uint32 myscore = client->GetScore(false);
	CClientPtrList::const_iterator it = m_waitinglist.begin();
	for (; it != m_waitinglist.end(); ++it) {
		if ((*it)->GetScore(false) > myscore) {
			rank++;
		}
	}
	
	return rank;
}


/*
 * This function removes a file indicated by filehash from suspended_uploads_list.
 */
void CUploadQueue::ResumeUpload( const CMD4Hash& filehash )
{
	//Find the position of the filehash in the list and remove it.
	suspendlist::iterator it = std::find( suspended_uploads_list.begin(), 
			                              suspended_uploads_list.end(),
			                              filehash );
	if ( it != suspended_uploads_list.end() )
		suspended_uploads_list.erase( it );
	
	AddLogLineM( false, CFormat( _("Resuming uploads of file: %s" ) )
				% filehash.Encode() );
}

/*
 * This function adds a file indicated by filehash to suspended_uploads_list
 */
void CUploadQueue::SuspendUpload( const CMD4Hash& filehash )
{
	AddLogLineM( false, CFormat( _("Suspending upload of file: %s" ) )
				% filehash.Encode() );

	//Append the filehash to the list.
	suspended_uploads_list.push_back(filehash);
	wxString base16hash = filehash.Encode();

	CClientPtrList::iterator it = m_uploadinglist.begin();
	while (it != m_uploadinglist.end()) {
		CUpDownClient *potential = *it++;
		//check if the client is uploading the file we need to suspend
		if(potential->GetUploadFileID() == filehash) {
			//remove the unlucky client from the upload queue and add to the waiting queue
			RemoveFromUploadQueue(potential, true);

			m_waitinglist.push_back(potential);
			theStats::AddWaitingClient();
			potential->SetUploadState(US_ONUPLOADQUEUE);
			potential->SendRankingInfo();
			Notify_QlistRefreshClient(potential);
			Notify_ShowQueueCount(m_waitinglist.size());
		}
	}
}

bool CUploadQueue::RemoveFromWaitingQueue(CUpDownClient* client, bool updatewindow)
{
	CClientPtrList::iterator it = std::find(m_waitinglist.begin(),
			m_waitinglist.end(), client);
	
	if (it != m_waitinglist.end()) {
		RemoveFromWaitingQueue(it);
		if (updatewindow) {
			Notify_ShowQueueCount(m_waitinglist.size());
		}
		return true;
	} else {
		return false;
	}
}


void CUploadQueue::RemoveFromWaitingQueue(CClientPtrList::iterator pos)
{
	CUpDownClient* todelete = *pos;
// ADUNANZA BEGIN
	// mod Adu
	// Emanem
	// se il client era adu decremento il contatore
	if (todelete && todelete->IsAdunanzA() && m_AduClientsNum)  // ADUFLAGS
		m_AduClientsNum--;
	// fine mod Adu
// ADUNANZA END
	m_waitinglist.erase(pos);
	theStats::RemoveWaitingClient();
	if( todelete->IsBanned() ) {
		todelete->UnBan();
	}
	Notify_QlistRemoveClient(todelete);
	todelete->SetUploadState(US_NONE);
}

// File_checked_for_headers
