<?xml version="1.0" encoding="iso-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN"
      "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
  <meta http-equiv="content-type" content="text/html; charset=iso-8859-1" />
  <title>Amaya - Guide utilisateur</title>
  <style type="text/css">

.xml {color: #E50000}
.exercice {color: #A9B200}
h1 {color: #FFFFFF; background-color: #7995B6; padding: 5px 1px}
address {margin-bottom: 30px}
body {background-color: #F9F7F4; color: #666666; font-family: helvetica; }
.author {font-style: italic; font-weight: bold}
.head {margin: 1em 0 3em 0}
h1 {font-size: 24pt}
body {padding-left: 2em}</style>
  <meta name="generator" content="amaya 9.1.1, see http://www.w3.org/Amaya/"
  />
</head>

<body xml:lang="fr">

<div class="head">
<h1 id="Amaya">Amaya - Guide utilisateur</h1>

<p class="head"><span class="author">Irne Vatton</span> <br />
Dernire mise  jour: <!--$date=-->2007-04-27<!--$-->
 </p>
</div>

<p>Ce document a pour but d'aider les nouveaux utilisateurs d'Amaya. Pour
plus de dtail sur l'interface, il faut se reporter au <a
href="Manual.html.fr">manuel de rfrence</a>.</p>

<div>
<h3 id="Plan">Plan</h3>
<ol>
  <li><a href="#L271">Prsentation gnrale d'Amaya</a></li>
  <li><a href="#L483">Paramtrage de l'application</a></li>
  <li><a href="#L608">Cration/Edition d'une page Web</a></li>
  <li><a href="#L662">Cration du contenu (paragraphes, en-ttes de sections,
    divisions)</a></li>
  <li><a href="#L831">Le listes</a></li>
  <li><a href="#L1002">Les liens</a></li>
  <li><a href="#L11631">Mises en vidence du texte</a></li>
  <li><a href="#L12061">Les tables</a></li>
  <li><a href="#L12281">Recherche/Remplacement - Correction
  orthographique</a></li>
  <li><a href="#L1230">Attributs</a></li>
  <li><a href="#L1232">Cration de feuilles de style CSS</a></li>
  <li><a href="#L1242">Dtection des erreurs</a></li>
</ol>
</div>

<div>
<h2 id="L85">1. Introduction</h2>

<p>L'objectif du Web est de permettre l'change d'informations quel que soit
le support. XHTML et d'autres langages XML (MathML pour les formules
mathmatiques, SVG pour les graphiques vectoriels) dfinissent des formats
standard qui permettent le partage de l'information par un grand nombre
d'outils (navigateurs, mail, etc.).</p>

<p>CSS (Cascading Style Sheets) est un langage de prsentation qui accompagne
HTML et XML et permet la sparation entre la structure avec son contenu d'une
part et la prsentation d'autre part. L'auteur d'un document Web peut, s'il
le dsire, uniquement se concenter sur l'organisation de son document
(titres, paragraphes, listes, contenu). Ultrieurement une autre personne
peut prendre en charge sa prsentation (choix des couleurs, des polices de
caractres, du formattage).</p>

<p>XHTML dfinit une structure (organisation) de document.</p>
<ul>
  <li><strong>Elements</strong> : Ils permettent de dcouper le document en
    composants pour reflter son organisation. Pour faciliter la perception
    de ces lments les navigateurs leur associent un rendu par dfaut. 
    <p>Par exemple un h2 dfinit un en-tte moins important qu'un h1 et plus
    important qu'un h3. Les navigateurs le prsentent par dfaut avec une
    taille de caractres plus petite qu'un h1 et plus grosse qu'un h3.</p>
  </li>
  <li><strong>Attributs</strong> : Ce sont des caractristiques ajoutes aux
    lments 
    <p>Par exemple l'attribut class="section" ou class="sous-section"sur un
    lment division permet de distinguer les divisions du document.</p>
    <p>De mme l'attribut href="http://www.w3.org/" sur un lment ancre
    dfinit la cible du lien.</p>
  </li>
</ul>
</div>

<div>
<h2 id="L271">2. Prsentation gnrale d'Amaya</h2>

<p><strong>Amaya</strong> est un diteur spcifique pour crer et modifier
des documents utilisant les formats du Web (XHTML, XML et CSS). Il est dot
de capacits de navigation. C'est  dire que pendant que l'utilisateur
travaille sur un document, il peut accder n'importe quel autre document
Web.</p>

<p>Lorsqu'il est utilis comme navigateur, Amaya se comporte comme beaucoup
d'autres navigateurs Web, except pour l'activation des liens. Par dfaut le
simple clic est utilis pour poser la slection (dfinir le point d'insertion
de texte) et il faut effectuer un double-clic sur un lien pour l'activer.
Amaya n'a pas de support pour les langages de script.</p>

<h3 id="barre">La barre de menu</h3>
<ul>
  <li>Fichier: cration de documents, navigation, impression, fermeture.</li>
  <li>Edition: dition de base, recherche/remplacement, correction
    orthographique, paramtrage (menu Amaya sous Mac OSX).</li>
  <li>XHTML : cration/remplacement d'lments (X)HTML.</li>
  <li>XML : cration d'lments XML.</li>
  <li>Liens : cration et destruction des liens.</li>
  <li>Vues : gestion des diffrentes vues du document.</li>
  <li>Style : gestion du style CSS.</li>
  <li>Annotations : cration, destruction d'annotations.</li>
  <li>Aide : donne accs au manuel en ligne.</li>
</ul>

<h3 id="barre1">La barre de boutons</h3>

<p>Elle contient quelques boutons d'accs aux fonctions les plus utilises</p>
<ul>
  <li>Document prcdent <img alt="(Prcdent)"
    src="../../resources/icons/22x22/back.png" />: retour au document
    prcdent (s'il y en a un)</li>
  <li>Document suivant <img alt="(Suivant)"
    src="../../resources/icons/22x22/forward.png" />: retour au document
    suivant (s'il y en a un)</li>
  <li>Recharger<img alt="(Recharger)"
    src="../../resources/icons/22x22/reload.png" /> : recharge le document
    (accs serveur)</li>
  <li>Stop <img alt="(Stop)" src="../../resources/icons/22x22/stop.png" />:
    arrte le transfert d'information depuis un serveur Web</li>
  <li>Page personnelle <img alt="(Home)"
    src="../../resources/icons/22x22/home.png" />: affiche la page de
    dmarrage</li>
  <li>Crer un nouveau document <img alt="(Nouveau)"
    src="../../resources/icons/22x22/new.png" />: active le formulaire de
    cration de document</li>
  <li>Ouvrir un document <img alt="(Ouvrir)"
    src="../../resources/icons/22x22/open.png" />: active le formulaire
    d'ouverture de document</li>
  <li>Enregistrer <img alt="(Enregistrer)" src="../../resources/icons/22x22/save.png"
    />: sauver les modifications</li>
  <li>Imprimer <img alt="(Imprimer)"
    src="../../resources/icons/22x22/print.png" />: imprime le document</li>
  <li>Rechercher/Remplacer <img alt="(Rechercher)"
    src="../../resources/icons/22x22/find.png" />: affiche un formulaire de
    recherche/remplacement de texte</li>
  <li>Styler <img alt="(Style CSS)"
    src="../../resources/icons/22x22/colorize.png" />: affiche le formulaire
    d'dition de style CSS</li>
</ul>

<h3 id="outils">Les outils</h3>

<p>Amaya prsente sur la gauche une sous-fentre d'outils. Cette sous-fentre
peut tre ouverte ou ferme par l'utilisateur, (1) soit en double-cliquant
sur la barre active (Montrer/cacher les outils) situe  gauche, (2) soit 
l'aide du menu Vue.</p>

<p>Chaque outil peut tre ouvert et ferm  la demande (bouton  gauche du
titre), ou bien dtach et rattach (bouton  droite du titre).</p>
<dl>
  <dt>Un outil pour faciliter l'accs aux fichiers locaux</dt>
    <dd>Un clic sur l'icne devant le nom du rpertoire permet d'ouvrir et de
      fermer le rpertoire 
      <p>Un double-clic sur un nom de fichier permet d'ouvrir le fichier dans
      un onglet d'Amaya</p>
    </dd>
  <dt>Un outil pour crer les lments XHTML les plus utiliss</dt>
    <dd><ul>
        <li>soit insrer un lment XHTML: division (<img
          alt="Bouton Division"
          src="../../resources/icons/16x16/XHTML_Div.png" /> ), titres (<img
          alt="Bouton Titre niveau 1"
          src="../../resources/icons/16x16/XHTML_H1.png" /> ,<img
          alt="Bouton Titre niveau 2"
          src="../../resources/icons/16x16/XHTML_H2.png" /> ,<img
          alt="Bouton Titre niveau 3"
          src="../../resources/icons/16x16/XHTML_H3.png" /> ), table (<img
          alt="Bouton Table"
          src="../../resources/icons/16x16/XHTML_Table.png" /> ), ancre cible
          ou element cible (<img alt="Bouton Cible"
          src="../../resources/icons/16x16/XHTML_Target.png" /> ), ancre lien
          (<img alt="Bouton Lien"
          src="../../resources/icons/16x16/XHTML_Link.png" /> ), liste (<img
          alt="Bouton Liste"
          src="../../resources/icons/16x16/XHTML_Bullet.png" /> ), liste
          numrote (<img alt="Bouton Liste numrote"
          src="../../resources/icons/16x16/XHTML_Num.png" /> ), liste de
          dfinitions (<img alt="Bouton Liste de dfinitions"
          src="../../resources/icons/16x16/XHTML_DL.png" /> ), terme de
          dfinition (<img alt="Bouton Terme"
          src="../../resources/icons/16x16/XHTML_DT.png" /> ), dfinition
          (<img alt="Bouton Dfinition"
          src="../../resources/icons/16x16/XHTML_DD.png" /> ), image (<img
          alt="Bouton Image"
          src="../../resources/icons/16x16/XHTML_Image.png" /> ), objet (<img
          alt="Bouton Objet"
          src="../../resources/icons/16x16/XHTML_object.png" /> ).</li>
        <li>soit ouvrir/fermer un lment <em>inline</em> de XHTML: <em>mise
          en vidence</em> (<img
          src="../../resources/icons/16x16/XHTML_I.png"
          alt="Bouton Mise en evidence" /> ), <strong>important</strong>
          (<img src="../../resources/icons/16x16/XHTML_B.png"
          alt="Bouton Important" /> ) <code>code</code> (<img
          src="../../resources/icons/16x16/XHTML_T.png" alt="Bouton Code" />
          ), <ins>insertion</ins> (<img alt="Bouton Insertion"
          src="../../resources/icons/16x16/XHTML_ins.png" /> ), and
          <del>suppression</del> (<img alt="Bouton Suppression"
          src="../../resources/icons/16x16/XHTML_del.png" /> ),
          <sup>exposant</sup> (<img alt="Bouton Exposant"
          src="../../resources/icons/16x16/XHTML_sup.png" /> ), and
          <sub>indice</sub> (<img alt="Bouton Indice"
          src="../../resources/icons/16x16/XHTML_sub.png" /> ).</li>
      </ul>
    </dd>
  <dt>Un outil pour manipuler les attributs</dt>
    <dd>Cette liste des attributs est mise  jour en fonction de la
      slection. 
      <ul>
        <li>une croix [x] prcde les attributs activs.</li>
        <li>un clic sur [ ] active ou dsactive l'attribut</li>
        <li>un clic sur un nom d'attribut permet de visualiser et d'diter la
          valeur de cet attribut</li>
      </ul>
    </dd>
  <dt>Un outil pour manipuler les classes</dt>
    <dd>Cette liste prsente les classes dfinies soit dans le document, soit
      dans les feuilles de style appliques au document.</dd>
  <dt>Un outil pour crer les Maths</dt>
    <dd>Plus de 100 constructions mathmatiques sont prdfinies. Un simple
      clic sur un bouton permet d'insrer la construction mathmatique
      correspondante. Les boutons utilisent la convention de couleur
      suivante: (bleu) quand un formulaire permet de paramtrer la
      construction, (rouge) pour indiquer la partie variable de la
      construction, (vert) pour les informations complmentaires non
      reproduites dans la construction.</dd>
  <dt>Un outil pour insrer des caractres spciaux</dt>
    <dd>Plusieurs listes de caractres spciaux sont proposes. Un clic sur
      un des onglets active la liste correspondante. Une fois le bon
      caractre choisi dans la liste, il vous suffit de cliquer sur le bouton
      <img alt="bouton insrer"
      src="../../resources/icons/16x16/MATHML_insert.png" width="16"
      height="16" /> pour l'insrer.</dd>
  <dt>Un outil pour crer les lments XML</dt>
</dl>
</div>

<div>
<h2 id="L483">3. Paramtrage de l'application</h2>

<p>Voici les paramtres importants  rgler:</p>

<h4 id="Dans">Dans les prfrences gnrales</h4>
<ul>
  <li><strong>Page de dmarrage</strong>: Spcifie l'URI qu'Amaya chargera
    au dmarrage ou quand l'utilisateur pressera le bouton <img
    alt="(Page personelle)" src="../../resources/icons/22x22/home.png" />
    (par exemple l'URI <code>http://www.w3.org</code>).</li>
  <li><strong><a id="Enable">Activer le coller ligne  ligne</a></strong>:
    Cette option concerne le coller depuis une autre application. Quand cette
    option est active, les lignes de l'application source sont conserves.
    Sinon les caractres fin de ligne sont remplacs par des espaces.</li>
  <li><strong>Produire des fichiers de sauvegarde</strong>: Si cette option
    est active Amaya va produire priodiquement un fichier de sauvegarde pour
    chaque document dit.</li>
  <li><strong>Montrer les cibles</strong>: Contrle si les cibles de liens
    sont visualises ou non. Montrer les cibles peut aider quand on veut
    crer de nouveaux liens. Cette option agit immdiatement sur tous les
    documents dits.<br />
  </li>
  <li><strong>Zoom caractres</strong>: Cette option vous permet de rduire
    ou d'augmenter les tailles des polices de caractres utilises. Cette
    option a un effet immdiat sur tous les documents dits. <br />
  </li>
  <li><strong>Langue du dialogue</strong>: Spcifie la langue utilise dans
    les menus et les messages. La langue par dfaut est celle du systme.
    D'autres langues sont possibles comme le franais (fr), l'italien (it),
    l'espagnol (es), et l'allemand (de).</li>
</ul>

<h4 id="Dans1">Dans les prfrences de navigation</h4>
<ul>
  <li><strong>Charger les images</strong> : Contrle si les images doivent
    tre charges et affiches. Sinon, l'attribut ALT est visualis  la
    place de l'image. Cette option prend effet ds que le formulaire est
    valid. <br />
  </li>
  <li><strong>Charger les objets</strong> : Contrle si les objets doivent
    tre chargs et affichs. Sinon, le contenu de l'objet est visualis  la
    place de l'objet. Cette option prend effet ds que le formulaire est
    valid.</li>
  <li><strong>Montrer les images de fond</strong> : Contrle si les images en
    arrire plan doivent tre montres ou non. Cette option prend effet ds
    que le formulaire est valid.</li>
  <li><strong>Le double clic active les liens</strong> : Depuis la premire
    version d'Amaya, les utilisateurs ont besoin de double cliquer sur un
    lien pour l'activer. Cela permet de diffrencier l'dition d'un lien de
    son activation. Vous pouvez changer ce comportement en dsactivant cette
    option.<br />
  </li>
</ul>
</div>

<div>
<h2 id="L608">4. Cration/Edition d'une page Web</h2>

<p>L'entre <strong>Fichier/Nouveau</strong> permet de crer un nouveau
document d'un type donn. Amaya demande de spcifier l'URI ou le nom local du
document  crer (un nom par dfaut est gnr). Aprs confirmation, Amaya
ouvre un nouveau document vide.</p>

<p>L'entre <strong>Fichier/Ouvrir</strong> remplace le document affich.
Amaya utilise la mme entre de menu par le nouveau document slectionn.
Amaya utilise la mme entre de menu pour ouvrir un document local ou un
document d'un serveur Web.</p>

<p>Les entres du menu XHTML prsentent les lments que l'on peut insrer
dans le document affich, en fonction de la famille XHTML choisie. La manire
la plus simple de crer de nouveaux lments dans un document est de placer
le point d'insertion dans la position voulue et d'utiliser le menu
<strong>XHTML</strong>, ou la barre d'outil pour les lments les plus
communs (images, en-ttes, listes...).</p>

<p>Ces boutons ou entres de menu crent l'lment correspondant  la
position courante. Si l'lment dsir ne peut pas tre cr exactement  la
position choisie. Amaya tente alors de crer l'lment  l'endroit le plus
proche possible.</p>

<h3 id="L496">Dfinir le titre du document</h3>

<p>Par dfaut Amaya donne le titre "No title" au document nouvellement cr
parce que cet lment est obligatoire. Il ne faut pas oublier de mettre 
jour ce titre en activant l'entre <strong>XHTML/Changer le
titre</strong>.</p>

<h3 id="L503">Dfinir la langue utilise</h3>

<p>Il est important de dfinir la langue dans laquelle est crit le document.
Sans indication explicite, le document est suppos crit en anglais. La
langue est utilise par le correcteur orthographique.</p>

<p>Pour dfinir qu'un document est crit franais, il faut slectionner
l'lment &lt;body&gt; et lui appliquer l'attribut lang=fr (voir les
attributs dans les outils).</p>

<h4 id="Premi">Premire mthode</h4>

<p>On pose la slection n'importe o dans le document et on utilise la touche
<kbd>F2</kbd> pour remonter la slection sur l'lment &lt;body&gt;. La barre
de statut affiche l'lment slectionn. A ce moment l on slectionne
l'entre langue de l'outil <strong>Attributs</strong> pour afficher le
formulaire de choix de la langue.</p>

<h4 id="Deuxi">Deuxime mthode</h4>

<p>On ouvre la vue Structure (entre <strong>Vue/Montrer la
structure</strong>), on slectionne l'lment &lt;body&gt;. A ce moment l on
slectionne l'entre langue de l'outil <strong>Attributs</strong> pour
afficher le formulaire de choix de la langue.</p>
</div>

<div>
<h3 id="Sauver"><a id="L1104">Enregistrer des documents en HTML</a></h3>

<p><b>Amaya</b> ne fournit aucune vue d'ensemble des pages installes sur le
serveur. Cependant il est possible d'enregistrer ou copier des fichiers sur un
serveur ou sur sur son disque local grce aux commandes
<strong>Enregistrer</strong> et <strong>Enregistrer sous</strong>. Pendant ces
oprations, Amaya tient compte des images et des ressources lies au
document.</p>

<h4 id="commande"><a id="L1517">La commande Enregistrer</a></h4>

<p>La commande Enregistrer peut tre invoque soit en choisissant
<strong>Enregistrer</strong> depuis le menu <strong>Fichier</strong> (<kbd>Ctrl
s</kbd>) ou bien en cliquant sur le bouton <img alt="floppy"
src="../../resources/icons/22x22/save.png" />.</p>

<h4 id="commande1"><a id="L1518">La commande Enregistrer sous</a></h4>

<p>Le fait de slectionner l'entre <strong>Enregistrer sous</strong> dans le
menu <strong>Fichier</strong> ouvre une bote de dialogue qui permet
d'enregistrer le document courant  une adresse diffrente (sur un serveur Web ou
sur le disque local) ou de changer certains paramtres, comme le format du
document et l'encodage.</p>

<h2 id="L662">5. Cration du contenu (paragraphes, en-ttes de sections,
divisions)</h2>

<p>Par dfaut, Amaya cre un nouveau paragraphe chaque fois que l'on active
la touche <kbd>Enter</kbd>. Une fois le paragraphe et son contenu cr, on
peut insrer un en-tte de section, avant, aprs, ou au milieu du
paragraphe,</p>
<ul>
  <li>en activant un des boutons Hn,</li>
  <li>ou en tapant <kbd>Ctrl n</kbd> (n allant de 1  6),</li>
  <li>ou en slectionnant, l'entre correspondante du menu
    <strong>XHTML</strong>.</li>
</ul>

<p>Quand l'insertion se fait au milieu du paragraphe, Amaya coupe le
paragraphe existant en deux et insre l'en-tte au milieu.</p>

<h3 id="Transforma">Transformations</h3>

<p>Si une partie du paragraphe est slectionne au moment o on insre
l'en-tte, ce texte sera supprim dans le paragraphe et insr dans l'en-tte
cr.</p>

<p>On peut aussi slectionner le paragraphe (touche <kbd>F2</kbd>) et
transformer ainsi le paragraphe en en-tte. Un ou plusieurs paragraphes
peuvent en fait se transformer en liste, table, prformat en fonction de
l'lment cible choisi. L'entre de menu <strong>Edition/Transformer</strong>
propose les cibles possibles pour la slection courante.</p>

<h3 id="L6081">Prformat</h3>

<p>L'lment prformat est un paragraphe particulier qui permet de prserver
tous les caractres: espace, fin de ligne.</p>

<p>Pour transformer un paragraphe en prformat, on slectionne le paragraphe
en entier et on active l'entre de menu <strong>XHTML/Prformat</strong> (ou
<kbd>Ctrl h Ctrl p</kbd>).</p>

<p>Pour transformer un prformat en paragraphe, on slectionne le prformat
en entier et on active l'entre de menu <strong>XHTML/Paragraphe</strong>.</p>

<p>Quand la slection se trouve  la fin d'un &lt;pre&gt;, la touche
<kbd>Enter</kbd> cre une nouvelle ligne du &lt;pre&gt;. Pour crer un
paragraphe aprs le &lt;pre&gt;, il faut slectionner le &lt;pre&gt; en
utilisant la touche <kbd>F2</kbd> puis <kbd>Enter</kbd>.</p>

<h3 id="Division">Division</h3>

<p>Il est possible de grouper une srie de paragraphes, en-ttes, etc. dans
une division. Pour cela, on slectionne les lments  grouper ainsi que
l'entre <strong>Division</strong> dans le menu XHTML.</p>

<h3 id="touche">La touche Enter</h3>

<p>La touche <kbd>Enter</kbd> (ou Return) joue un rle particulier. En
gnral elle clt l'lment courant et cre un paragraphe juste aprs. Si un
lment complet est slectionn, la touche <kbd>Enter</kbd> cre une autre
instance de cet lment. Par exemple si on slectionne un en-tte, la touche
<kbd>Enter</kbd> va crer un en-tte vide aprs.</p>

<h3 id="touches"><a id="Back">Les touches Back Space et Delete</a></h3>

<p>Des lments conscutifs peuvent tre fusionns, mme s'ils ne sont pas au
mme niveau dans la structure du document. La fusion s'effectue  l'aide des
touches <kbd>Back Space</kbd> et <kbd>Delete</kbd>. Quand le point
d'insertion est  la fin d'un lment, utilisez la touche <kbd>Delete</kbd>.
Quand il est au dbut, utilisez la touche <kbd>Back Space</kbd>. Dans les
deux cas, ces touches n'effacent aucun caractre. Elles fusionnent des
lments spars par une limite de structure.</p>

<p>Quand le point d'insertion est  l'intrieur d'un lment, ces deux
touches effacent comme d'habitude le caractre suivant ou le caractre
prcdent.</p>

<h3 id="Caract">Caractres spciaux</h3>

<p>Pour les caractres ISO-latin qui ne sont pas directement disponibles
depuis le clavier, Amaya utilise le support standard fournit par le
systme.</p>

<p>Amaya fournit aussi des raccourcis pour certains caractres non
disponibles au clavier comme:</p>
<ul>
  <li>Pour obtenir un espace non scable, vous devez taper <kbd>Ctrl
    espace</kbd>. Ce caractre sera sauv comme une entit
    (<code>&amp;nbsp;</code>).</li>
  <li>Pour obtenir un &euro; (euro), vous devez taper <kbd>Alt e</kbd>.</li>
  <li>Pour obtenir un , vous devez taper <kbd>Ctrl &lt;</kbd> (ou
    <kbd>Shift</kbd> <kbd>Ctrl &lt;</kbd> selon le clavier).</li>
  <li>Pour obtenir un , vous devez taper <kbd>Shift Ctrl &gt;</kbd>.</li>
</ul>

<h3 id="image">Insrer une image</h3>

<p>Pour insrer une image, on choisit l'entre <strong>Image</strong> dans le
menu <strong>XHTML</strong> (raccourci <kbd>Ctrl h Ctrl i</kbd>) ou on clique
sur le bouton <img alt="Image "
src="../../resources/icons/16x16/XHTML_Image.png" longdesc="longdesc.htm" />.
Une bote de dialogue s'affiche qui permet de rentrer le nom du fichier et le
<a href="ImageMaps.html.fr#Alternative">texte de remplacement</a> ('ALT'
texte) de l'image. L'insertion n'est prise en compte que lorsque le texte de
remplacement est fourni.</p>

<p>L'image est affiche avec ses dimensions par dfaut. On peut
redimensionnerer l'image insre en ditant les attributs
<strong>width</strong> et/ou <strong>height</strong> de l'image. Quand
l'image est slectionne, on slectionne l'entre <strong>width</strong> ou
<strong>height</strong> de l'outil <strong>Attributs</strong>.</p>

<p>Par dfaut l'image est cadre  gauche. On peut modifier le cadrage de
l'image slectionne en modifiant l'alignement dans l'outil
<strong>Format</strong> (il faut valider le changement de format avec le
bouton <img alt="ok" src="../../resources/icons/16x16/ok.png" />).</p>

<h3 id="Remplacer">Remplacer une image</h3>

<p>Pour remplacer une image il faut slectionner cette image en draguant sur
l'image avec la souris. Procdez alors comme pour l'ajout d'une image (voir
ci-dessus). Lorsqu'une image (et seulement une image) est entirement
slectionne, la bote de dialogue des images effectue le remplacement de
l'image slectionne au lieu d'insrer une nouvelle image.</p>

<h3 style="clear: both" id="Copier">Copier/Coller, Dfaire/Refaire</h3>

<p>Amaya permet copier/coller non seulement du texte et des images, mais
aussi une structure complexe comme une division ou une suite de paragraphes
et d'en-ttes.</p>

<p>Il est toujours possible de dfaire et de refaire les dernires
modifications opres dans le document.</p>

<p><a href="Creating.html.fr">A voir pour plus de dtail</a></p>

<h2 id="L831">6. Les listes</h2>

<h3 id="Editer">Editer les listes  puces ou les listes numrotes</h3>

<h4 id="Premi1">Premire mthode</h4>

<p>En cliquant sur <img alt="(Liste)"
src="../../resources/icons/16x16/XHTML_Bullet.png" /> (ou <kbd>Ctrl h Ctrl
l</kbd>) on cre une liste  puces et un premier item de liste 
l'intrieur.</p>
<ul>
  <li>Il ne reste plus qu' taper le texte de l'item. 
    <p>La touche <kbd>Enter</kbd> en fin d'item va crer un paragraphe vide
    dans l'item et on peut immdiatement saisir le contenu de ce nouveau
    paragraphe.</p>
  </li>
  <li>Si on ne veut pas insrer de paragraphe mais passer  l'item suivant,
    on double la touche <kbd>Enter</kbd>. 
    <p>Attention en cliquant sur <img alt="(Liste)"
    src="../../resources/icons/16x16/XHTML_Bullet.png" /> (ou <kbd>Ctrl h
    Ctrl l</kbd>) on cre une nouvelle liste  puces  l'intrieur de l'item
    courant.</p>
  </li>
  <li>Si on veut terminer la liste, on triple la touche <kbd>Enter</kbd>.</li>
</ul>

<p>En cliquant sur <img alt="(Liste numrote)"
src="../../resources/icons/16x16/XHTML_Num.png" /> (ou <kbd>Ctrl h Ctrl
n</kbd>) on cre une liste numrote et un item de liste  l'intrieur.</p>

<h4 id="Deuxi1">Deuxime mthode</h4>

<p>On peut saisir du texte sans dfinir au pralable de type d'lment. Par
dfaut, Amaya cre un nouveau paragraphe chaque fois que l'on active la
touche <kbd>Enter</kbd>. On peut ensuite slectionner plusieurs paragraphes
et cliquer sur <img alt="(Liste)"
src="../../resources/icons/16x16/XHTML_Bullet.png" /> (ou <kbd>Ctrl h Ctrl
l</kbd>) pour crer une liste  puces.</p>

<p>Pour slectionner tout le contenu d'une suite de paragraphes, on utilise
la touche <kbd>F2</kbd>.</p>

<h4 id="Transforma1">Transformation d'une liste  puces et en liste
numrote</h4>

<p>On pose la slection dans un item de liste, puis en doublant la touche
<kbd>F2</kbd> on slectionne la liste complte. En cliquant sur <img
alt="(Liste numrote)" src="../../resources/icons/16x16/XHTML_Num.png" />
(ou <kbd>Ctrl h Ctrl n</kbd>) on cre une liste numrote  la place. On peut
bien sr passer de la mme faon d'une liste numrote  une liste 
puces.</p>

<h3 id="edit-dl">Editer les listes de dfinitions (dl/dt/dd)</h3>

<p>En cliquant sur <img alt="(Liste de dfinitions)"
src="../../resources/icons/16x16/XHTML_DL.png" /> (ou <kbd>Ctrl h Ctrl
d</kbd>) on cre une liste de dfinitions.</p>

<p>La touche <kbd>Enter</kbd> est galement utile pour diter des listes de
dfinitions. Considrez l'exemple suivant :</p>

<blockquote>
  <dl>
    <dt>Terme 1</dt>
    <dt>Terme 2</dt>
      <dd>Dfinition des deux termes.</dd>
  </dl>
</blockquote>

<p>C'est une liste de dfinitions (<code>dl</code>) contenant deux termes
(<code>dt</code>) suivis par une dfinition (<code>dd</code>). Pour ajouter
un nouveau paragraphe  l'intrieur de la dfinition (<code>dd</code>),
placez le point d'insertion  la fin (aprs le mot "termes") et appuyez sur
la touche <kbd>Enter</kbd>. Si vous pressez <kbd>Enter</kbd> deux fois, vous
sortez de la dfinition en cours (<code>dd</code>) et vous crez un nouveau
terme (<code>dt</code>). A la fin de ce nouveau terme, presser une fois la
touche <kbd>Enter</kbd> vous permet de crer encore un nouveau terme
(<code>dt</code>). La presser deux fois cre une nouvelle dfinition
(<code>dd</code>).</p>

<p>Si vous voulez crer un nouveau terme avec sa dfinition <em>avant</em> le
Terme 1, mettez le point d'insertion au dbut du terme 1 et appuyez sur
<kbd>Enter</kbd>. Tapez le nouveau terme (<code>dt</code>), puis pressez
<kbd>Enter</kbd> deux fois : une nouvelle dfinition (<code>dd</code>) est
cre directement aprs le nouveau terme.</p>
</div>

<p>De faon gnrale on utilise la touche <kbd>Enter</kbd> pour insrer des
lments de structure avant ou aprs des listes ou des items de liste, et les
touches <kbd>Back Space</kbd> et <kbd>Delete</kbd> pour fusionner des listes
ou des items de listes.</p>

<div>
<h2 id="L1002">7. Les liens</h2>

<p>Les liens hypertexte permettent de relier des parties de document
entre-elles ou des documents entre-eux.</p>

<h3 id="L948">Cration de cibles</h3>

<p>La cible d'un lien hypertexte peut tre</p>
<ul>
  <li>un document entier,</li>
  <li>ou un passage du document englob par une ancre cible,</li>
  <li>ou un lment HTML qui possde un identificateur (attribut ID)</li>
</ul>

<p>Pour crer une cible dans un document, il suffit de slectionner le
passage dsir et d'activer l'entre de menu <strong>Crer cible</strong>
(<kbd>Ctrl l Ctrl t</kbd>) dans le menu <strong>Liens</strong>. Si la
slection porte sur un lment HTML entier, Amaya va lui associer un
identificateur unique. Sinon, Amaya va englober le contenu de la slection
dans une ancre cible.</p>

<h3 id="L973">Cration de liens</h3>

<p>L'origine d'un lien est une ancre qui possde un attribut
<code>href</code>. On procde de la mme faon pour un lien vers un document
entier ou une cible.</p>

<h4 id="Lien">Lien vers un autre document dit par Amaya</h4>
<ol>
  <li>On slectionne le passage choisi.</li>
  <li>On clique sur le bouton <img alt="Link "
    src="../../resources/icons/16x16/XHTML_Link.png" /></li>
  <li>On clique sur le document cible affich.</li>
</ol>

<p>Autre mthode:</p>
<ol>
  <li>On slectionne le passage choisi.</li>
  <li>On choisit <strong>Crer/changer lien</strong> du <a
    href="Browsing.html.fr"></a>menu <strong>Liens</strong> (raccourci
    <kbd>Ctrl l Ctrl l</kbd>) pour afficher le formulaire de cration de
  lien.</li>
  <li>Soit on saisit l'URI du document cible et on confirme. Soit on dcide
    de dsigner la cible avec la souris (bouton Clic puis clic sur le
    document cible affich).</li>
</ol>

<p>Dans tous les cas, une fois la cible choisie, Amaya va calculer l'URL
relative qui permet d'aller du document source au document cible.</p>

<h4 id="Lien1">Lien vers une ancre cible d'un document dit par Amaya</h4>

<p>Pour crer un lien vers une ancre cible particulire ou vers un lment
cible particulier d'un document dit par Amaya, il faut d'abord demander la
visualisation des cibles <a id="target"><img src="../images/target.gif"
alt=" target " /></a> dans le document concern en activant l'entre
<strong>Montrer les cibles</strong> du menu <strong>Vues</strong> ou ouvrant
la vue des liens (entre <strong>Montrer les liens</strong> du menu
<strong>Vues</strong>). Ensuite:</p>
<ol>
  <li>On slectionne le passage choisi.</li>
  <li>On clique sur le bouton <img alt="Link "
    src="../../resources/icons/16x16/XHTML_Link.png" /></li>
  <li>On clique sur la cible choisie.</li>
</ol>

<h4 id="Lien2">Lien vers un autre document non affich</h4>

<p>Pour crer un lien vers un autre document local ou distant:</p>
<ol>
  <li>On slectionne le passage choisi.</li>
  <li>On clique sur le bouton <img alt="Link "
    src="../../resources/icons/16x16/XHTML_Link.png" /></li>
  <li>On clique sur une zone du document qui ne peut pas tre une cible pour
    afficher le formulaire de saisie de l'URL. Si le document est local, on
    peut utiliser le browser de fichier pour slectionner le fichier.</li>
</ol>

<p>Autre mthode:</p>
<ol>
  <li>On slectionne le passage choisi.</li>
  <li>On choisit <strong>Crer/changer lien</strong> du menu
    <strong>Liens</strong> (raccourci <kbd>Ctrl l Ctrl l</kbd>)</li>
  <li>On saisit l'URL du document cible et on confirme.</li>
</ol>

<h4 id="Mettre"><a id="Changing">Mettre  jour un lien</a></h4>

<p>Pour garder une ancre mais changer la cible du lien correspondant, on
place la slection dans l'ancre et on procde comme pour la cration de lien
(bouton <img alt="Link " src="../../resources/icons/16x16/XHTML_Link.png" />
ou l'entre <strong>Crer/changer Lien</strong> du menu
<strong>Liens</strong>). On peut alors dsigner la nouvelle cible ou diter
l'URI.</p>

<p>Pour changer la cible d'un lien, on peut galement diter l'attribut
<code>href</code> dans la vue structure.</p>

<h4 id="Supprimer"><a id="Removing">Supprimer un lien ou une ancre
cible</a></h4>

<p>Le menu <strong>Liens</strong> contient une entre <strong>Dtruire
ancre</strong> qui permet de dtruire l'ancre cible ou le lien slectionn.
Il suffit que la slection soit  l'intrieur de l'ancre  dtruire. L'ancre
est dtruite, mais son contenu reste.</p>
</div>

<div>
<h2 id="L11631">8. Mises en vidence du texte</h2>

<p>Il est possible de marquer des parties de texte mises en ligne soit en
utilisant les CSS (voir plus loin), soit en utilisant les lments mise en
vidence, important, code, citation, abrviation, etc. de HTML.</p>

<p>Les entres de menu et les boutons correspondants fonctionnent comme des
bascules (active/dsactives).</p>

<p>Souvent l'introduction de mises en vidence engendrent des problmes de
perte des blancs.</p>

<h3 id="Traitement">Traitement des blancs</h3>

<p>Le traitement des blancs est appliqu par Amaya lors du chargement d'un
document et lors de l'dition de celui-ci. Par exemple, le code source
suivant:</p>
<pre><code>    &lt;p&gt;Amaya supprime les</code>&lt;strong&gt;<code> blancs non significatifs </code>&lt;/strong&gt;<code>au chargement&lt;/p&gt;</code></pre>

<p>donnera:</p>
<pre><code>    Amaya supprime les</code><code><strong>blancs non significatif</strong></code><code><strong>s</strong>au chargement</code></pre>

<p>car les blancs de dbut et de fin de l'lment <code>strong</code> sont
considrs comme non significatifs et sont donc supprims.</p>

<p>La forme correcte aurait t :</p>
<pre>    &lt;p&gt;Amaya supprime les &lt;strong&gt;blancs non significatifs&lt;/strong&gt; au chargement&lt;/p&gt;</pre>
</div>

<div>
<h2 id="L12061">9. Les tables</h2>

<h3 id="L1165"><a id="Creating1">Crer une nouvelle table</a></h3>

<p>Quand on active le bouton table <img
src="../../resources/icons/16x16/XHTML_Table.png" alt="Table button" /> ou
quand on slectionne l'entre <strong>Table</strong> depuis le menu
<strong>XHTML</strong>, Amaya visualise une bote de dialogue qui permet de
spcifier le nombre initial de lignes, de colonnes, ainsi que la bordure en
pixels.</p>

<p>En confirmant on cre une table comme suit.</p>

<table border="1" summary="table">
  <caption>I</caption>
  <tbody>
    <tr>
      <td></td>
      <td></td>
    </tr>
    <tr>
      <td></td>
      <td></td>
    </tr>
  </tbody>
</table>

<p>L'espace au dessus de la table est rserv  la lgende. Le point
d'insertion est automatiquement plac dans cette lgende pour en saisir le
contenu. La touche <kbd>Delete</kbd> supprime la lgende.</p>

<p>La nouvelle table contient des cellules vides. On peut cliquer sur l'une
d'entre elles au hasard et y insrer du texte, des images et autre. On peut
galement dplacer le point d'insertion de cellule en cellule par
l'intermdiaire des flches du clavier.</p>

<h3 id="Ajouter"><a id="Adding3">Insrer/Ajouter une colonne</a></h3>

<p>Il n'existe deux commandes spcifiques pour crer une nouvelle
colonne:</p>
<ul>
  <li><strong>Insrer une colonne</strong> dans le sous-menu
    <strong>Table</strong> (<kbd>Ctrl t Ctrl b</kbd>) ajoute une nouvelle
    colonne avant la colonne slectionne.</li>
  <li><strong>Ajouter une colonne</strong> dans le sous-menu
    <strong>Table</strong> (<kbd>Ctrl t Ctrl a</kbd>) ajoute une nouvelle
    colonne aprs la colonne slectionne.</li>
</ul>

<p>Si on a slectionn une cellule complte par <kbd>F2</kbd> la touche
<kbd>Enter</kbd> cre une nouvelle cellule aprs et la colonne
correspondante.</p>

<h3 id="L1248">Dtruire une colonne</h3>

<p>Pour dtruire une colonne de table, il faut slectionner la colonne et
utiliser la commande <kbd>Delete</kbd>. Il y a deux mthodes pour
slectionner une colonne :</p>
<ol>
  <li>Soit l'entre <strong>Slectionner la colonne</strong> dans le
    sous-menu <strong>Table</strong> (<kbd>Ctrl t Ctrl c</kbd>).</li>
  <li>Soit tendre la slection sur au moins deux cellules dans la mme
    colonne (Cell 1.1  Cell 2.1 dans l'exemple ci-dessous) puis deux fois
    <kbd>F2</kbd> pour slectionner la colonne.</li>
</ol>

<table border="1" summary="table">
  <caption>Lgende</caption>
  <tbody>
    <tr>
      <td>Cell 1.1</td>
      <td>I</td>
      <td>Cell 1.2</td>
      <td>Cell 1.3</td>
    </tr>
    <tr>
      <td>Cell 2.1</td>
      <td></td>
      <td></td>
      <td></td>
    </tr>
  </tbody>
</table>

<h3 id="Copier1">Copier/Coller ou Dplacer une colonne</h3>

<p>Pour dplacer ou copier/coller une colonne de table:</p>
<ol>
  <li>Il faut slectionner la colonne comme dans le cas de <strong>Dtruire
    une colonne</strong> et copier (<kbd>Ctrl c</kbd>) ou couper (<kbd>Ctrl
    x</kbd>) son contenu.</li>
  <li>Pour coller la colonne avant une autre colonne 
    <ul>
      <li>soit on slectionne le dbut d'une cellule de colonne et on active
        la commande coller (<kbd>Ctrl v</kbd>),</li>
      <li>soit on utilise l'entre de menu <strong>Coller avant</strong> dans
        le sous-menu <strong>Table</strong> (<kbd>Ctrl t Ctrl p</kbd>).</li>
    </ul>
  </li>
  <li>Pour coller la colonne aprs une autre colonne 
    <ul>
      <li>soit on slectionne la fin d'une cellule de colonne et on active la
        commande coller (<kbd>Ctrl v</kbd>),</li>
      <li>soit on utilise l'entre de menu <strong>Coller aprs</strong> dans
        le sous-menu <strong>Table</strong> (<kbd>Ctrl t Ctrl v</kbd>).</li>
    </ul>
  </li>
</ol>

<h3 id="Ajouter1"><a id="Adding11">Insrer/Ajouter une ligne</a></h3>

<p>Il n'existe deux commandes spcifiques pour crer une nouvelle ligne:</p>
<ul>
  <li><strong>Insrer une ligne</strong> dans le sous-menu
    <strong>Table</strong> (<kbd>Ctrl t Ctrl i</kbd>) ajoute une nouvelle
    ligne avant la ligne slectionne.</li>
  <li><strong>Ajouter une ligne</strong> dans le sous-menu
    <strong>Table</strong> (<kbd>Ctrl t Ctrl n</kbd>)ajoute une nouvelle
    ligne aprs la ligne slectionne.</li>
</ul>

<p>Si on a slectionn une ligne complte par <kbd>F2</kbd> la touche Enter
cre une nouvelle ligne aprs.</p>

<h3 id="L1408">Dtruire une ligne</h3>

<p>Pour dtruire une ligne de table, il faut slectionner la ligne et
utiliser la commande <kbd>Delete</kbd>. Il y a deux mthodes pour
slectionner une ligne :</p>
<ol>
  <li>Soit l'entre <strong>Slectionner la ligne</strong> dans le sous-menu
    <strong>Table</strong> (<kbd>Ctrl t Ctrl r</kbd>).</li>
  <li>Soit poser la slection sur une cellule de la ligne (Cell 1.1 dans
    l'exemple ci-dessous) puis deux fois <kbd>F2</kbd> pour slectionner la
    ligne.</li>
</ol>

<h3 id="Copier2">Copier/Coller ou Dplacer une ligne</h3>

<p>Pour dplacer ou copier/coller une ligne de table:</p>
<ol>
  <li>Il faut slectionner la ligne comme dans le cas de <strong>Dtruire une
    ligne</strong> et copier (<kbd>Ctrl c</kbd>) ou couper (<kbd>Ctrl
    x</kbd>) son contenu.</li>
  <li>Pour coller la ligne avant une autre ligne 
    <ul>
      <li>soit on slectionne le dbut d'une ligne et on active la commande
        coller (<kbd>Ctrl v</kbd>),</li>
      <li>soit on utilise l'entre de menu <strong>Coller avant</strong> dans
        le sous-menu <strong>Table</strong> (<kbd>Ctrl t Ctrl p</kbd>).</li>
    </ul>
  </li>
  <li>Pour coller la colonne aprs une autre colonne 
    <ul>
      <li>soit on slectionne la fin d'une ligne et on active la commande
        coller (<kbd>Ctrl v</kbd>),</li>
      <li>soit on utilise l'entre de menu <strong>Coller aprs</strong> dans
        le sous-menu <strong>Table</strong> (<kbd>Ctrl t Ctrl v</kbd>).</li>
    </ul>
  </li>
</ol>

<h3 id="Cellules">Cellules tendues</h3>

<p>Il n'existe quatre commandes spcifiques pour tendre ou rduire
l'extension de cellules:</p>
<ul>
  <li><strong>Joindre avec la cellule  droite</strong> dans le sous-menu
    <strong>Table</strong> (<kbd>Ctrl t Ctrl e</kbd>) tend la cellule d'une
    position  droite et colle le contenu des deux cellules.</li>
  <li><strong>Joindre avec la cellule au-dessous</strong> dans le sous-menu
    <strong>Table</strong> (<kbd>Ctrl t Ctrl j</kbd>)tend la cellule d'une
    position vers le bas et colle le contenu des deux cellules.</li>
  <li><strong>Rduire extension horizontale</strong> (<kbd>Ctrl t Ctrl
    s</kbd>) rduit l'extension horizontale de la cellule d'une position et
    engendre une cellule vide.</li>
  <li><strong>Rduire extension verticale</strong> (<kbd>Ctrl t Ctrl m</kbd>)
    rduit l'extension verticale de la cellule d'une position et engendre une
    cellule vide.</li>
</ul>

<p>On peut aussi diter directement les attributs <strong>colspan</strong> et
<strong>rowspan</strong> de la cellule.</p>

<h3 id="Ajouter2">Ajouter un nouveau corps de table (tbody)</h3>
<ol>
  <li>Pour crer un nouveau corps de table en dessous d'un corps de table
    existant, il faut placer le curseur  la fin de la dernire cellule de la
    dernire ligne du corps de table et slectionner l'entre <strong>Corps
    (tbody)</strong> dans le sous-menu <strong>Table</strong>.</li>
  <li>Pour crer un nouveau corps de table au-dessus d'une ligne existante,
    il faut placer le curseur au dbut de la premire cellule de la ligne et
    slectionner l'entre <strong>Ligne</strong> dans le sous-menu
    <strong>Table</strong>.</li>
</ol>

<p>De nouveaux corps de table peuvent tre crs efficacement avec la touche
<a href="Creating.html.fr#L906">Enter</a>. Quand le corps de table entier est
slectionn (il faut utiliser la touche <kbd>F2</kbd>), en tapant la touche
<kbd>Enter</kbd> vous crez une nouveau corps de table aprs le corps de
table slectionn.</p>

<h3 id="Ajouter3"><a id="Adding21">Ajouter quelque chose aprs une
table</a></h3>

<p>De nombreux types d'lments peuvent tre inclus  l'intrieur des
cellules de la table. Pour cette raison, Amaya pourrait mal comprendre vos
intentions quand vous slectionnez un type d'lment (par exemple cliquant
H1, H2, etc. ou slectionnant une entre dans le menu <strong>XHTML</strong>)
pendant qu'un composant de la table est slectionn.</p>

<h3 id="L1586">Cration d'un paragraphe aprs une table</h3>

<p>Quand la slection se trouve dans une table, la touche <kbd>Enter</kbd>
cre un nouveau paragraphe dans la table. Pour crer un paragraphe aprs la
table, il faut slectionner la table entire en utilisant la touche
<kbd>F2</kbd> puis <kbd>Enter</kbd>. Ce nouveau paragraphe peut tre modifi
si besoin est.</p>
</div>

<div>
<h2 id="L12281">10. Recherche/Remplacement - Correction orthographique</h2>

<h3 id="Recherche">Recherche et remplacement de texte</h3>

<p>La recherche/remplacement se lance, soit en cliquant sur le bouton <img
src="../../resources/icons/22x22/find.png" alt="find " />, soit par l'entre
de menu <strong>Edition/Rechercher</strong>. Un boite de dialogue apparat.
vous avez deux zones de saisie la premire sera pour le texte  rechercher la
deuxime zone de saisie sera pour le texte  remplacer.</p>

<p>Pour chacune des actions vous avez des choix d'options.</p>
<ul>
  <li>les options de recherche : 
    <ul>
      <li>la casse : pour la recherche permet de spcifier s'il y a lieu de
        diffrencier ou non les majuscules des minuscules.</li>
      <li>case  cocher pour slectionner la zone sur laquelle raliser la
        recherche avant la slection, aprs la slection, dans la slection
        ou sur la totalit du document.</li>
    </ul>
  </li>
  <li>Les options de remplacement : 
    <ul>
      <li>le type de remplacement : pas de remplacement (juste une
        recherche), remplacement avec un fentre de confirmation,
        remplacement automatique.</li>
    </ul>
  </li>
</ul>

<h3 id="Correction">Correction orthographique</h3>

<p>La correction orthographique se ralise  l'aide d'une boite de dialogue
active par l'action <strong>Edition/Vrifier orthographe</strong>.</p>

<p>les options de la boite de dialogue :</p>
<ul>
  <li>Le dictionnaire utilis se fait en fonction de la langue dfinie au
    niveau de l'lment ou du document.</li>
  <li>On peut spcifier le nombre de propositions (par dfaut 3).</li>
  <li>On peut exclure des lments lors de recherche de correspondance de
    mots avec le dictionnaire (par dfaut toutes les options sont activ)</li>
  <li>Options de zone de recherche vous avez la possibilit de spcifier la
    zone sur laquelle cette correction orthographique se fera avant la
    slection, aprs la slection, dans la slection ou sur la totalit du
    document.</li>
  <li>les boutons d'activation de recherche. 
    <ul>
      <li>recherche du suivant (sans action) : considre que le mot est
        correcte et passe  l'erreur suivante.</li>
      <li>rajoute au dictionnaire personnel : rajoute le mot au dictionnaire
        personnel.</li>
      <li>remplace le mots et passe  l'occurrence suivante.</li>
      <li>remplace le mots et le rajoute dans le dictionnaire personnel.</li>
      <li>confirmer permet de fermer la boite de dialogue.</li>
    </ul>
  </li>
</ul>
</div>

<div>
<h2 id="L1230">11. Attributs</h2>

<p>Il y a deux manires d'diter des attributs :</p>
<ul>
  <li>L'outil <strong>Attributs</strong></li>
  <li>La Vue structure</li>
</ul>

<h3 id="Editer1"><a id="L1073">Editer des attributs par le biais de l'outil
Attributs</a></h3>

<p>L'outil <strong>Attributs</strong> donne une liste de tous les attributs
qui peuvent tre associs  l'lment slectionn. Il peut tre utilis pour
crer un attribut, pour changer la valeur d'un attribut existant ou pour
effacer un attribut.</p>

<p>Pour diter un attribut, slectionnez d'abord l'lment appropri. Vous
devez slectionner l'lment entier et pas seulement un caractre 
l'intrieur de l'lment. Pour cela, il faut utiliser la touche
<kbd>F2</kbd>. Quand l'lment est slectionn, l'outil
<strong>Attributs</strong> affiche la liste des attributs applicables. On
peut voir rapidement si l'attribut a dj une valeur ou non.</p>

<h3 id="Editer2"><a id="Editing">Editer des attributs dans la Vue
structure</a></h3>

<p>Tous les attributs sont affichs dans la Vue structure. Les attributs dont
la valeur peut tre choisie librement sont affichs en rose et vous pouvez
diter leur valeur comme n'importe quelle autre chane de caractres. Quand
la valeur de l'attribut est affiche en bleu, vous pouvez seulement la
changer  l'aide de l'outil <strong>Attributs</strong>. Ceci assure que
seules des valeurs correctes soient choisies.</p>

<p>Quand la slection se trouve dans une valeur d'attribut, la touche
<kbd>F2</kbd> slectionne la valeur complte. La touche <kbd>Delete</kbd>
dtruit alors la valeur, et un deuxime <kbd>Delete</kbd> supprimera
l'attribut.</p>

<p><a href="Attributes.html.fr">A voir pour plus de dtail</a></p>
</div>

<div>
<h2 id="L1232">12. Cration de feuilles de style CSS</h2>

<h3 id="feuilles1"><a id="feuilles">Les feuilles de style CSS externes et les
feuilles de style CSS utilisateur</a></h3>

<p>Un document peut associer plusieurs feuilles de style externes qui sont
charges avec le document et lui sont appliques. Une feuille de style
externe peut s'appliquer  plusieurs documents.</p>

<p>L'utilisateur peut dfinir une feuille de style spcifique qui s'applique
 tous les documents chargs. Cette feuille de style est appele
<strong>Feuille de Style Utilisateur</strong>. C'est le fichier local
<strong>amaya.css</strong> conserv dans l'environnement de l'utilisateur (le
<a href="Configure.html.fr#AmayaHome">rpertoire d'AmayaHome</a>). Par
exemple si vous prfrez afficher les document en Helvetica et imprimer avec
une police de caractres de petite taille, vous pouvez crer votre feuille de
style utilisateur avec les rgles CSS suivantes:</p>
<pre>@media print {
 BODY {font-size: 10pt}
}
@media screen {
 BODY {font-family: Helvetica}
}</pre>

<h3 id="L1746"><a id="Managing">Grer des feuilles de style CSS
externes</a></h3>

<p>L'entre de feuilles de style donne accs  une srie de commandes qui
permettent de contrler les feuilles de style CSS externes et celles qui
donnent les prfrences de l'utilisateur :</p>
<ul>
  <li>La commande <strong>Ajouter</strong> permet de lier une nouvelle
    feuille de style CSS  un document courant. On peut cliquer directement
    sur la cible de la feuille de style si elle est dj visualise dans la
    fentre Amaya. Si ce n'est pas le cas, l'utilisateur devra cliquer dans
    le document courant pour avoir accs  une bote de dialogue et taper
    l'URL de la cible de la feuille de style. Cette commande ajoute un
    lment lien avec ses attributs  la tte du document.</li>
  <li>La commande <strong>Ouvrir</strong> permet d'ouvrir une des feuilles de
    style CSS appliques au document courant.</li>
  <li>La commande <strong>Dsactiver</strong> permet de supprimer les effets
    d'une des feuilles de style actives du document courant. Cette commande
    n'affecte en rien le lien CSS dans le document.</li>
  <li>La commande <strong>Ractiver</strong> permet de rtablir les effets
    d'une des feuilles de style CSS dsactives du document courant. Cette
    commande n'affecte en rien le lien CSS dans le document.</li>
  <li>La commande <strong>Retirer</strong> permet de retirer une des feuilles
    de style CSS externes. Cette commande agit comme la commande Dsactiver.
    En plus de cela, l'lment lien qui attache les feuilles de style CSS est
    supprim.</li>
</ul>

<p>Les commandes Ouvrir, Dsactiver et Ractiver peuvent tre appliques aux
feuilles de style qui donnent les prfrences de l'utilisateur, mais les
commandes Ajouter et Retirer concernent uniquement les feuilles de style
relies. La figure suivante montre la liste des feuilles de style CSS
proposes pour la commande Ouvrir. Si aucune feuille de style CSS n'est
actuellement applique  un document, une bote de dialogue expliquera
"qu'aucun fichier CSS n'est disponible".</p>

<h3 id="Visualiser">Visualiser le style appliqu</h3>

<p>S'il y a beaucoup de feuilles de style attaches  un document, il est
difficile de comprendre pourquoi un lment est visualis avec cette couleur
ou ces marges, etc. Pour aider l'utilisateur, Amaya fournit une commande
<strong>Montrer le style appliqu</strong> qui visualise dans une fentre
externe les proprits CSS appliques au premier lment de la slection
courante.</p>

<p>L'utilisateur peut afficher le source CSS qui engendre chaque proprit en
double (ou simple) cliquant sur la proprit. Aussi longtemps que la fentre
est ouverte, Amaya met  jour le contenu de la fentre quand la slection
change.</p>

<p>En appuyant sur la touche <kbd>F2</kbd> sur les, l'utilisateur peut voir
les proprits CSS appliques aux lments englobants.</p>

<h3 id="L1798">Crer des proprits CSS</h3>

<p>Amaya ne fournit pas pour le moment une liste complte des proprits CSS
2 sauf pour les proprits les plus courantes. En gnral l'utilisateur doit
donc se reporter  la spcification CSS 2 pour connatre le nom des
proprits et leurs valeurs.</p>

<p>Pour associer une classe  un lment, vous pouvez galement utiliser
l'outil <a href="Attributes.html.fr#L1073"><strong>Attributs</strong></a>. Il
faut utiliser cet outil pour retirer la classe d'un lment ou changer sa
classe : l'attribut de <strong>class</strong> se manipule comme un autre
attribut.</p>
</div>

<div>
<h2 id="L1242">13. Dtection des erreurs</h2>

<p>Au chargement d'un document, Amaya peut dtecter des erreurs de HTML. Le
parseur est trs tolrant pour les documents HTML mais plus strict pour les
documents XHTML. Si une erreur est dtecte, une pastille rouge s'allume dans
la barre de statut en bas  droite.</p>
</div>

<div>
<h4 id="peut">On peut corriger les erreurs</h4>

<p>On affiche le dtail des erreurs dtectes en slectionnant l'entre
<strong>Montrer les erreurs</strong> du menu <strong>Fichier</strong> ou en
cliquant sur la pastille rouge en bas  droite. Pour corriger ces erreurs, on
active le lien vers la vue source du document pour visualiser la position de
l'erreur dans le source.</p>

<p>Une fois les erreurs corriges on synchronise pour voir si tout est
correct, on peut alors enregistrer le document corrig.</p>

<h4 id="peut1">On peut aussi modifier le type du document</h4>

<p>L'entre <strong>Modifier le doctype</strong> du menu
<strong>Fichier</strong> permet de modifier le type du document.</p>

<p>Si le document n'est pas un fichier XHTML bien form, Amaya propose de le
<strong>Recharger</strong> et donc de lire le document comme un document
HTML.</p>
</div>

<p></p>
</body>
</html>
