	{ Presentation Schema for Templates.
	  A. Tollenaere		& I. Vatton July 2005 }


PRESENTATION Template;

VIEWS
   Formatted_view,
   Structure_view merge with Structure_view;


#define STRUCT_INDENT 1.5
#define TAG_Font Helvetica
#define TAG_Color DarkGreen3
#define TAG_Weight Bold
#define TAG_Visibility 7
#define TAG_FONTSIZE 11 pt
#define ATTR_Font Helvetica
#define ATTR_Style Roman
#define ATTR_Weight Normal
#define ATTR_Visibility 6
#define INVALID_Style Roman
#define INVALID_Weight Normal
#define INVALID_Visibility 7
#define INVALID_Font Helvetica
#define ATTR_Color DarkGreen3
#define ATTRVALUE_Color DarkMagenta2
#define INVALID_Color Red
   
DEFAULT
   BEGIN
   Visibility: Enclosing =;
   VertRef: * . Left ;
   {HorizRef: Enclosed AnyElem . HRef;}
   HorizRef: * . Bottom - 2 px;
   Height: Enclosed . Height;
   Width: Enclosed . Width;
   VertPos: HRef = Previous . HRef;
   HorizPos: Left = Previous . Right;
   LineBreak: Yes;
   Font: Enclosing =;
   Style: Roman;
   Weight: Enclosing =;
   Size: Enclosing =;
   Indent: 0;
   Adjust: Left;
   LineSpacing: 1;
   Depth: Enclosing =;
   UnderLine: Enclosing =;
   Thickness: Enclosing =;
   LineStyle: Enclosing =;
   LineWeight: Enclosing =;
   Background: Enclosing =;
   Foreground: Enclosing =;
   FillPattern: Enclosing =;
   IN Structure_view BEGIN
	    VertPos: Top = Previous . Bottom;
	    HorizPos: Left = Enclosing . Left;
	    END;
   END;

BOXES
  AttrName: BEGIN
    Content: (Text ' ' AttributeName Text '=');
    Visibility: 0;
    IN Structure_view BEGIN
      HorizPos: Left = Previous . Right;
      VertPos: HRef = Previous . HRef;
      Size: TAG_FONTSIZE;
      Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
      Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
 	    END;
   END;

  AttrValue: BEGIN
    Content: (AttributeValue);
    Visibility: 0;
    IN Structure_view BEGIN
      HorizPos: Left = Previous . Right;
      VertPos: HRef = Previous . HRef;
      Size: TAG_FONTSIZE;
      Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
      Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
      END;
   END;

  AttrNameAndValue: BEGIN
    Content: (Text ' ' AttributeName Text '=' AttributeValue);
    Visibility: 0;
    IN Structure_view BEGIN
      HorizPos: Left = Previous . Right;
      VertPos: HRef = Previous . HRef;
      Size: TAG_FONTSIZE;
      Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
      Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
      END;
    END;
  
 ElementName: BEGIN
   Content: (ElemName);
   Visibility: 0;
	 IN Structure_view BEGIN
		 Size: TAG_FONTSIZE;
		 Font: TAG_Font;
		 Weight: TAG_Weight;
		 Visibility: TAG_Visibility;  Foreground: TAG_Color;
		 END;
	 END;

 VerticalLine: BEGIN
	 Content: Graphics 'W';
	 Visibility: 0;
	 IN Structure_view BEGIN
		 VertPos: Top = Creator . Top;
		 Height: Creator . Height;
		 Width: 1.1;
		 LineWeight: 1 px;
		 Visibility: TAG_Visibility;  Foreground: TAG_Color;
		 END;
	 END;

 UnknownAttrValue: BEGIN
	Content: (AttributeValue);
	Visibility: 0;
	IN Structure_view BEGIN
    HorizPos: Left = Previous . Right;
    VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
    Font: INVALID_Font;
		Style: INVALID_Style;
		Visibility: INVALID_Visibility;
		Foreground: INVALID_Color;
		END;	
	END;

 Unknown_End: BEGIN
	Content: Text '>';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: INVALID_Style;
		Visibility: INVALID_Visibility;
		Foreground: Creator =;
		END;
	END;

 UseButton: BEGIN
	Content: Picture 'xtigeruse.png';
	HorizPos: Left = Enclosing . Left;
	VertPos: Top = Enclosing . Top - 2 px;
	MarginTop: 0 px;
	MarginBottom: 0 px;
	MarginLeft: 0 px;
	MarginRight: 0 px;
  Inline: No;
	Depth: Creator - 2;
	IN Structure_view
		Visibility: 0;
	END;

 BagButton: BEGIN
	Content: Picture 'xtigerbag.png';
	HorizPos: Left = Enclosing . Left;
	VertPos: Top = Enclosing . Top - 8 px;
	MarginTop: 0 px;
	MarginBottom: 0 px;
	MarginLeft: 0 px;
	MarginRight: 0 px;
  Inline: No;
	Depth: Creator - 2;
	IN Structure_view
		Visibility: 0;
	END;

 OptionButton: BEGIN
	Content: Picture 'xtigeroption.png';
  HorizRef: * . Bottom;
	HorizPos: Left = Enclosing . Left;
	VertPos: Top = Enclosing . Top - 5 px;
	MarginTop: 0 px;
	MarginBottom: 0 px;
	MarginLeft: 0 px;
	MarginRight: 0 px;
  Inline: No;
	Depth: Creator - 2;
	IN Structure_view
		Visibility: 0;
	END;

 RepeatButton: BEGIN
	Content: Picture 'xtigerrepeat.png';
	HorizPos: Left = Enclosing . Left;
	VertPos: Top = Enclosing . Top - 10 px;
	MarginTop: 0 px;
	MarginBottom: 0 px;
	MarginLeft: 0 px;
	MarginRight: 0 px;
  Inline: No;
	Depth: Creator - 2;
	IN Structure_view
		Visibility: 0;
	END;

RULES

  head:
    BEGIN
    Visibility: 0;
    CreateBefore(ElementName);
  	CreateWith(VerticalLine);
  	IN Structure_view BEGIN
      Visibility: Enclosing =;
		  HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	    Width: Enclosing . Width - STRUCT_INDENT;
		  VertPos: Top = Previous . Bottom;
		  END;
    END;
    
  component:
		BEGIN
		Visibility: 0;
	  CreateBefore(ElementName);
	  CreateWith(VerticalLine);
  	IN Structure_view BEGIN
  	  Visibility: Enclosing =;
		  HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	    Width: Enclosing . Width - STRUCT_INDENT;
		  VertPos: Top = Previous . Bottom;
		  END;
	 END;

  union:
		BEGIN
		Visibility: 0;
	  CreateBefore(ElementName);
	  CreateWith(VerticalLine);
  	IN Structure_view BEGIN
  	  Visibility: Enclosing =;
		  HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	    Width: Enclosing . Width - STRUCT_INDENT;
		  VertPos: Top = Previous . Bottom;
		  END;
	 END;

  attribute:
		BEGIN
		Visibility: 0;
	  CreateBefore(ElementName);
	  CreateWith(VerticalLine);
  	IN Structure_view BEGIN
  	  Visibility: Enclosing =;
		  HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	    Width: Enclosing . Width - STRUCT_INDENT;
		  VertPos: Top = Previous . Bottom;
		  END;
	 END;

  folder: 
	BEGIN
		Width: auto{Enclosing . Width};
		Height: auto{Enclosing . Height};
		MarginTop: 3 px;
		VertPos: Top 			= 		Previous AnyElem . Bottom;
		HorizPos: Left 			=		Enclosing . Left;
{		BorderTopWidth: 	 	1 px;
		BorderLeftWidth: 		1 px;
		BorderBottomWidth		: 		1 px;
		BorderRightWidth		: 		1 px;
		BorderTopStyle: 		Dotted;
		BorderLeftStyle: 		Dotted;
		BorderBottomStyle		:	 	Dotted;
		BorderRightStyle		:	 	Dotted;
		BorderTopColor:		Violet;
		BorderLeftColor: 		Violet;
		BorderBottomColor		:	 	Violet;
		BorderRightColor		:	 	Violet;
		PaddingRight:		2 px;
		PaddingLeft	:		2 px;
		PaddingTop	:		2 px;
		PaddingBottom:		2 px;}
		IN Structure_view
		BEGIN
			BorderTopStyle		: 		None;
			BorderLeftStyle		: 		None;
			BorderBottomStyle	:	 	None;
			BorderRightStyle	:	 	None;
			PaddingRight		:		0 px;
			PaddingLeft:		0 px;
			PaddingTop:		0 px;
			PaddingBottom		:		0 px;
			BorderTopWidth		:	 	0 px;
			BorderLeftWidth		:		0 px;
			BorderBottomWidth	:	 	0 px;
			BorderRightWidth	:	 	0 px;					
		END;
	END;

  bag:
		BEGIN
    CreateBefore(ElementName);
	  CreateFirst(BagButton);
  	CreateWith(VerticalLine);
    Width: auto{Enclosing . Width};
    Height: auto{Enclosing . Height};
    LineBreak: No;
    {Display: Block;}
    VertPos: Top = 			Previous AnyElem . Bottom;
    HorizPos: Left =		Enclosing . Left; 
		BorderTopWidth: 	 	1 px;
		BorderLeftWidth: 		1 px;
		BorderBottomWidth: 	1 px;
		BorderRightWidth: 	1 px;
		BorderTopStyle: 		Dotted;
		BorderLeftStyle: 		Dotted;
		BorderBottomStyle: 	Dotted;
		BorderRightStyle: 	Dotted;
		BorderTopColor: 		Green;
		BorderLeftColor: 		Green;
		BorderBottomColor: 	Green;
		BorderRightColor: 	Green;
		PaddingRight: 			2 px;
		PaddingLeft: 				2 px;
		PaddingTop: 				8 px;
		PaddingBottom: 			2 px;
  	IN Structure_view BEGIN
			BorderTopWidth: 0;
			BorderLeftWidth: 0;
			BorderBottomWidth: 0;
		  BorderRightWidth: 0;
		  PaddingRight: 0;
		  PaddingLeft: 0;
		  PaddingTop: 0;
		  PaddingBottom: 0;
		  HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	    Width: Enclosing . Width - STRUCT_INDENT;
		  VertPos: Top = Previous . Bottom;
		  END;
	 END;
	 
  useEl:	
		BEGIN
    CreateBefore(ElementName);
    if empty
	     CreateFirst(UseButton);
  	CreateWith(VerticalLine);
    Width: auto{Enclosing . Width};
    Height: auto{Enclosing . Height};
    {LineBreak: No;}
    {Display: Inline;}
    VertPos: Top = 			Previous AnyElem . Bottom;
    HorizPos: Left =		Enclosing . Left; 
    if not immediately within option
      BEGIN
		  BorderTopWidth: 	 	1 px;
		  BorderLeftWidth: 		1 px;
		  BorderBottomWidth: 	1 px;
		  BorderRightWidth: 	1 px;
		  BorderTopStyle: 		Dotted;
		  BorderLeftStyle: 		Dotted;
		  BorderBottomStyle: 	Dotted;
		  BorderRightStyle: 	Dotted;
		  BorderTopColor: 		Blue;
		  BorderLeftColor: 		Blue;
		  BorderBottomColor: 	Blue;
		  BorderRightColor: 	Blue;
      END;
		PaddingRight: 			2 px;
		PaddingLeft: 				3 px;
		PaddingTop: 				2 px;
		PaddingBottom: 			2 px;
  	IN Structure_view BEGIN
			BorderTopWidth: 0;
			BorderLeftWidth: 0;
			BorderBottomWidth: 0;
		  BorderRightWidth: 0;
		  PaddingRight: 0;
		  PaddingLeft: 0;
		  PaddingTop: 0;
		  PaddingBottom: 0;
      FillPattern: nopattern;
		  HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	    Width: Enclosing . Width - STRUCT_INDENT;
		  VertPos: Top = Previous . Bottom;
		  END;
	 END;

  useSimple:	
		BEGIN
    CreateBefore(ElementName);
  	CreateWith(VerticalLine);
    Width: auto{Enclosing . Width};
    Height: auto{Enclosing . Height};
    {LineBreak: No;}
    {Display: Inline;}
    VertPos: Top = 			Previous AnyElem. Bottom;
    HorizPos: Left =		Enclosing . Left;
    if not immediately within option
      BEGIN
		  BorderTopWidth: 	 	1 px;
		  BorderLeftWidth: 		1 px;
		  BorderBottomWidth: 	1 px;
		  BorderRightWidth: 	1 px;
		  BorderTopStyle: 		Dotted;
		  BorderLeftStyle: 		Dotted;
		  BorderBottomStyle: 	Dotted;
		  BorderRightStyle: 	Dotted;
		  BorderTopColor: 		Blue;
		  BorderLeftColor: 		Blue;
		  BorderBottomColor: 	Blue;
		  BorderRightColor: 	Blue;
		  PaddingRight: 			2 px;
		  PaddingLeft: 				3 px;
		  PaddingTop: 				2 px;
		  PaddingBottom: 			2 px;
      END;
  	IN Structure_view BEGIN
			BorderTopWidth: 0;
			BorderLeftWidth: 0;
			BorderBottomWidth: 0;
		  BorderRightWidth: 0;
		  PaddingRight: 0;
		  PaddingLeft: 0;
		  PaddingTop: 0;
		  PaddingBottom: 0;
      FillPattern: nopattern;
		  HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	    Width: Enclosing . Width - STRUCT_INDENT;
		  VertPos: Top = Previous . Bottom;
		  END;
	 END;

  repeat:
	  BEGIN	
    CreateBefore(ElementName);
    CreateFirst(RepeatButton);
    CreateWith(VerticalLine);
    Width: auto{Enclosing . Width};
    {LineBreak: No;}
    {Display: Block;}
    VertPos: Top  	= Previous AnyElem . Bottom;
    MarginTop	: 3 px;
    HorizPos: Left  	= Enclosing . Left; 
    BorderTopWidth:  2 pt;
    BorderLeftWidth:  2 pt;
    BorderBottomWidth :  2 pt;
    BorderRightWidth :  2 pt;
    BorderTopStyle: Dotted;
    BorderLeftStyle:  Dotted;
    BorderBottomStyle :  Dotted;
    BorderRightStyle :  Dotted;
    BorderTopColor:  Purple;
    BorderLeftColor:  Purple;
    BorderBottomColor : Purple;
    BorderRightColor :  Purple;
    PaddingRight:  3 px;
    PaddingLeft	:  3 px;
    PaddingTop	: 10 px;
    PaddingBottom: 3 px; 
    IN Structure_view BEGIN
    	BorderTopWidth :  0;
    	BorderLeftWidth :	 	0;
    	BorderBottomWidth	: 0;
    	BorderRightWidth	: 0;
      PaddingRight: 0;
      PaddingLeft: 0;
      PaddingTop: 0;
      PaddingBottom: 0;
    	HorizPos: Left  = Enclosing . Left + STRUCT_INDENT;
    	Width	:  Enclosing . Width - STRUCT_INDENT;
    	VertPos	: Top  =  Previous . Bottom;
    END;
	 END;	 

  option:	
 BEGIN
    CreateBefore(ElementName);
	  CreateFirst(OptionButton);
  	CreateWith(VerticalLine);
    Width: auto{Enclosing . Width};
    Background : LightOrange4;
    FillPattern: backgroundcolor;
    ShowBox;
    {LineBreak: No;}
    {Display: Block;}
    VertPos: Top = Previous AnyElem . Bottom;
    MarginTop: 0;
    HorizPos: Left = Enclosing . Left; 
    BorderTopWidth: 1 pt;
    BorderLeftWidth: 1 pt;
    BorderBottomWidth: 1 pt;
    BorderRightWidth: 1 pt;
    BorderTopStyle: Dotted;
    BorderLeftStyle: Dotted;
    BorderBottomStyle: Dotted;
    BorderRightStyle: Dotted;
    BorderTopColor: Orange;
    BorderLeftColor: Orange;
    BorderBottomColor: Orange;
    BorderRightColor: Orange;
    PaddingRight:  	2 px;
    PaddingLeft:   2 px;
    PaddingTop:   2 px;
    PaddingBottom:  	2 px; 
  	IN Structure_view BEGIN
 	    BorderTopWidth: 0;
 	    BorderLeftWidth: 0;
 	    BorderBottomWidth: 0;
      BorderRightWidth: 0;
      PaddingRight: 0;
      PaddingLeft: 0;
      PaddingTop: 0;
      PaddingBottom: 0;
      HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	    Width: Enclosing . Width - STRUCT_INDENT;
      VertPos: Top = Previous . Bottom;
      END;
	 END;	 


ATTRIBUTES

  name:
  BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;    

  title:
  BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;    
	
  includeAt:
  BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;    

  exclude:
  BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;    

  src:
  BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;    
	
  minOccurs:
  BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;    

  maxOccurs:
  BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;    

  currentOccurs:
  BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;    

  types:
  BEGIN
	CreateBefore(AttrNameAndValue);
	END;    

  currentType:
  BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;    
	
  type:
  BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;    

  useAt:
  BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;    

  defaultAt:
  BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;    

  fixed:
  BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;    

  values:
  BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;    

  Unknown_attribute:
	BEGIN
	if TEXT_UNIT
	   CreateBefore(UnknownAttrValue);
	if PICTURE_UNIT
	   CreateBefore(UnknownAttrValue);
	if Unknown_namespace
	   CreateAfter(UnknownAttrValue);
	if Unknown_namespace and LastAttr
	   CreateAfter(Unknown_End);
	if NOT TEXT_UNIT and NOT PICTURE_UNIT and NOT Unknown_namespace
  	 CreateBefore(UnknownAttrValue);
	END;	

END
