/////////////////////////////////////////////////////////////////////////////
// Name:        cocoa/NSScroller.mm
// Purpose:     wxCocoaNSScroller
// Author:      David Elliott
// Modified by:
// Created:     2004/04/27
// RCS-ID:      $Id: NSScroller.mm,v 1.1.1.1 2005/07/06 09:30:49 gully Exp $
// Copyright:   (c) 2004 David Elliott
// Licence:     wxWindows licence
/////////////////////////////////////////////////////////////////////////////

#include "wx/wxprec.h"
#ifndef WX_PRECOMP
    #include "wx/log.h"
#endif // WX_PRECOMP

#include "wx/cocoa/NSScroller.h"
#import <AppKit/NSScroller.h>

WX_IMPLEMENT_OBJC_INTERFACE_HASHMAP(NSScroller)

// ============================================================================
// @class wxNSScrollerTarget
// ============================================================================
@interface wxNSScrollerTarget : NSObject
{
}

- (void)wxNSScrollerAction: (id)sender;
@end // wxNSScrollerTarget

@implementation wxNSScrollerTarget : NSObject
- (void)wxNSScrollerAction: (id)sender
{
    wxCocoaNSScroller *scroller = wxCocoaNSScroller::GetFromCocoa(sender);
    wxCHECK_RET(scroller,wxT("wxNSScrollerAction received without associated wx object"));
    scroller->Cocoa_wxNSScrollerAction();
}

@end // implementation wxNSScrollerTarget

// ============================================================================
// class wxCocoaNSScroller
// ============================================================================
const wxObjcAutoRefFromAlloc<struct objc_object*> wxCocoaNSScroller::sm_cocoaTarget = [[wxNSScrollerTarget alloc] init];

void wxCocoaNSScroller::AssociateNSScroller(WX_NSScroller cocoaNSScroller)
{
    if(cocoaNSScroller)
    {
        sm_cocoaHash.insert(wxCocoaNSScrollerHash::value_type(cocoaNSScroller,this));
        [cocoaNSScroller setTarget: sm_cocoaTarget];
        [cocoaNSScroller setAction: @selector(wxNSScrollerAction:)];
    }
}

