! file MathML.trans : structure transformation for MathML
! see HTML.trans for a description of Trans language
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

! WARNING : transformations do NOT work with Multiscript elements
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 
!!! Parenthesis Transformations

!surround an element with parentheses
mettre entre parenthses:*;
        {
        * > mrow:mo."(";
        * > mrow:*;
        * > mrow:mo.")";
        }

!surround a sequence of elements with parentheses
!group: first:*,?*+, last:* ;
!        {
!        first > mrow:mo."(";
!        first > mrow:*;
!        * > mrow:*;
!        last > mrow:*;
!        last > mrow:mo.")";
!        }

!remove parenthesis
retirer les parenthses: mrow{mf,?*+,mf};
	{
	mf /;
	* > :*;
	}

!!! mrow transformations

!surround an element with a mrow
englober dans un row: *;
        {
        * > mrow:*;
        }

!surround a sequence of elements with a mrow
englober dans un row: *,*+;
        {
        * > mrow:*;
        }

! remove a mrow level
retirer le row: mrow{*+};
        {
        * > :*;
        }

!!! mstyle transformations

!surround an element with a mstyle
englober dans un mstyle: *;
        {
        * > mstyle:*;
        }

!surround a sequence of elements with a mstyle
englober dans un mstyle: *,*+;
        {
        * > mstyle:*;
        }

! remove a mstyle level
retirer le mstyle: mstyle{*+};
        {
        * > :*;
        }

!!! Root Transformations

!surround an element with a root
englober dans une racine : *;
	{
	* > mroot:*;
	* > mroot:none % ;
	}

!surround a sequence of elements with a root
englober dans une racine: *+,last:*;
        {
        * > mroot.mrow:*;
	last > mroot.mrow:*;
	last > mroot:none % ;
        }

!remove a root
retirer la racine: mroot{base:*,? index:*};
        {
        base > :*;
	index / ;
        }


!!! Square Root Transformations

!surround an element with a square root
englober dans une racine carre: *;
        {
        * > msqrt:*;
        }


!surround a sequence of elements with a square root
englober dans une racine carret: *,*+;
        {
        * > msqrt.mrow:*;
        }

!remove a square root
retirer la racine carre: msqrt{*};
        {
        * > :*;
        }

!transform a square root into a root
racine avec index: msqrt{*};
	{
	* > mroot:*;
	* > mroot:none %;
	}

!transform a square root into a menclose
menclose: msqrt{*};
	{
	* > menclose:*;
	}

!!! menclose Transformations

!surround an element with a menclose
englober dans un menclose: *;
        {
        * > menclose:*;
        }


!surround a sequence of elements with a menclose
englober dans menclose: *,*+;
        {
        * > menclose:*;
        }

!remove a menclose
retirer le menclose: menclose{*};
        {
        * > :*;
        }

!transform a menclose into a square root
racine carre: menclose{*};
	{
	* > msqrt:*;
	}

!!! Fraction transformations

!transform 2 elements into a fraction
fraction: (num:*,den:*) | mrow{num:*,den:*};
        {
        num > mfrac:*;
        den > mfrac:*;
        }

!transform an  element into a numerator
numrateur: *;
        {
        * > mfrac:*;
        * > mfrac:none %;
        }

!transform an sequence of elements into a numerator
numrateur: ?*+,last:*;
        {
        * > mfrac.mrow:*;
	last > mfrac.mrow:*;
        last > mfrac:none %;
        }

!transform an element into a denominator
dnominateur: *;
        {
        * > mfrac:none %;
        * > mfrac:*;
        }

!transform an sequence of elements into a denominator
dnominateur: first:*,?*+;
        {
        first > mfrac:none %;
	first > mfrac.mrow:*;
        * > mfrac.mrow:*;
        }

!remove a fraction
retirer la fraction: mfrac{?(num:*),?(den:*)};
        {
        num > :*;
        den > :*;
        }


!!! Sub and Sup Transformations

!surroud an element with a subsup
ajouer subscript et superscript:*;
	{
	* > msubsup:*;
	* > msubsup:none%;
	* > msubsup:none;
	}

!removes a subsup
retirer le subsup: msubsup{base:*,?sub:*,?sup:*};
	{
	base > :*;
	sub /;
	sup /;
	}

!removes a superscript
retirer le superscript: msubsup{base:*,?sub:*,?sup:*};
	{
	msubsup > msub;
	sup /;
	}

!removes a subscript
retirer le subscript: msubsup{base:*,?sub:*,?sup:*};
	{
	msubsup > msup;
	sub /;
	}

!surroud element with a sub
ajouter le subscript:*;
	{
	* > msub:*;
	* > msub:none %;
	}

!removes a subscript
retirer le subscript: msub{base:*,?sub:*};
	{
	base > :*;
	sub /;
	}

!surroud an element with a sup
ajouter le superscript:*;
	{
	* > msup:*;
	* > msup:none %;
	}

!removes a superscript
retirer le superscript: msup{base:*,?sup:*};
	{
	base > :*;
	sup /;
	}

!change msub into msup
superscript:msub;
	{
	msub > msup;
	}

!change msup into msub
subscript:msup;
	{
	msup > msub;
	}

!change msub or msup into msubsup
subsup:msub{base:*,sub:*} | msup{base:*,sup:*};
	{
	base > msubsup:*;
	sup > msubsup:none %;
	sup > msubsup:*;
	sub > msubsup:*;
	sub > msubsup:none;
	}

!change msubsup into munderover
change into munderover: msubsup{base:*,sub:*,sup:*};
  {
  base > munderover:*;
  sub > munderover:*;
  sup > munderover:*;
  }

!!! Under and Over transformations

!surroud an element with a underover
add under and over:*;
	{
	* > munderover:*;
	* > munderover:none %;
	* > munderover:none;
	}

! remove an underover
retirer le under and over:munderover{base:*,?under:*,?over:*};
	{
	base > :*;
	under /;
	over /;
	}
 
!surroud an element with a over
add over:*;
	{
	* > mover:*;
	* > mover:none %;
	}

! remove an over
retirer le under and over:mover{base:*,?over:*};
	{
	base > :*;
	over /;
	}
 
!surroud an element with a under
ajouter un under:*;
	{
	* > munder:*;
	* > munder:none;
	}

! remove an under
retirer le under:munder{base:*,?under:*};
	{
	base > :*;
	under /;
	}

!change munderover into msubsup
changer en msubsup: munderover{base:*,under:*,over:*};
  {
  base > msubsup:*;
  under > msubsup:*;
  over > msubsup:*;
  }


