# $Id: Sender.pm,v 1.20 2003/03/05 20:21:20 bengen Exp $

package AMAVIS::Notify::Sender;
use strict;
use vars qw($VERSION);
$VERSION='0.1';
use POSIX qw(strftime setlocale LC_TIME);

use AMAVIS;
use AMAVIS::Logging;

use vars qw(
	    $cfg_sender
	   );

sub init {
  my $self = shift;
  my $args = shift;
  writelog($args,LOG_DEBUG,__PACKAGE__." initialized.");
  $cfg_sender = ($AMAVIS::cfg->val('Notify', 'mail from') or 'postmaster');;
  # Return successfully
  return 1;
}

sub notify {
  my $self = shift;
  my $args = shift;
  setlocale(LC_TIME, 'C');
  my $date = strftime("%a, %d %b %Y %H:%M:%S %z",localtime);
  setlocale(LC_TIME, '');
  my $recipient = $$args{'sender'};

  if ($recipient eq '<>') {
    writelog($args,LOG_DEBUG, __PACKAGE__.
	     ': Not warning sender: empty address.');
    return 1;
  }
  if (defined $$args{'bulkmail'}) {
    writelog($args,LOG_DEBUG, __PACKAGE__.
	     ': Not warning sender: mailing list/bulk mail.');
    return 1;
  }

  writelog($args,LOG_DEBUG, __PACKAGE__.
	   ': Warning sender: '.$recipient.'.');
  my $message = <<"EOF";
From: $cfg_sender
To: $recipient
Date: $date
Subject: Virus in mail from you.

Our virus checker has found potentially malicious code in a mail by
you. Delivery has been stopped. For further questions, please contact
$cfg_sender.

The recipient(s) for this message were:
EOF

  $message.=join "\n",@{$$args{'recipients'}};
  if (defined $$args{'quarantine_file'}) {
    $message.= << "EOF";


The message has been quarantined as $$args{'quarantine_file'}.

EOF
  };
  foreach my $scanner (@{$$args{'virus_scanners'}}) {
    $message.="\n$scanner found:\n";
    foreach my $virus (@{$$args{'found_viruses'}{$scanner}}) {
      $message.=" $virus\n";
    }
  }
  
  $message.="\n".('-'x 72)."\nMessage headers follow:\n";
  $message.=$$args{'headers'};
  
  $AMAVIS::mta->send_message($args, $message, '<>', $recipient)
    or writelog($args,LOG_ERR,"Error notifying sender: $recipient");

  return 1;
}

sub notify_unpack {
  my $self = shift;
  my $args = shift;
  # FIXME
  my $mail_recipients;

  if (!$mail_recipients) {
    $$args{headers} =~ /([[:cntrl:]]|^)To:\s*(.*)([[:cntrl:]]|$)/i;
    $mail_recipients = $2;
  }

  if (!$mail_recipients) {
    $mail_recipients = join "\n",@{$$args{'recipients'}};
  }

  my $recipient = $$args{'sender'};
  if ($recipient eq '<>') {
    writelog($args,LOG_DEBUG, __PACKAGE__.
	     ': Not warning sender: empty address.');
    return 1;
  }
  if (defined $$args{'bulkmail'}) {
    writelog($args,LOG_DEBUG, __PACKAGE__.
	     ': Not warning sender: mailing list/bulk mail.');
    return 1;
  }

  writelog($args,LOG_DEBUG, __PACKAGE__.
	   ': Warning sender: '.$recipient.'.');
  my $date = strftime("%a, %d %b %Y %H:%M:%S %z",localtime);
  my $message = <<"EOF";
From: $cfg_sender
To: $recipient
Date: $date
Subject: Message from you has been canceled.

Our virus checker found your e-mail in wrong MIME format or containing
invalid attachments.
Delivery has been stopped.

The recipient(s) for this message were: $mail_recipients.

EOF

  $message.="\n".('-'x 72)."\nMessage headers follow:\n";
  $message.=$$args{'headers'};
  
  $AMAVIS::mta->send_message($args, $message, '<>', $recipient)
    or writelog($args,LOG_ERR,"Error notifying sender: $recipient");

  return 1;
}

1;
